static char rcsid[] = "$Header: efs_file.c,v 820.1 86/12/04 19:47:35 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Allocate and free remote file descriptors
 * for the Extended File System.
 *
 * jam 840207-21-22
 * jam 840224-0409
 */

#include "../h/param.h"

#include "../vnet/vnet.h"
#include "../conn/conn.h"
#include "../rpc/rpc.h"
#include "../efs/efs.h"

struct efs_remoteFile	efs_remotes[EFS_MAXREMOTES];
struct efs_localFile	efs_locals[EFS_MAXLOCALS];
u_long			efs_seqnum = 0;

/*
 * Allocate a remote file descriptor if there
 * are any free ones left.  Mark the descriptor
 * as not free and return a pointer to it.  If
 * none are free return NULL.
 */
struct efs_remoteFile *
efs_allocRemoteFile()
{
#ifdef NOTYET
	register struct efs_remoteFile *remote;

	if (remote = efs_freeRemotes)
		efs_freeRemotes = remote->next;
	else
		remote = (efs_remoteFile_t *)
				calloc(sizeof(efs_remoteFile_t), C_WAIT);
	remote->next = efs_busyRemotes;
	efs_busyRemotes = remote;
	remote->conn = NULL;
	remote->state = EFS_FILE_OPEN;
	remote->nobulk = 0;
	remote->procflags = 0;
	efs_incStat(remoteFiles);
	return(remote);
#else NOTYET
	register struct efs_remoteFile *remote = &efs_remotes[0];

	for (; remote != &efs_remotes[EFS_MAXREMOTES]; ++remote)
		if (remote->state == EFS_FILE_FREE) {
			remote->conn = NULL;
			remote->state = EFS_FILE_OPEN;
			remote->nobulk = 0;
			remote->procflags = 0;
			efs_incStat(remoteFiles);
			return(remote);
		}
	efs_incTotal(remoteFull);
	return(NULL);
#endif NOTYET
}
/*
 * Allocate a local file descriptor which
 * represents a file opened by a remote node.
 */
struct efs_localFile *
efs_allocLocalFile()
{
	register struct efs_localFile *local = &efs_locals[0];

	for (; local != &efs_locals[EFS_MAXLOCALS]; ++local)
		if (local->state == EFS_FILE_FREE) {
			local->fp = NULL;
			local->state = EFS_FILE_OPEN;
			local->rfd = ++efs_seqnum * EFS_MAXLOCALS
						+ (local-efs_locals);
			local->procflags = 0;
			efs_incStat(localFiles);
			return(local);
		}
	efs_incTotal(localFull);
	return(NULL);
}
/*
 * Return the local file descriptor which is
 * associated with the given RFD number.  Return
 * NULL if the RFD is invalid.
 */
efs_localFile_t *
efs_rfdToLocal(rfd)
   u_long rfd;
{
	register efs_localFile_t *local = &efs_locals[binarymod(rfd, EFS_MAXLOCALS)];
	/* BUG should be a binarydiv */
	register int seqnum = rfd / EFS_MAXLOCALS;

	if (local->state == EFS_FILE_OPEN && local->rfd == rfd)
		return(local);
	return(NULL);
}
