static char rcsid[] = "$Header: efs_crash.c,v 820.1 86/12/04 19:47:31 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Crash recovery functions.
 *
 * jam 840222-28-0301
 */

#include "../h/param.h"

#include "../vnet/vnet.h"
#include "../conn/conn.h"
#include "../rpc/rpc.h"
#include "../efs/efs.h"

extern efs_remoteFile_t efs_remotes[];
extern efs_localFile_t efs_locals[];

/*
 * Free all active remote file descriptors
 * for the given node which has crashed.
 * For those files for which we were the
 * server close the files as well.
 */
efs_clientException(conn, exception)
   connection_t *conn;
   int exception;
{
	register efs_remoteFile_t *remote = &efs_remotes[0];

	if (exception != CONN_DOWN)
		return;
	/* BUG check against myconn */
	efs_incTotal(remoteCrashes);
	for (; remote != &efs_remotes[EFS_MAXREMOTES]; ++remote)
		if (remote->state == EFS_FILE_OPEN && remote->conn == conn) {
			remote->state = EFS_FILE_CRASHED;
			efs_incTotal(remoteDropped);
		}
}

efs_serverException(conn, exception)
   connection_t *conn;
   int exception;
{
	register efs_localFile_t *local = &efs_locals[0];

	/* BUG check against myconn and compare each conn below */
	for (; local != &efs_locals[EFS_MAXLOCALS]; ++local)
		if (local->state == EFS_FILE_OPEN && local->fp &&
		    local->conn == conn) {
			closef(local->fp, 0, 0);
			efs_freeLocalFile(local);
			efs_incTotal(localDropped);
		}
}
