/* rcsid[]="$Header: conn_packet.h,v 820.1 86/12/04 19:43:27 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * connection packet definition
 *
 *	Bakul Shah
 *
 * bvs 840517 -- original version
 * bvs 841025 -- version <00,01>
 *	o	Two new conn types have been added.
 *		Usinge them two nodes can resynchronize with each other
 *		once a connection is broken by one of them.
 *	o	Added comments and improved definitions' organization.
 */

/*
 * A conn packet tells us about the state of one or more nodes.
 * ``version'' number is the version number of the sender connection manager.
 * A node will accept a packet only if its major(version) matches
 * major(CONN_VERSION) for the node's conn manager.
 * ``type'' is the type of all conn records that follow the header.
 * ``count'' is the count of records that follow the packe header.
 */
typedef struct conn_packet {
	short		version;	/* packet version number */
	u_short		type;		/* type of the conn packet */
	u_short		count;		/* count of connection records */
/*	a list of connection records follows the header */
} conn_packet_t;

/*
 * Version number of the conn manager.
 * Increment minor(CONN_VERSION) by one
 * every time the conn manager is changed.
 * Increment major(CONN_VERSION) by one
 * if the packet size or definition of some sub-field
 * changes in an incompatable way.
 */
#define CONN_VERSION	0x0001

/*
 * conn_packet type
 */
#define CONN_GOING_DOWN		0	/* sender is going down soon */
#define CONN_IM_ALIVE		1	/* sender says he is alive */
#define CONN_BREAK_CONN		2	/* sender broke connection with us */
#define CONN_CLEAN_CONN		3	/* sender has completed cleanup */

#define CONN_MAX_TYPE		4	/* number of predefined types */

/*
 * Macros to access records following the packet header.
 */
#define conn_rec(p)	((conn_record_t *)&(p)[1])
#define conn_nextrec(p)	((conn_record_t *)((caddr_t)(p) + (p)->length))

/*
 * A conn record shows the state of a node.
 * ``node'' is a vnet address of the sender node (see ../vnet/vnet.h>.
 * ``groups'' the set is groups the sender belongs to.
 * At present every node belongs to the same default group.
 * The ``generation'' number changes every time conn is ``enabled''.
 * ``timeSinceUp'' is the number of seconds since the sender came up.
 * ``timeTillDown'' is the number of seconds
 * to scheduled shutdown time.
 * The sender name immediately follows the packet.
 */
typedef struct conn_record {
	u_short		length;
	node_t		node;
	long		groups;
	long		generation;
	long		timeSinceUp;
	long		timeTillDown;
/*	the name follows (possibly NULL terminated) */
} conn_record_t;

/*
 * The default group.
 * Initially every node belongs to this group.
 * define CONN_GROUPS if groups are to be used
 * for logical partitioning of the net.
 * Note that if a node belongs to more than one group,
 * the higher level software (like DFS or RPC) may
 * behave stragely.  CONN_GROUPS is not recommended!
 */
#define CONN_DEFAULT_GROUP	0

/*
 * macro to access name that follows the record header.
 */
#define conn_name(rec)	((char *)&(rec)[1])
