static char rcsid[] = "$Header: param.c,v 820.1 86/12/04 19:42:32 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	param.c	4.16	82/11/15	*/

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/socket.h"
#include "../h/dir.h"
#include "../h/quota.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/text.h"
#include "../h/inode.h"
#include "../h/file.h"
#include "../h/callout.h"
#include "../h/clist.h"
#include "../h/cmap.h"
#include "../h/mbuf.h"
#include "../h/kernel.h"
/*
 * System parameter formulae.
 *
 * This file is copied into each directory where we compile
 * the kernel; it should be modified there to suit local taste
 * if necessary.
 *
 * Compiled with -DHZ=xx -DTIMEZONE=x -DDST=x -DMAXUSERS=xx -DPROCSPERUSER=x
 */

int	hz	= HZ;
int	tick	= 1000000 / HZ;
struct	timezone tz = { TIMEZONE, DST };

#define	NPROC	(20 + PROCSPERUSER * MAXUSERS)
#define	MAXUPRC	NPROC		/* max processes per user */

int	maxusers = MAXUSERS;	/* Max # of users */
int	maxuprc	 = MAXUPRC;	/* Max # of users per uid process collection */
int     nmount	 = NMOUNT;
#ifdef QUOTA
int	nquota	 = (MAXUSERS *	  9)/7 + 3;
int	ndquot	 = (MAXUSERS*NMOUNT)/4 + NPROC;
#endif
int     nmbclusters  = NMBCLUSTERS;
int	procsPerUser = PROCSPERUSER;		/* # processes per "user" */

/*
 * The following values are now COMPUTED
 * in machine/startup.c AT STARTUP TIME
 * (by use of the same algorithms shown here:)
 */
int	nproc	 = NPROC;
int	usrptsize= NPROC;
int	ntext	 = 	          96 + MAXUSERS;      /* Sticky's load faster */
int	ninode	 =	(NPROC	+ 16 + MAXUSERS) + 32;
int	nfile	 = 16 * (NPROC	+ 16 + MAXUSERS) / 10 + 32;
int	nclist	 = 100		+ 16 * MAXUSERS;
int	ncallout = 16 +  NPROC;
int	nport	 = NPROC / 2;

/*
 * These are initialized at bootstrap time
 * to values dependent on memory size
 */
int	nbuf, nswbuf;

/*
 * These have to be allocated somewhere; allocating
 * them here forces loader errors if this file is omitted.
 */
struct	proc	*proc,	*procNPROC;
struct	text	*text,	*textNTEXT;
struct	inode	*inode,	*inodeNINODE;
struct	file	*file,	*fileNFILE;
struct 	callout	*callout;
struct	cblock	*cfree;
struct	buf	*buf,	*swbuf;
#ifdef	NeverUsed
short	*swsize;
int	*swpf;
#endif
char	*buffers;
struct	cmap *cmap, *ecmap;
#ifdef QUOTA
struct	quota *quota, *quotaNQUOTA;
struct	dquot *dquot, *dquotNDQUOT;
#endif
