/* rcsid[] = "$Header: ds.h,v 800.0 85/08/06 14:11:29 root Exp $" */
/* sccsid[] = "%W% %Y% %Q% %G%" */

#define DSBASE	0x880000		/* start address of display */
#define DSSIZE	0x10000		/* size of the display (0 or 0x10000) */

#define SCNOFS		96	/* bytes per display scan line */
#define SCNOFSS		48
#define SCNOFSI		24
#define DSCELLW		9	/* char cell width */
#define DSCELLH		16	/* char cell height */


#define dstox(c, dswnd)	(((c) * DSCELLW) % ((dswnd)->maxx+1))
#define dstoy(c, dswnd)	(((c) * DSCELLH) % ((dswnd)->maxy+1))
#define xtods(x) ((x) / DSCELLW)
#define ytods(y) ((y) / DSCELLH)
#define xtodsrem(x) ((x) % DSCELLW)
#define ytodsrem(y) ((y) % DSCELLH)

extern unsigned short vchset[][DSCELLW];
extern unsigned short hchset[][DSCELLH];

struct dswnd {
	/* byte offsets given to make debugging easier -- nothing magic about
	   them */
	struct dscset {
		int cslpch;		/* 0: scan lines per char (assume wide) */
		int bpch;		/* 4: bits per char (vert. height) */
		int frstch;		/* 8: first char code - ascii */
		int lastch;		/* C: last char code - ascii */
		int csmask;		/* 10: mask used in positioning cells */
	} dscset;
	int *home1;		/* 14: home location */
	int *home2;		/* 18: current address */
	short homeof;		/* 1C: bit offset of home location */
	int maxx;		/* 1E: right (horiz = 719): 56 * char cell ht - 1 */
	int maxy;		/* 22: bottom (horiz = 559: 120 * " - 1 */
	int wrbitofs;		/* 26: bit offset of current address */
	unsigned char nlines, ncols;
				/* 2A,2B: total #lines, #cols -- never changes
				   once it's set */
	unsigned char xpixdelta, ypixdelta;
				/* 2C,2D: current pixel location is decomposed into
				vt100w->curcol and dswnd->xpixdelta for x
				vt100w->curline and dswnd->ypixdelta for y
				xpixdelta is between 0 and DSCELLW-1
				ypixdelta is between 0 and DSCELLH-1
				*/
};

