/* rcsid[]="$Header: syscalls.c,v 820.1 86/12/04 19:58:37 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	syscalls.c	6.1	83/07/29	*/

/*
 * System call names.
 */
char *syscallnames[] = {
	"indir",		/*   0 = indir */
	"exit",			/*   1 = exit */
	"fork",			/*   2 = fork */
	"read",			/*   3 = read */
	"write",		/*   4 = write */
	"open",			/*   5 = open */
	"close",		/*   6 = close */
	"old wait",		/*   7 = old wait */
#ifdef BSDBUGFIX
	"creat",		/*   8 = creat */
	"link",			/*   9 = link */
#else BSDBUGFIX
	"old creat",		/*   8 = old creat */
	"old link",		/*   9 = link */
#endif BSDBUGFIX
	"unlink",		/*  10 = unlink */
	"execv",		/*  11 = execv */
	"chdir",		/*  12 = chdir */
	"old time",		/*  13 = old time */
	"mknod",		/*  14 = mknod */
	"chmod",		/*  15 = chmod */
	"chown",		/*  16 = chown; now 3 args */
	"old break",		/*  17 = old break */
#ifdef BSDBUGFIX
	"old stat",		/*  18 = old stat */
#else BSDBUGFIX
	"stat",			/*  18 = stat */
#endif BSDBUGFIX
	"lseek",		/*  19 = lseek */
	"getpid",		/*  20 = getpid */
	"mount",		/*  21 = mount */
#ifdef BSDBUGFIX
	"umount",		/*  22 = umount */
#else BSDBUGFIX
	"old umount",		/*  22 = umount */
#endif BSDBUGFIX
	"old setuid",		/*  23 = old setuid */
	"getuid",		/*  24 = getuid */
	"old stime",		/*  25 = old stime */
	"ptrace",		/*  26 = ptrace */
	"old alarm",		/*  27 = old alarm */
#ifdef BSDBUGFIX
	"old fstat",		/*  28 = old fstat */
#else BSDBUGFIX
	"fstat",		/*  28 = fstat */
#endif BSDBUGFIX
	"old pause",		/*  29 = opause */
	"old utime",		/*  30 = old utime */
#ifdef BSDBUGFIX
	"old stty - nosys",	/*  31 = old stty */
	"old gtty - nosys",	/*  32 = old gtty */
#else BSDBUGFIX
	"old stty",		/*  31 = old stty */
	"old gtty",		/*  32 = old gtty */
#endif BSDBUGFIX
	"access",		/*  33 = access */
	"old nice",		/*  34 = old nice */
	"old ftime",		/*  35 = old ftime */
	"sync",			/*  36 = sync */
#ifdef BSDBUGFIX
	"kill",			/*  37 = kill */
	"stat",			/*  38 = stat */
#else BSDBUGFIX
	"old kill",		/*  37 = old kill */
	"#38 -- 4.1a select",	/*  38 = nosys */
#endif BSDBUGFIX
	"old setpgrp",		/*  39 = old setpgrp */
	"lstat",		/*  40 = lstat */
	"dup",			/*  41 = dup */
	"pipe",			/*  42 = pipe */
	"old times",		/*  43 = old times */
#ifdef BSDBUGFIX
	"profil",		/*  44 = profil */
#else BSDBUGFIX
	"old profil - nosys",	/*  44 = old profil */
#endif BSDBUGFIX
	"#45",			/*  45 = nosys */
	"old setgid",		/*  46 = old setgid */
	"getgid",		/*  47 = getgid */
	"old signal",		/*  48 = old sig */
	"#49",			/*  49 = reserved for USG */
	"#50",			/*  50 = reserved for USG */
	"acct",			/*  51 = turn acct off/on */
	"old phys - nosys",	/*  52 = old set phys addr */
	"old lock - nosys",	/*  53 = old lock in core */
	"ioctl",		/*  54 = ioctl */
	"reboot",		/*  55 = reboot */
	"old mpx - nosys",	/*  56 = old mpxchan */
	"symlink",		/*  57 = symlink */
	"readlink",		/*  58 = readlink */
	"execve",		/*  59 = execve */
	"umask",		/*  60 = umask */
	"chroot",		/*  61 = chroot */
#ifdef BSDBUGFIX
	"fstat",		/*  62 = fstat */
#else BSDBUGFIX
	"#62",			/*  62 = nosys */
#endif BSDBUGFIX
	"#63",			/*  63 = used internally */
	"getpagesize",		/*  64 = getpagesize */
	"mremap",		/*  65 = mremap */
	"vfork",		/*  66 = vfork */
	"old vread - read",	/*  67 = old vread */
	"old vwrite - write",	/*  68 = old vwrite */
	"sbrk",			/*  69 = sbrk */
	"sstk",			/*  70 = sstk */
	"mmap",			/*  71 = mmap */
	"old vadvise",		/*  72 = old vadvise */
	"munmap",		/*  73 = munmap */
	"mprotect",		/*  74 = mprotect */
	"madvise",		/*  75 = madvise */
	"vhangup",		/*  76 = vhangup */
	"old vlimit",		/*  77 = old vlimit */
	"mincore",		/*  78 = mincore */
	"getgroups",		/*  79 = getgroups */
	"setgroups",		/*  80 = setgroups */
	"getpgrp",		/*  81 = getpgrp */
	"setpgrp",		/*  82 = setpgrp */
	"setitimer",		/*  83 = setitimer */
#ifdef BSDBUGFIX
	"wait",			/*  84 = wait */
	"swapon",		/*  85 = swapon */
#else BSDBUGFIX
	"#84",			/*  84 = nosys */
	"old swapon",		/*  85 = old swapon */
#endif BSDBUGFIX
	"getitimer",		/*  86 = getitimer */
	"gethostname",		/*  87 = gethostname */
	"sethostname",		/*  88 = sethostname */
	"getdtablesize",	/*  89 = getdtablesize */
	"dup2",			/*  90 = dup2 */
	"getdopt",		/*  91 = getdopt */
#ifdef BSDBUGFIX
	"fcntl",		/*  92 = fcntl */
#else BSDBUGFIX
	"wrap",			/*  92 = wrap */
#endif BSDBUGFIX
	"select",		/*  93 = select */
	"setdopt",		/*  94 = setdopt */
	"fsync",		/*  95 = fsync */
	"setpriority",		/*  96 = setpriority */
	"socket",		/*  97 = socket */
	"connect",		/*  98 = connect */
	"accept",		/*  99 = accept */
	"getpriority",		/* 100 = getpriority */
	"send",			/* 101 = send */
	"recv",			/* 102 = recv */
/*
 * Valid's 4.2bsd will maintain compatibility
 * with 4.1c 'socketaddr()' facility.
 */
	"socketaddr",		/* 103 = socketaddr */
	"bind",			/* 104 = bind */
#ifdef BSDBUGFIX
	"setsockopt",		/* 105 = setsockopt */
#else BSDBUGFIX
	"#105",			/* 105 = nosys */
#endif BSDBUGFIX
	"listen",		/* 106 = listen */
	"old vtimes",		/* 107 = old vtimes */
	"sigvec",		/* 108 = sigvec */
	"sigblock",		/* 109 = sigblock */
	"sigsetmask",		/* 110 = sigsetmask */
	"sigpause",		/* 111 = sigpause */
	"sigstack",		/* 112 = sigstack */
	"recvmsg",		/* 113 = recvmsg */
	"sendmsg",		/* 114 = sendmsg */
#ifdef TRACE
	"vtrace",		/* 115 = vtrace */
#else
	"#115",			/* 115 = nosys */
#endif
	"gettimeofday",		/* 116 = gettimeofday */
	"getrusage",		/* 117 = getrusage */
#ifdef BSDBUGFIX
	"getsockopt",		/* 118 = getsockopt */
#else BSDBUGFIX
	"#118",			/* 118 = nosys */
#endif BSDBUGFIX
#ifdef s32
	"#119",			/* 119 = nosys */
#else s32
	"resuba",		/* 119 = resuba */
#endif s32
	"readv",		/* 120 = readv */
	"writev",		/* 121 = writev */
	"settimeofday",		/* 122 = settimeofday */
	"fchown",		/* 123 = fchown */
	"fchmod",		/* 124 = fchmod */
	"recvfrom",		/* 125 = recvfrom */
	"setreuid",		/* 126 = setreuid */
	"setregid",		/* 127 = setregid */
	"rename",		/* 128 = rename */
	"truncate",		/* 129 = truncate */
	"ftruncate",		/* 130 = ftruncate */
	"flock",		/* 131 = flock */
#ifdef BSDBUGFIX
	"old portal - nosys",	/* 132 = old portal */
#else BSDBUGFIX
	"portal",		/* 132 = portal */
#endif BSDBUGFIX
	"sendto",		/* 133 = sendto */
	"shutdown",		/* 134 = shutdown */
	"socketpair",		/* 135 = socketpair */
	"mkdir",		/* 136 = mkdir */
	"rmdir",		/* 137 = rmdir */
	"utimes",		/* 138 = utimes */
#ifdef BSDBUGFIX
	"old getdprop - nosys",	/* 139 = used internally */
	"old revoke - nosys",	/* 140 = old revoke */
	"getpeername",		/* 141 = getpeername */
#else BSDBUGFIX
	"getdprop",		/* 139 = getdprop */
	"revoke",		/* 140 = revoke */
	"unmount",		/* 141 = unmount */
#endif BSDBUGFIX
	"gethostid",		/* 142 = gethostid */
	"sethostid",		/* 143 = sethostid */
	"getrlimit",		/* 144 = getrlimit */
	"setrlimit",		/* 145 = setrlimit */
	"killpg",		/* 146 = killpg */
	"#147",			/* 147 = nosys */
	"setquota",		/* 148 = setquota */
	"qquota",		/* 149 = qquota */
	"getsockname",		/* 150 = getsockname */
#ifdef s32
	"#151",			/* 151 = nosys */
	"#152",			/* 152 = nosys */
	"#153",			/* 153 = nosys */
	"#154",			/* 154 = nosys */
	"#155",			/* 155 = nosys */
	"#156",			/* 156 = nosys */
	"#157",			/* 157 = nosys */
	"#158",			/* 158 = nosys */
	"#159",			/* 159 = nosys */
	"#160",			/* 160 = nosys */
	"#161",			/* 161 = nosys */
	"#162",			/* 162 = nosys */
	"#163",			/* 163 = nosys */
	"#164",			/* 164 = nosys */
	"#165",			/* 165 = nosys */
	"#166",			/* 166 = nosys */
	"#167",			/* 167 = nosys */
	"#168",			/* 168 = nosys */
	"#169",			/* 169 = nosys */
	"lockmem",		/* 170 = lockmem */
	"setsighandler",	/* 171 = setsighandler */
#ifdef UPAGECWD
	"getcwd",		/* 172 = getcwd */
#else UPAGECWD
	"#172",			/* 172 = nosys */
#endif UPAGECWD
#ifdef s32	/* GETSYSERROR */
	"getsyserror",		/* 173 = getsyserror */
#else s32	/* GETSYSERROR */
	"#173",			/* 173 = nosys */
#endif s32	/* GETSYSERROR */
#endif s32
};

#ifdef SYSCALLARGS
char *syscallargs[] = {
	0,		/*   0 = indir */
	0,			/*   1 = exit */
	0,			/*   2 = fork */
	0,			/*   3 = read */
	0,		/*   4 = write */
	"sxx",			/*   5 = open */
	0,		/*   6 = close */
	0,		/*   7 = old wait */
#ifdef BSDBUGFIX
	0,		/*   8 = creat */
	0,			/*   9 = link */
#else BSDBUGFIX
	0,		/*   8 = old creat */
	"ssx",		/*   9 = link */
#endif BSDBUGFIX
	"sx",		/*  10 = unlink */
	0,		/*  11 = execv */
	0,		/*  12 = chdir */
	0,		/*  13 = old time */
	0,		/*  14 = mknod */
	0,		/*  15 = chmod */
	0,		/*  16 = chown; now 3 args */
	0,		/*  17 = old break */
#ifdef BSDBUGFIX
	0,		/*  18 = old stat */
#else BSDBUGFIX
	0,			/*  18 = stat */
#endif BSDBUGFIX
	0,		/*  19 = lseek */
	0,		/*  20 = getpid */
	0,		/*  21 = mount */
#ifdef BSDBUGFIX
	0,		/*  22 = umount */
#else BSDBUGFIX
	0,		/*  22 = umount */
#endif BSDBUGFIX
	0,		/*  23 = old setuid */
	0,		/*  24 = getuid */
	0,		/*  25 = old stime */
	0,		/*  26 = ptrace */
	0,		/*  27 = old alarm */
#ifdef BSDBUGFIX
	0,		/*  28 = old fstat */
#else BSDBUGFIX
	0,		/*  28 = fstat */
#endif BSDBUGFIX
	0,		/*  29 = opause */
	0,		/*  30 = old utime */
#ifdef BSDBUGFIX
	0,	/*  31 = old stty */
	0,	/*  32 = old gtty */
#else BSDBUGFIX
	0,		/*  31 = old stty */
	0,		/*  32 = old gtty */
#endif BSDBUGFIX
	0,		/*  33 = access */
	0,		/*  34 = old nice */
	0,		/*  35 = old ftime */
	0,			/*  36 = sync */
#ifdef BSDBUGFIX
	0,			/*  37 = kill */
	0,			/*  38 = stat */
#else BSDBUGFIX
	0,		/*  37 = old kill */
	0,	/*  38 = nosys */
#endif BSDBUGFIX
	0,		/*  39 = old setpgrp */
	0,		/*  40 = lstat */
	0,			/*  41 = dup */
	0,			/*  42 = pipe */
	0,		/*  43 = old times */
#ifdef BSDBUGFIX
	0,		/*  44 = profil */
#else BSDBUGFIX
	0,	/*  44 = old profil */
#endif BSDBUGFIX
	0,			/*  45 = nosys */
	0,		/*  46 = old setgid */
	0,		/*  47 = getgid */
	0,		/*  48 = old sig */
	0,			/*  49 = reserved for USG */
	0,			/*  50 = reserved for USG */
	0,			/*  51 = turn acct off/on */
	0,	/*  52 = old set phys addr */
	0,	/*  53 = old lock in core */
	0,		/*  54 = ioctl */
	0,		/*  55 = reboot */
	0,	/*  56 = old mpxchan */
	0,		/*  57 = symlink */
	0,		/*  58 = readlink */
	"sxx",		/*  59 = execve */
	0,		/*  60 = umask */
	0,		/*  61 = chroot */
#ifdef BSDBUGFIX
	0,		/*  62 = fstat */
#else BSDBUGFIX
	0,			/*  62 = nosys */
#endif BSDBUGFIX
	0,			/*  63 = used internally */
	0,		/*  64 = getpagesize */
	0,		/*  65 = mremap */
	0,		/*  66 = vfork */
	0,	/*  67 = old vread */
	0,	/*  68 = old vwrite */
	0,			/*  69 = sbrk */
	0,			/*  70 = sstk */
	0,			/*  71 = mmap */
	0,		/*  72 = old vadvise */
	0,		/*  73 = munmap */
	0,		/*  74 = mprotect */
	0,		/*  75 = madvise */
	0,		/*  76 = vhangup */
	0,		/*  77 = old vlimit */
	0,		/*  78 = mincore */
	0,		/*  79 = getgroups */
	0,		/*  80 = setgroups */
	0,		/*  81 = getpgrp */
	0,		/*  82 = setpgrp */
	0,		/*  83 = setitimer */
#ifdef BSDBUGFIX
	0,			/*  84 = wait */
	0,		/*  85 = swapon */
#else BSDBUGFIX
	0,			/*  84 = nosys */
	0,		/*  85 = old swapon */
#endif BSDBUGFIX
	0,		/*  86 = getitimer */
	0,		/*  87 = gethostname */
	0,		/*  88 = sethostname */
	0,	/*  89 = getdtablesize */
	0,			/*  90 = dup2 */
	0,		/*  91 = getdopt */
#ifdef BSDBUGFIX
	0,		/*  92 = fcntl */
#else BSDBUGFIX
	0,			/*  92 = wrap */
#endif BSDBUGFIX
	0,		/*  93 = select */
	0,		/*  94 = setdopt */
	0,		/*  95 = fsync */
	0,		/*  96 = setpriority */
	0,		/*  97 = socket */
	0,		/*  98 = connect */
	0,		/*  99 = accept */
	0,		/* 100 = getpriority */
	0,			/* 101 = send */
	0,			/* 102 = recv */
#ifdef BSDBUGFIX
	0,	/* 103 = socketaddr */
#else BSDBUGFIX
	0,		/* 103 = socketaddr */
#endif BSDBUGFIX
	0,			/* 104 = bind */
#ifdef BSDBUGFIX
	0,		/* 105 = setsockopt */
#else BSDBUGFIX
	0,			/* 105 = nosys */
#endif BSDBUGFIX
	0,		/* 106 = listen */
	0,		/* 107 = old vtimes */
	0,		/* 108 = sigvec */
	0,		/* 109 = sigblock */
	0,		/* 110 = sigsetmask */
	0,		/* 111 = sigpause */
	0,		/* 112 = sigstack */
	0,		/* 113 = recvmsg */
	0,		/* 114 = sendmsg */
#ifdef TRACE
	0,		/* 115 = vtrace */
#else
	0,			/* 115 = nosys */
#endif
	0,		/* 116 = gettimeofday */
	0,		/* 117 = getrusage */
#ifdef BSDBUGFIX
	0,		/* 118 = getsockopt */
#else BSDBUGFIX
	0,			/* 118 = nosys */
#endif BSDBUGFIX
#ifdef s32
	0,			/* 119 = nosys */
#else s32
	0,		/* 119 = resuba */
#endif s32
	0,		/* 120 = readv */
	0,		/* 121 = writev */
	0,		/* 122 = settimeofday */
	0,		/* 123 = fchown */
	0,		/* 124 = fchmod */
	0,		/* 125 = recvfrom */
	0,		/* 126 = setreuid */
	0,		/* 127 = setregid */
	0,		/* 128 = rename */
	0,		/* 129 = truncate */
	0,		/* 130 = ftruncate */
	0,		/* 131 = flock */
#ifdef BSDBUGFIX
	0,	/* 132 = old portal */
#else BSDBUGFIX
	0,		/* 132 = portal */
#endif BSDBUGFIX
	0,		/* 133 = sendto */
	0,		/* 134 = shutdown */
	0,		/* 135 = socketpair */
	0,		/* 136 = mkdir */
	0,		/* 137 = rmdir */
	0,		/* 138 = utimes */
#ifdef BSDBUGFIX
	0,	/* 139 = used internally */
	0,	/* 140 = old revoke */
	0,		/* 141 = getpeername */
#else BSDBUGFIX
	0,		/* 139 = getdprop */
	0,		/* 140 = revoke */
	0,		/* 141 = unmount */
#endif BSDBUGFIX
	0,		/* 142 = gethostid */
	0,		/* 143 = sethostid */
	0,		/* 144 = getrlimit */
	0,		/* 145 = setrlimit */
	0,		/* 146 = killpg */
	0,			/* 147 = nosys */
	0,		/* 148 = setquota */
	0,		/* 149 = qquota */
	0,		/* 150 = getsockname */
#ifdef s32
	0,			/* 151 = nosys */
	0,			/* 152 = nosys */
	0,			/* 153 = nosys */
	0,			/* 154 = nosys */
	0,			/* 155 = nosys */
	0,			/* 156 = nosys */
	0,			/* 157 = nosys */
	0,			/* 158 = nosys */
	0,			/* 159 = nosys */
	0,			/* 160 = nosys */
	0,			/* 161 = nosys */
	0,			/* 162 = nosys */
	0,			/* 163 = nosys */
	0,			/* 164 = nosys */
	0,			/* 165 = nosys */
	0,			/* 166 = nosys */
	0,			/* 167 = nosys */
	0,			/* 168 = nosys */
	0,			/* 169 = nosys */
	0,		/* 170 = lockmem */
	0,	/* 171 = setsighandler */
#ifdef UPAGECWD
	0,		/* 172 = getcwd */
#else UPAGECWD
	0,			/* 172 = nosys */
#endif UPAGECWD
#ifdef s32	/* GETSYSERROR */
	0,		/* 173 = getsyserror */
#else s32	/* GETSYSERROR */
	0,			/* 173 = nosys */
#endif s32	/* GETSYSERROR */
#endif s32
};
#endif
