static char rcsid[] = "$Header: ufs_syscalls.c,v 86.1 86/07/21 14:57:41 bog Exp $";

/************************************************************************\
**									**
**				Copyright 1986				**
**			VALID LOGIC SYSTEMS INCORPORATED		**
**									**
**	This listing contains confidential proprietary information	**
**	which is not to be disclosed to unauthorized persons without	**
**	written consent of an officer of Valid Logic Systems 		**
**	Incoroporated.							**
**									**
**	The copyright notice appearing above is included to provide	**
**	statutory protection in the event of unauthorized or 		**
**	unintentional public disclosure.				**
**									**
\************************************************************************/

/* #include "../h/systm.h" */
/* #include "../s32/cpu.h"		/* For K_A */
/* #include "../h/dir.h" */
/* #include "../h/quota.h" */
/* #include "../h/user.h" */
/*#include "../h/kernel.h" */
#include "../h/types.h"
#include "../h/param.h"
#include "../h/file.h"
/* #include "../h/stat.h" */
#include "../h/inode.h"
#include "../h/fs.h"
/* #include "../h/buf.h" */
#include "../h/proc.h"
/* #include "../h/uio.h" */
/* #include "../h/socket.h" */
/* #include "../h/socketvar.h" */
/* #include "../h/nami.h" */
/* #include "../h/mount.h" */

#include "saio.h"	/* Standalone stuff. */

/*
 * External special stuff.
 */
extern struct inode *ialloc();
extern int sysdebug;	/* System debugging statements enabled (sys.c) */
extern int errno;	/* Error number, like UNIX. */
extern struct timeval time;	/* Current concept of time (toplevel.c).    */
extern int cmask;		/* Current file creation mask (toplevel.c). */

/*
 * Maknode:  allocate a new (previously unused in the file system) inode.
 * Standalone version returns the number of the inode allocated.
 */
ino_t
maknode(io,mode)
	struct iob *io;
	int mode;
{
	register struct inode *ip;
	register ino_t ipref;

	/*
	 * Select preferred inode number:
	 */
	if ((mode & IFMT) == IFDIR)
		/*
		 * Follow FFS paradigm for placement of directory.
		 * (I.E. new directories in same CG, &c, &c...)
		 */
		ipref = dirpref(io->i_fs);
	else
		/*
		 * When I grow up, I want to be an inode just like Daddy!
		 */
		ipref = io->i_ino.i_number;
	ip = ialloc(io, ipref, mode); /* Allocate a free inode on disk */
	if (ip == NULL) {
		/*
		 * Couldn't allocate.
		 */
		if (sysdebug)
			printf("maknode: Couldn't allocate inode.\n");
		return (NULL);
	}
	/*
	 * Lay down the standard "new inode" bits.
	 */
	ip->i_flag |= IACC|IUPD|ICHG;
	if ((mode & IFMT) == 0)
		mode |= IFREG;
	ip->i_mode = mode & ~cmask;
	ip->i_nlink = 1;
#ifdef notyet
	ip->i_uid = u.u_uid;
	ip->i_gid = u.u_pdir->i_gid;
#else  notyet
	ip->i_uid = 0;	/* Root */
	ip->i_gid = 0;	/* Root's club. */
#endif notyet
	if (ip->i_mode & ISGID)
		ip->i_mode &= ~ISGID;
	/*
	 * Update inode information on disk.
	 *
	 * Question: which inode pointer is io->i_ino?
	 */
	if (iupdat(io, &time, &time) < 0)
		if (sysdebug)
			printf("Maknode: iupdat blew up.\n");
	return (ip->i_number);
}

