/* static char rcsid[] = "$Header: utils.c,v 1.4 85/06/28 09:27:48 root Exp $" */

/************************************************************************
 *									*
 *				Copyright 1984				*
 *			VALID LOGIC SYSTEMS INCORPORATED		*
 *									*
 *	This listing contains confidential proprietary information	*
 *	which is not to be disclosed to unauthorized persons without	*
 *	written consent of an officer of Valid Logic Systems 		*
 *	Incoroporated.							*
 *									*
 *	The copyright notice appearing above is included to provide	*
 *	statutory protection in the event of unauthorized or 		*
 *	unintentional public disclosure.				*
 *									*
 ************************************************************************/


#include <sys/types.h>
#include "erm.h"
#include "cpu.h"

extern u_long acc;
extern char erm_cmd_buf[];
extern char cmd[];
extern u_char erm_inp_radix;
extern u_long	narg;
extern char	*varg[];

/*
 * lowercase -- turn an alpha character into lowercase alpha
 */
char
lowercase(c)
	register u_char c;
{
	if (c >= 'A' && c <= 'Z')
		c += 0x20;	/* 'A' - 'a' */
	return(c);
}


/*
 * fillcmdbuf - Fill the command buffer
 */

fillcmdbuf ()
{
	register u_int index = 0;
	register char *ptr = erm_cmd_buf;

	while ((*ptr = getchar ()) != '\n' && *ptr != '\r')
	 {
		if (*ptr == '\b')
			if (index == 0)
				putchar (BELL);
			else {
				printf(" \b");
				ptr--;
				index--;
			 }
		else if (*ptr == DEL)	/* Delete = kill line */
			if (index == 0) putchar (BELL);
			else {
				while (index--) printf("\b \b");
				index = 0;
				ptr = erm_cmd_buf;
			 }
		else if (++index == ERM_CMDBUF_SIZE) {
			index--;
			ptr--;
			putchar (BELL);
		 }
		else ptr ++;
	 }
	bcopy(erm_cmd_buf,cmd,ERM_CMDBUF_SIZE);
	ptr = cmd;
	for (narg=0;;) {		/* build arg pointer vector */
		while (isspace(ptr))	/* skip leading blanks */
			ptr++;
		if (*ptr == '\n' || *ptr == '\r')/* if \n stopped scan - done */
			break;
		varg[narg++] = ptr;	/* begin a string */
		while (isalnum(ptr))
			ptr++ ;	
		if (*ptr == '\n' || *ptr == '\r'){
			*ptr = '\0';	/* null terminate string */
			break;
		}
		*ptr++ = '\0';		/* null terminate string */
	}
}	
	
/*
	is alpha numeric
*/

isalnum(chr)
char	*chr;
{
	if ((*chr >= 'a' &&  *chr <= 'z') ||
	    (*chr >= '0' &&  *chr <= '9')) 
		return TRUE;
	return FALSE;
}
/*
	is white space
*/
isspace(chr)
char	*chr;
{
	if (*chr == ' ' || *chr == '\t')
		return TRUE;
	return FALSE;
}

/*
 * getnum -- get number terminated by <cr>; put into accumulator
 */
getnum(addr, bufindx)
u_long *addr;
{
	register char *ptr;
	register retval,ishex;

	if (bufindx == -1){
		fillcmdbuf ();
		ptr = erm_cmd_buf;
	}
	else 
		ptr = &erm_cmd_buf[bufindx];
	retval = 0;
	while (isspace(ptr))		/* ship white space */
		ptr++;
	if (*ptr == '\n' || *ptr =='\r')
		retval = 1;
	else {
		for (acc = 0,ishex = TRUE;ishex;){
			if (*ptr >= '0' && *ptr <= '9')
				acc = acc*16 + *ptr++ - '0';
			else if (*ptr >= 'a' && *ptr <= 'f')
				acc = acc*16  + *ptr++ - 'a' + 10;
			else 
				ishex = FALSE; 	/* not hex digit */
			
		}
		if (*ptr != '\n' && *ptr !='\r')
			retval = 2;
	 }
	if (addr) *addr = acc;
	return retval;
}
	

/*
 * dummy - dummy routine
 */
dummy(){}

