/* static char rcsid[] = "$Header: trap.c,v 1.3 85/06/26 13:50:38 root Exp $" */

/************************************************************************
 *									*
 *				Copyright 1984				*
 *			VALID LOGIC SYSTEMS INCORPORATED		*
 *									*
 *	This listing contains confidential proprietary information	*
 *	which is not to be disclosed to unauthorized persons without	*
 *	written consent of an officer of Valid Logic Systems 		*
 *	Incoroporated.							*
 *									*
 *	The copyright notice appearing above is included to provide	*
 *	statutory protection in the event of unauthorized or 		*
 *	unintentional public disclosure.				*
 *									*
 ************************************************************************/

#include <sys/types.h>
#include "erm.h"
#include "setjmp.h"

extern u_char erm_disasm_buf[];
extern u_long *erm_regsave;
extern u_char erm_start, erm_trace_type, erm_bpt_trace;
extern u_long erm_trace;
extern struct bpt bpts[];
extern jmp_buf bpt_jmpbuf;

extern bpttrap ();

/*
 *	bpttrap - implements the break point routine.
 */
	asm(".globl bpttrap");

asm("bpttrap:");
	asm("clrw	sp@-");
	asm("moveml	#0xFFFF, sp@-");
	asm("movl	sp, erm_regsave");
	asm("jsr	bpt_trap");
	asm("moveml	sp@+, #0xFFFF");
	asm("addql	#2, sp");
	asm("rte");

/*
 * initvecs -- Initialize 68000 trap vectors
 */
erm_initvecs()
{
	register u_long *p = 0;
	register int i = 0;
	
		p[9] = p[47] = (u_long) bpttrap;
}

/*
 * trap15 - execute a trap which will place you in the debugger
 */
trap15()
{
	asm ("trap #15");
	return;
}

/*
 *	bpt_trap - called by interrupt routine to handle break points.
 */
bpt_trap ()
{
	register struct bpt *bpt_ptr;
	register u_short *bpt_pc;

	if (!erm_start && !(erm_regsave[ERM_SR] & ERM_TRACE_BIT))
		erm_regsave[ERM_PC] -= 2;
	bpt_pc = (u_short *) erm_regsave [ERM_PC];
	if (erm_regsave [ERM_SR] & ERM_TRACE_BIT)
	 {
		if (--erm_trace) return;
		erm_regsave [ERM_SR] &= ~ERM_TRACE_BIT;
		if (erm_bpt_trace) goto tracing;
	 }
	else if (!erm_start)
		printf ("Breakpoint at %x\n", bpt_pc);
	erm_start = 0;
	bpt_reset ();
	dispregs ();
	disasm (bpt_pc, erm_disasm_buf);
	printf ("%x: %s\n", bpt_pc, erm_disasm_buf);
	if (!erm_setjmp (bpt_jmpbuf))
		do_cmd ();
	if (erm_trace) return;
	bpt_pc = (u_short *) erm_regsave [ERM_PC];
	for (bpt_ptr = bpts; bpt_ptr < &bpts[ERM_MAXBPT]; bpt_ptr++)
		if (bpt_ptr->bpt_flag && bpt_ptr->bpt_pc == bpt_pc)
		 {
			erm_bpt_trace = 1;
			erm_trace = 1;
			erm_regsave [ERM_SR] |= ERM_TRACE_BIT;
			return;
		 }
tracing:
	erm_bpt_trace = 0;
	bpt_set ();
}
