
/* static char rcsid[] = "$Header: erm.h,v 1.1 85/04/30 17:04:34 ed Exp $" */

/************************************************************************
 *									*
 *				Copyright 1984				*
 *			VALID LOGIC SYSTEMS INCORPORATED		*
 *									*
 *	This listing contains confidential proprietary information	*
 *	which is not to be disclosed to unauthorized persons without	*
 *	written consent of an officer of Valid Logic Systems 		*
 *	Incoroporated.							*
 *									*
 *	The copyright notice appearing above is included to provide	*
 *	statutory protection in the event of unauthorized or 		*
 *	unintentional public disclosure.				*
 *									*
 ************************************************************************/

struct display
 {
	char	format;		/* always '%' */
	char	type;
	char	null;
	char	len;
 };

struct bpt
 {
	u_short	*bpt_pc;
	u_short	bpt_oldval;
	u_short bpt_count;
	u_short bpt_flag;
 };

#define ERM_MAXBPT	16
#define ERM_TRAP15	0x4E4F
#define ERM_TRACE_BIT	0x8000
#define ERM_BPT_PERM	1
#define ERM_BPT_GOTILL	2

#define ERM_TRACE_REG	1
#define ERM_TRACE_OVER	2
#define ERM_TRACE_TILL	4

#define ERM_D0		0
#define ERM_D1		1
#define ERM_D2		2
#define ERM_D3		3
#define ERM_D4		4
#define ERM_D5		5
#define ERM_D6		6
#define ERM_D7		7
#define ERM_A0		8
#define ERM_A1		9
#define ERM_A2		10
#define ERM_A3		11
#define ERM_A4		12
#define ERM_A5		13
#define ERM_A6		14
#define ERM_A7		15
#define ERM_SP		15
#define ERM_SR		16
#define ERM_PC		17

#define ECM_ADDR	1	/* An address may follow this command */

struct commtable {
	char comchar0, comchar1;
	int (*fun)();
	short flag;
	char *helpmsg;
};

#define ERM_CMDBUF_SIZE	80

struct funtable {
	int (*fun)();
};

#define NULL		'\0'		/* self defining */
#define TRUE		1
#define FALSE		0
#define CONTROLX	0x18		/* ASCII for ^X */
#define PERIOD		0x2E		/* ASCII for '.' */
#define ASC_X		0x58		/* ASCII for 'X' */
#define BELL		0x7		/* Bell */
#define DEL		0x7f		/* Delete key */
#define READ		1		/* IO device read */
#define	WRITE		0		/* IO device write */
#define BACKUP		1		/* disk backup */
#define RESTORE		0		/* disk restore */
#define alpha(c)	(c >= 0x41 && c <= 0x5A)
#define digit(c)	((c >= 0x30 && c <= 0x39) || (c >= 0x61 && c <= 0x66))



/*
 * Bytes / cyl = (bytes / sector) * (sectors / track) * (heads / cyl)
 */
struct srm_dkinfo {
	u_short	modelnum;	/* Model number */
	u_char	type;		/* Type of drive */
	u_char  numhead;	/* Number of heads */
	u_short	spt;		/* Sectors / track */
	u_short numcyl;		/* Number of cyls */
	u_short numalt;		/* Number of alternates */
	u_short	bps;		/* Bytes / sector */
	u_long bpc;		/* Bytes / cyl */
	u_short buff_numhead;	/* Number of heads in a buffer */
	u_short buff_numsector;	/* Number of sectors in a buffer */
	u_short buff_totcyl;	/* Total number of sectors in a buffer */
	u_short buff_tothead;	/* Total number of heads in a buffer */
	u_short buff_totsector;	/* Total number of sectors in a buffer */
	char	*name;		/* ASCII name */
};

struct dtxferinfo {
	u_long	startaddr;	/* Start bus addr */
	u_long	limitaddr;	/* Limit bus address */
	u_short	cyl;		/* Start cyl */
	u_char  head;		/* Start head */
	u_char  dum;		/* Dummy */
	u_short sector;		/* Start sector */
};

struct ttxferinfo {
	u_long  startaddr;	/* Start bus addr */
	u_long	limitaddr;	/* Limit bus address */
	u_long	nbytes;		/* Size of buffer */
};

/*
 * Limits on buffer used by bkup/rstr
 */
#define BKUPRSTR_START	0x30000
#define BKUPRSTR_SIZE	0xD0000		/* END - START */
#define BKUPRSTR_END	0x100000

struct bkuprstrinfo {
	u_short	startcyl;	/* Start cylinder */
	u_short endcyl;		/* End cylinder */
};

/*
 * Default tape buffer size (should be in rfreg.h)
 */
#define T_BUFFSIZE	0x4000
