/* static char rcsid[] = "$Header: cpu.h,v 1.1 85/04/30 17:04:17 ed Exp $" */

/************************************************************************
 *									*
 *				Copyright 1984				*
 *			VALID LOGIC SYSTEMS INCORPORATED		*
 *									*
 *	This listing contains confidential proprietary information	*
 *	which is not to be disclosed to unauthorized persons without	*
 *	written consent of an officer of Valid Logic Systems 		*
 *	Incoroporated.							*
 *									*
 *	The copyright notice appearing above is included to provide	*
 *	statutory protection in the event of unauthorized or 		*
 *	unintentional public disclosure.				*
 *									*
 ************************************************************************/


/*
 * Used by ERM
 */
#define V_HALFMAP	0x800000		/* Size of 1/2 map */
#define V_SCRATCHPAGE	0x3FF000		/* Scratch page used by ERM */
#define V_PGSHIFT	12			/* Shift for page number */
#define V_PGNUMMASK	0xFFF000		/* Mask for page number */
#define V_INITSTATUS	0x0			/* Initial status */
#define V_INITCTXT	0x0			/* Initial context */
#define V_CTXTLIM	0x10			/* Context limit */
#define V_MAXSEGNUM	0x100			/* Max segment number */
#define V_MAXPGNUM	0x1000			/* Max page number */
#define V_ACCESSMASK	0xF00			/* Mask for access seg map */
#define V_LCLRAM	0x18000			/* Start of local ram */
#define V_LCLRAMSIZ	0x800			/* End of local ram */

/* well known addresses */

#define	K_A		0x20000		/* kernel starting address */

#define	SSEG1_VA	0x8000		/* scratch segments, 0x2000 long */
#define	SSEG2_VA	0xA000
#define	MBMEM_VA	0xC000		/* multibus device memory space */
#define	MBIO_VA		0xD000		/* multibus device i/o space */
#define DUMMYU_PA	0xF000		/* u mapped here during startup */

#define PHYSMEMPAGES	0xD80		/* number of memory pages from 0x000 */


/* SEGSIZE is also defined in s32/param.h */
#ifndef SEGSIZE
#define SEGSIZE		65536	/* Size of a physical segment in bytes */
#define SEGSHIFT	16	/* log2(SEGSIZE) */
#endif SEGSIZE

#define STACKPROBE	0x4AAF		/* tstl @a7(x) */
#define STACKPROBE2	0x4A2F		/* tstb @a7(x) */

#define BUFFHIGH	0x100000	/* Buffers can't be allocated > this */

#define	V_PAGESIZE	0x1000			/* page size */
#define V_MAXVA		0x1000000 	/* 1 + biggest virtual addr, 24 bits */

#define	V_PAGEMAP	0x800000		/* address of page map */
#define V_SEGMAP	0x800000		/* address of segment map */

#define	V_CONTEXT	(*(unsigned char*) 0x1E001)	/* context register */
#define V_MAP_CONTROL	0xE0			/* map control bits */
#define	V_ACCPM		0x80			/* access page map */
#define V_ACCSM		0xA0			/* access segment map */
#define V_ACCLOW	0x40			/* access low half of map */
#define V_ACCHIGH	0x00			/* access high half of map */

#define V_SWITCHES	(*(char*) 0x1F801)	/* switch register */
#define V_MBOK		0x10			/* OK to access Multibus */
#define V_SWITCH_BIGMAP	0x08			/* switch set for big map */
#define V_TRYDIAG	0x04			/* try diagnostics */

#define	V_STATUS	(*(char*) 0x1F001)	/* status register */
#define V_REDLED	0x80			/* CPU red LED */
#define	V_GREENLED	0x40			/* CPU green LED */ 
#define	V_ENINT		0x10			/* enable interrupts */
#define V_NOTBOOT	0x08			/* not boot state bit */
#define V_ENBKDET	0x01			/* enable break detect */

#define	V_EREG		(*(char*) 0x1E801)	/* error register */
#define V_TIMEOUT	0x08			/* Location did not respond */
#define V_BOUNDS	0x04			/* address out of bounds */
#define V_SMERR		0x02			/* segment map error */
#define V_PMERR		0x01			/* page map error */

#define	V_PROM		0x10000			/* starting address of prom */

/* Bits in Valid Segment Map Entry */
#define V_SUSER		0x0800			/* seg map => user access */
#define V_SWRITE	0x0400			/* seg map => write access */
#define V_SREAD		0x0200			/* seg map => read access */
#define V_SEXEC		0x0100			/* seg map => execute access*/
#define V_SKERNEL	(V_SEXEC|V_SWRITE|V_SREAD)/* kernel mode access */
#define V_SEG_INVALID	0x0000			/* no access at all */

/* Bits in Valid Page Table Entry					*/
#define V_USED		0x8000			/* Page has been accessed*/
#define V_DIRTY		0x4000			/* Page has been written*/
#define V_MISSING	0x2000			/* Page not present	*/
#define V_PAGE_INVALID	0x3000			/* Page map => invalid */
#define V_MBIO		0x1000			/* Page maps to Multibus i/o*/
#define	V_MBMEM		0x0			/* Page maps to Multibus mem*/
#define V_PAGEMASK	0x0FFF			/* Physical page number */

/* Given a Valid virtual page number, use these masks to extract: */
#define V_VSEGNO	0x0FF0			/* the segment number */
#define V_VPAGENO	0x000F			/* the page number */
