/* rcsid[]="$Header: vpb.h,v 820.1 86/12/04 19:57:10 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
 *									*
 *				Copyright 1984				*
 *			VALID LOGIC SYSTEMS INCORPORATED		*
 *									*
 *	This listing contains confidential proprietary information	*
 *	which is not to be disclosed to unauthorized persons without	*
 *	written consent of an officer of Valid Logic Systems 		*
 *	Incoroporated.							*
 *									*
 *	The copyright notice appearing above is included to provide	*
 *	statutory protection in the event of unauthorized or 		*
 *	unintentional public disclosure.				*
 *									*
 ************************************************************************/

/*
 * vpb.h by Carol Farlow and Straff Wentworth.
 * Modified from versions 4.1(10/26/82) and 6.1(9/29/83) for 4.1cBSD
 * ioctls, new field in rscs structure.
 * Steven Sargent 2-3-84
 */
/* VPB type definitions */
typedef bit32 devmask;          /* This is the source of the limit
                                 * on minor dvc #<32                    */
/* VPB equates */
#define DISCRIM0 0X4019		/* On-board location ...		*/
#define DBIT0	0X08		/* Tells VGB/PIB from others		*/
#define DISCRIM1 0X4019
#define DBIT1   0X10		/* Tells VGB from PIB			*/
#define JMPL8086 0XEA		/* Opcode of 8086 intersegment jmp (IPL)*/
#define IPLV8086 0XFFF0		/* On reset, 8086 goes here             */
#define LOOP8086 0XFEEB		/* 8086 JMP * swabbed                   */
#define VGB     0X56474200	/* "VGB" for dump literal               */
#define PIB     0X50494200	/* "PIB"                                */
#define TEST    0X54535400	/* "TST"				*/
#define MAXSEGRG 2		/* Highest segment register, any vpb    */

/* VPB common error codes */
/* These are currently returned in u.u_error, a truly brain-damaged
 * practice which must stop!
 */
#define E_OK 0
#define E_DIAGMD -1
#define E_NOHALT -2
#define E_NORUN -3
#define E_ZERPRV -4
#define E_BADCOM -5
#define E_NOBUF  -6
#define E_BADIAG -7
#define E_BADARG -8
#define E_BADSTA 0XFE00		/* Ored with sumstat for status errors	*/

/* Flag definitions: bdt.flag                                           */
#define SEGALIGN 0X8000		/*Mbpgs on segment bound		*/
#define BDDIAG 0X4000		/* Board-dependent diags. exist		*/
#define DSPMGROK 0X2000		/*This type board can talk to displaymgr*/

/* Flag definitions: bdt.b[n].flag                                      */
#define LOADDIAG 1		/* Load/diag device open		*/
#define RUNNING 2		/* Loaded.				*/
#define ACTIVE  4		/* At least one device open		*/
#define BAD     8		/* Disabled due to prior error		*/
/*              Above bits must be contiguous                           */
#define RELEBITS LOADDIAG+RUNNING+ACTIVE+BAD	/*Participate in sumstat*/
#define WATCHOUT 16		/* Watchdog timer outstanding		*/
#define FAKESBFL RUNNING	/* If no shared code, fake it ok	*/

/* Opcode bits/definitions						*/
#define OPEN 0
#define CLOSE 1
#define IO 2
#define VPBCONTROL 3
#define OPMASK 3		/* These bits are the basic opcd	*/
#define LDIAGOP 4
#define SHAREDCD 8 
#define MXREALOP 3		/* Maximum opcode, real minor devices	*/

/* rw definitions							*/
#define VPBWRITE 1
#define VPBREAD 2

/* Ioctl commands							*/
/* Note:
 *  a) The structure pdevtbl (pib.c) is used to check the validity of the 
 *     ioctl command for each minor device. The table expects the ioctl 
 *     command values to be sequental.
 *
 *  b) The resulting value passed the pib/8086 is a calculated value
 *          pib ioctl = (orig value) - RSCS + 2;
 *
 *     E.g.
 *          7 = VRSBLOCKPLOT - RSCS + 2;
 *
 *  c) The structure "arglen" (vpb.c) is used to hold the maximum allowed 
 *     length of data assocated with a command. The SAD part is that these are
 *     sequental, i.e., ioctls cannot overlap. In conclusion the "pdevtbl"
 *     plus the "arglen" structure are incompatible. The former requires
 *     minor device ioctl values are sequential and the latter requires the
 *     ioctl commands to be non-overlapping. Since the "pib" driver is handling
 *     both ioctl values they must be distinct. This means that the "pdevtbl"
 *     structure has a large range of allowable ioctl values, many of which
 *     are undefined.
 *
 *     Redesign is in order.
 */

#ifndef	_IOCTL_
#ifdef KERNEL
#include "../h/ioctl.h"
#else
#include <sys/ioctl.h>
# endif
#endif	_IOCTL_
/* SETBDT, SETINTR, and GETBDT are no longer supported!
 */
#define START	_IO(_IO_VPB,0)      /* During load, set initial JMP address */
#define SETADDR _IO(_IO_VPB,1)      /* During load, set address to put code */
#define SETBDT	_IO(_IO_VPB,2)      /* Use this alternate bdt		*/
#define SETINTR _IO(_IO_VPB,3)      /* Deliver signal here on interrupts*/
#define GETBDT	_IO(_IO_VPB,4)      /* Give caller bdt address		*/
#define RSCS	_IOWR(_IO_VPB,5,RSCSparms) /* Perform an RSCS exchange	*/
#define	VRSFMFD	_IO(_IO_VPB,6)      /* Form feed to Versatec		*/
#define VRSPLOT _IO(_IO_VPB,7)      /* Set plot mode on Versatec	*/
#define VRSPRNT _IO(_IO_VPB,8)      /* Set print mode on Versatec	*/
#define VRSLTER _IO(_IO_VPB,9)      /* Premature end of line on Versatec*/
#define VRSBLOCKPLOT _IO(_IO_VPB,10) /* Premature end of line on Versatec*/
#define VRSFLUSH _IO(_IO_VPB,11)     /* Premature end of line on Versatec*/

#define BYSYNCSETN _IO(_IO_VPB,12)   /* Set speed of RSCS/bysync line	*/

/* Maximum ioctl value as seen by the pib */
#define MAXIOCTL 12

/* PIB command codes							*/
#define CMDXFER 0
#define CMDOPEN 1
#define CMDCLOSE 2

typedef struct {
	byte	*outbuf;
	int	outlen;
	byte	*inpbuf;
	int	inplen;
	int	inptime;
	int	rstatus;		/* sbs */
} RSCSparms;

/* RSCS error codes (returned in RSCSparms.rstatus).
 */
#define RSCS_ERRBASE	0x80000000
#define INPTMO	(RSCS_ERRBASE|1)
#define OUTTMO  (RSCS_ERRBASE|2)
#define OUTWLN	(RSCS_ERRBASE|3)
#define INPWLN  (RSCS_ERRBASE|4)
/* sbs
#define INPTMO	0X80000001
#define OUTTMO  0X80000002
#define OUTWLN	0X80000003
#define INPWLN  0X80000004
*/

/* Board definition table: provide one per board type.			*/
struct bdt {
        bit32 type;		/*Dump literal                          */
	struct bdt *altbdt;	/*Hook for testing new driver version.  */
        int owner;      /*??How we ensure test version used by owner.   */
	devmask mdlegal;	/*Bitmask showing legal minor dvcs	*/
        byte *dvcflag;		/*Array of device flags                 */
        short	intpri,   /*Interrupt priority                          */
                Mbpgs,    /*Total space per group or board              */
		sharebits,	/*Next bits form group			*/
		sharemask,	/*(1<<sharebits)-1			*/
                minorbits,      /*Low order bits forming minor dvc #    */
                minormask,      /*(1<<minorbits)-1, also= load dvc #    */
                maxboards,      /*Dimension of bdt.b array (max allowed)*/
                totboards;      /*Number of bdt.b used. Filled by memini*/
        bit16   flag;   /* See definitions above.                       */
	bit16	reserved;	/*Compiler error if we don't align	*/
	/* Call devsw for lower half code.  (fncp)0 means there is no
	 * function to call.
	 */
        fncp    doio[MXREALOP+1],/*Real device handling (board specific */
                intrpt,         /*Interrupt handler                     */
                watch;          /*Watchdog timer routine                */
        bit32	onbdend,		/*End of on board memory	*/
		offbdbase,	/*Start of off board private		*/
		segregad[MAXSEGRG];	/*Where are seg regs?		*/
	/* regmuck parameters
	 */
        struct regdef {
		int	op;
		bit32	value,
			address;
        } run,          /* ...start board execution                     */
          halt,         /* ...halt board execution                      */
	  redled,	/* ...turn on red led				*/
	  greenled,     /* ...turn on green led				*/
          ring;         /* ...ring board's doorbell                     */
	/* Per board data: one apiece + 1 each/shared code
	 */
	struct bdata {
		byte *privMba, /* Private area Multibus address         */
                *boardMba,      /* Where the board lives on Multibus    */
		*curaddr,	/* During load, current address		*/
		start[4];	/* IPLOW, IPHIGH, CSLOW, CSHIGH IPL jmp */
		fncp diagsig;	/* User asks signal on interrupt        */
		devmask mdopen;	/* Summary of open devices		*/
		bit16 flag;	/* Board status (bits defined above)    */
		bit16 reserved;	/* Prevent compiler alignment error	*/
        } b[NBD];
}; /*vgbdt, pibdt, testbdt defined in vgb.c, pib.c, testdvc.c           */

#define ISSHRBSLOT(bdtp,bnum) ((bnum)&~((bdtp)->sharemask))
