/* rcsid[]="$Header: skyreg.h,v 820.1 86/12/04 19:56:29 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
 *									*
 *				Copyright 1984				*
 *			VALID LOGIC SYSTEMS INCORPORATED		*
 *									*
 *	This listing contains confidential proprietary information	*
 *	which is not to be disclosed to unauthorized persons without	*
 *	written consent of an officer of Valid Logic Systems 		*
 *	Incoroporated.							*
 *									*
 *	The copyright notice appearing above is included to provide	*
 *	statutory protection in the event of unauthorized or 		*
 *	unintentional public disclosure.				*
 *									*
 ************************************************************************/

/*
 * Base virtual address of SKY registers (once they are mapped in
 * by mmopen/mmioctl).
 */
#define SKYVIRTADDR	0xFFD280

#ifndef LOCORE

/*
 * SKY FFP Registers
 */
#ifdef KERNEL
struct skyffp {
	short sky_comreg;		/* Command Register */
	short sky_stcreg;		/* Status and Control Register */
	union {
		unsigned short dt1reg,dt2reg;
		unsigned long dtreg;
	} sky_data;			/* Data Registers 1 and 2 */
#define sky_dt1reg sky_data.dt1reg
#define sky_dt2reg sky_data.dt2reg
#define sky_dtreg sky_data.dtreg
	union {
		unsigned short mc1reg,mc2reg;
		unsigned long mcreg;
	} sky_micr;			/* Microcode Registers 1 and 2 */
#define sky_mc1reg sky_micr.mc1reg
#define sky_mc2reg sky_micr.mc2reg
#define sky_mcreg sky_micr.mcreg
};
#else KERNEL
struct skyffp {
	u_short	sky_comreg;
	u_short	sky_stcreg;
	u_short sky_dt1reg;
	u_short sky_dt2reg;
	u_short sky_mc1reg;
	u_short sky_mc2reg;
};
#endif KERNEL

/*
 * Status Register Bits
 */
#define SKYIORDY	0x8000	/* I/O Ready 0==>busy, 1==>ready */
#define SKYIDLE		0x4000	/* 0==>busy, 1==>idling */
#define SKYIODIR	0x2000	/* I/O Direction 0==>host read,1==>host write */
#define SKYRESET  	0x80	/* Software reset */
#define SKYMODE   	0x60	/* Mode bits as follows: */
#define 	SKYIHALT  0x00		/* Halt (restart at new location) */
#define 	SKYPAUSE  0x20		/* Halt (resume at current location) */
#define 	SKYRUNENB 0x40		/* Run (normal mode) */
#define 	SKYSNGRUN 0x60		/* Run (single step mode) */
#define SKYIENB   	0x10	/* Interrupt enable */
#define SKYISTAT  0x03		/* Interrupt status as follows: */
#define 	SKYILLI   0x02		/* Illegal transfer */
#define 	SKYPGMI   0x01		/* Programmed interrupt */

/*
 * FFP Operation Codes
 */
#define SKYSTART0 	0x1000	/* Initialization */
#define SKYSTART1 	0x1001
#define SKYSAVE		0x1040	/* Save context routine */
#define SKYLOGBASE_E	0x102D	/* SKY log base e operation */
#define SKYRESTOR 	0x1041	/* Restore context routine */
#define SKYNOP		0x1063	/* No-op routine */

#ifdef KERNEL
extern u_long skysvs;
#endif KERNEL
#endif LOCORE
