/* rcsid[] = "$Header: exdef.h,v 820.1 86/12/04 19:55:26 root Exp $" */
/* sccsid[] = "%W% %Q% %Y% %G%" */

/****************************************************************
 * struct ex_softc - per controller data structure		*
 *								*
 *	Each network interface is referenced by a network	*
 *	interface structure that the routing code uses to	*
 *	locate the interface.  This structure (ex_softc)	*
 *	contains the information maintained by the driver about	*
 *	the controller.						*
 *								*
 ****************************************************************/

#define	NH2X 8			/* Number of host to EXOS request buffers */
#define	NX2H 8			/* Number of EXOS to host reply buffers */

#if (NEX==1)
#define EXINFO(n) exinfo
#define EX_SOFTC(n) ex_softc
#else (NEX==1)
#define EXINFO(n) exinfo[n]
#define EX_SOFTC(n) ex_softc[n]
#endif (NEX==1)

struct ex_softc
    {
    struct arpcom	ac;		/* Ethernet common part */
    int			flags;		/* Private flags */
    int			EXOSmode;	/* Mode of EXOS controller */
    struct exMessage *	h2xnext;	/* Host pointer to request queue */
    struct exMessage * 	x2hnext;	/* Host pointer to reply queue */

    u_char *		virtBaseAddr;	/* Virtual base address of comm area */
    u_long		physBaseSeg;	/* Physical base segmnt of comm area */
    u_long		physBaseOffset;	/* Physical base offset of comm area */

    u_short		h2xhdr;		/* EXOS's request queue header */
    u_short		x2hhdr;		/* EXOS's reply queue header */
    union exEXOSmessage	h2xmsg[NH2X];	/* Request msg buffers */
    union exEXOSmessage	x2hmsg[NX2H];	/* Reply msg buffers */

    struct confmsg	cm;		/* Configuration message */
    struct stat_array	xsa;		/* EXOS writes stats here */
#ifdef VALIDnet
	struct ifnet	if_bulk;	/* VALID BULK interface */
	struct ifnet	if_conn;	/* VALID CONN interface */
	struct ifnet	if_rpc;		/* VALID RPC interface */
#endif VALIDnet
   struct ifqueue	output;		/* Output queue */

    char		rbuf[ETHERMTU+50];
    char		tbuf[ETHERMTU+50];
    };


/* ex_softc element aliases */

#define	xs_if		ac.ac_if	/* network-visible interface */
#define	xs_addr		ac.ac_enaddr	/* hardware Ethernet address */


/* ex_softc.flags definitions */

#define	EX_XPENDING	1		/* xmit rqst pending on EXOS */
#define	EX_STATPENDING	2		/* stats rqst pending on EXOS */
#define EX_WAITING	4		/* User process is waiting (sleep) */
#define EX_TCInet	8		/* TCI DECnet FEP mode enabled */
