/* rcsid[]="$Header: scCpu.h,v 820.1 86/12/04 19:53:58 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
 *									*
 *				Copyright 1984				*
 *			VALID LOGIC SYSTEMS INCORPORATED		*
 *									*
 *	This listing contains confidential proprietary information	*
 *	which is not to be disclosed to unauthorized persons without	*
 *	written consent of an officer of Valid Logic Systems 		*
 *	Incoroporated.							*
 *									*
 *	The copyright notice appearing above is included to provide	*
 *	statutory protection in the event of unauthorized or 		*
 *	unintentional public disclosure.				*
 *									*
 ************************************************************************/

/* sun version -- NEC uart */

#define	NUaddr			0x600000

#define	NUdata(line)		*((char*) NUaddr + 0 + line*4)
#define	NUcontrol(line)		*((char*) NUaddr + 2 + line*4)

#define RR0			0	/* read register 0 */
#define	NUrxrdy			0x01	/* rx ready */
#define	NUtxrdy			0x04	/* tx ready */

#define	RR2			2	/* read register 2 */

#define	WR0			0	/* write register 0 */
#define	NUchres			0x18	/* channel reset */
#define	NUtxres			0x28	/* tx interrupt reset */

#define	WR1			1	/* write register 1 */
#define	NUtxint			0x02	/* interrupt on tx buffer empty */
#define	NUsav			0x04	/* status-affects-vector */
#define	NUrxint			0x18	/* interrupt on all rx characters */

#define	WR2			2	/* write register 2 */
#define	NUprio			0x04	/* rx > tx priority */
#define	NU8086			0x10	/* 8086 interrupt mode */

#define	WR3			3	/* write register 3 */
#define	NUrxena			0x01	/* rx enable */
#define	NUautoen		0x20	/* auto enable */
#define	NUrx8bit		0xC0	/* rx 8-bit characters */

#define	WR4			4	/* write register 4 */
#define	NUrx1sb			0x04	/* rx 1 stop bit */
#define	NU16xclk		0x40	/* 16x clock mode */

#define	WR5			5	/* write register 5 */
#define	NUtxrts			0x02	/* tx request-to-send */
#define	NUtxena			0x08	/* tx enable */
#define	NUtx8bit		0x60	/* tx 8-bit characters */
#define	NUdtr			0x80	/* data-terminal-ready */

/*
 * Header for Signetics 2661 UART
 *
 * Richard Kiessig 
 * Intelligent Decisons, Inc.
 * 10-10-81
 */

struct uart {
	char	udum1;
	char	udata;
	char	udum2;
	char	ustatus;
	char	udum3;
	char	umode;
	char	udum4;
	char	ucmd;
};

#define	CUART	((struct uart *)0x01c800)	/* console UART */
/* console is port 0. */
#define CONSOLE 0
#define CLINE	0
#define	HUART	((struct uart *)0x01c000)	/* host UART */
#define HLINE	1

#define SUcontrol(line) ((line==0?CUART:HUART)->umode) /* mode register */
#define SUdata(line) ((line==0?CUART:HUART)->udata) /* data register */
#define SUstatus(line) ((line==0?CUART:HUART)->ustatus) /* status register */
#define SUcommand(line) ((line==0?CUART:HUART)->ucmd) /* cmd register */

#define UM1INIT	0x6d			/* initial value for UART mode1 */

#ifdef UART26612
#define UM2INIT	0xbd			/* initial value for UART mode2 */
#else
#define UM2INIT	0xbe			/* initial value for UART mode2 */
#endif

#define UCMDCLR	0x10			/* clear value for UART command */
#define UCMDINI	0x27			/* init value for UART command */
#define UTRADIS	0x26			/* transmitter disable, else intact */
#define UENABLE	0x27			/* transmitter enable */
#define UINTDIS	0x22			/* disable rcv and xmt interrupts */

#define UDCDBIT	(1<<6)			/* data-carrier-detect */
#define SUrxrdy (1<<1)			/* receive-data-ready */
#define SUtxrdy (1<<0)			/* transmit-data-ready */
#define SUbkdet (1<<5)			/* FE/SYN (break) detect */
extern short scdb[], scbaud[];
