/* rcsid[]="$Header: reg.h,v 820.1 86/12/04 19:53:55 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	reg.h	4.3	82/10/08	*/
/*
 * Location of the users' stored
 * registers relative to R0.
 * Usage is u.u_ar0[XX].
 *
 */
#define	R0	(0)
#define	R1	(1)
#define	R2	(2)
#define	R3	(3)
#define	R4	(4)
#define	R5	(5)
#define	R6	(6)
#define	R7	(7)
#define	AR0	(8)
#define	AR1	(9)
#define	AR2	(10)
#define	AR3	(11)
#define	AR4	(12)
#define	AR5	(13)
#define	AR6	(14)
#define	AR7	(15)
#define	SP	(15)
#define J1	(16)	/*  Junk 1 -- Doug Tygar  */
#define PS	(17)
#define	PC	(18)

#ifdef	M68010
/*
 * The following are used
 * for bus and address errors only
 */
#define SSW_68010	(19)	/* Special status word (low) and vector (high)*/
#define FADDR_68010	(20)	/* Fault address */
#define DOUT_68010	(21)	/* Data output buffer (low) */
#define DIN_68010	(22)	/* Data input buffer (low) */
#define IIN_68010	(23)	/* Instruction input buffer (low) */

#define NIPCREG 19		/* number of regs r/w by ptrace */
#endif	M68010

#ifdef	M68020
/*
 * The following are used
 * for bus and address errors only
 */
#define UNDEF_REG	(19)	/* Vector (high) and Internal register (low) */
#define SSW_68020	(20)	/* Special Status Word (high) and iRegC (low) */

#define NIPCREG 19		/* number of regs r/w by ptrace */
#endif	M68020


#if	defined(M68000) || defined(M68010) || defined(M68020)

/*
 * Bits in the status register SR (ps)
 */
#define	SR_SYSTEM_BYTE	0xFF00	/* System-portion of Status Reg	*/
#define SR_TRACE	0x8000	/* T1 Trace mode		*/
#define SR_TRACE0	0x4000	/* T0 Trace mode		*/
#define SR_SUPER	0x2000	/* Supervisor mode		*/
#define SR_MASTER	0x1000	/* Master/Interrupt State	*/

#define SR_INTMASK	0x0700		/* Interrupt mask	*/
#define	SR_RUPT_NOTHING		0x0700	/* All devices DISabled	*/
#define	SR_RUPT_HARDCLOCK	0x0600	/* Hardclock		*/
#define	SR_RUPT_DISK		0x0500	/* Disks		*/
#define	SR_RUPT_FOUR		0x0400	/* ???			*/
#define	SR_RUPT_THREE		0x0300	/* ???			*/
#define	SR_RUPT_TWO		0x0200	/* ???			*/
#define	SR_RUPT_SOFTCLOCK	0x0100	/* Softclock		*/
#define	SR_RUPT_EVERYTHING	0x0000	/* All devices ENabled	*/


#define	SR_USER_BYTE	0x00FF	/* User-portion of status reg	*/
#define SR_CCR		0x001F	/* Condition Code:  bits user can manipulate */
#define SR_EXTEND	0x0010	/* Extended carry:	(X)	*/
#define SR_NEGATIVE	0x0008	/* Negative result:	(N)	*/
#define SR_ZERO		0x0004	/* Zero result:		(Z)	*/
#define SR_OVERFLOW	0x0002	/* Overflow:		(V)	*/
#define SR_CARRY	0x0001	/* Carry:		(C)	*/
#endif	defined(M68000) || defined(M68010) || defined(M68020)


#ifdef	M68010
/*
 * Bits in the 68010's special status word (ssw)
 */
#define	SSW_SOFTRERUN_68010	0x8000	/* Software re-run */
#define SSW_INST_68010		0x2000	/* Instruction fetch */
#define SSW_DATA_68010		0x1000	/* Data fetch */
#define SSW_RMW_68010		0x0800	/* Read-modify-write */
#define SSW_HIGHBYTE_68010	0x0400	/* High byte transfer */
#define SSW_BYTE_68010		0x0200	/* Byte transfer */
#define SSW_READ_68010		0x0100	/* Read transfer */
#define SSW_FCODE_68010		0x0007	/* Function code (address space) */
#endif	M68010


#ifdef	M68020
/*
 * Bits in the Special Status Word (SSW)
 */
#define	SSW_FC_68020	0x8000	/* Fault on Stage C of the Instruction pipe   */
#define	SSW_FB_68020	0x4000	/* Fault on Stage B of the Instruction pipe   */
#define SSW_RC_68020	0x2000	/* 1==> h/w rerun of stage C of instruct pipe */
#define SSW_RB_68020	0x1000	/* 1==> h/w rerun of stage B of instruct pipe */

#define SSW_DF_68020	0x0100	/* Fault/Rerun Flag for Data cycle	      */

#define SSW_RM_68020	0x0080	/* 1==> Read-Modify-write		      */
#define SSW_RW_68020	0x0040	/* 1==>Read; 0==>Write transfer		      */
#define SSW_SIZ_68020	0x0030	/* (Mask for) Size Code for Data Cycle	      */

#define SSW_FCODE_68020	0x0007	/* (Mask for) Function Code: Address space    */
#endif	M68020


#if	defined(M68000) || defined(M68010) || defined(M68020)
#define SSW_FCODE		0x0007	/* Function code (address space) */

/*
 * Function codes: FC0-FC2: (address space numbers)
 */
#define SSW_FCODE_USERDATA	1	/* User data */
#define SSW_FCODE_USERPROG	2	/* User program */
#define SSW_FCODE_SUPERDATA	5	/* Supervisor data */
#define SSW_FCODE_SUPERPROG	6	/* Supervisor program */
#define SSW_FCODE_CPU		7	/* Special CPU access */
#endif	defined(M68000) || defined(M68010) || defined(M68020)

