#include <stdio.h>
#include <a.out.h>

int nldebug;

#define SYM_PA		0x5000		/* Address of symbol table */
#define MAXSSIZE	0x7000		/* Maximum symbol table size (bytes) */

vmnlist(corefile, list)
   char *corefile;
   struct nlist *list;
{
	FILE *f;
	register struct nlist *p;
	register char *cp;
	int i, c;
	long pos;
	char symbuf[SYMLENGTH];
	struct sym sym;
	int nleft = 0;
	long symbytes;

	for(p = list; p->n_name[0]; p++) {
		p->n_type = 0;
		p->n_value = 0;
		++nleft;

	}
	if ((f = fopen(corefile, "r")) == NULL)
		return(-1);
	symbytes = MAXSSIZE;
	fseek(f, (long)SYM_PA, 0);
	for (pos = 0; pos < symbytes; pos += sizeof(sym)+strlen(symbuf)+1)
	{
		fread(&sym, sizeof sym, 1, f);
		if (feof(f))
			goto bad;
		for (cp = symbuf; cp < &symbuf[SYMLENGTH - 1]; cp++)
		{
			if ((c = getc(f)) == EOF) goto bad;
			if (c == 0) break;
			*cp = c;
		}
		*cp = 0;

		if (symbytes == MAXSSIZE && !strncmp(symbuf, "symbytes", 8))
		{
			long addr = ftell(f);
			long xx;

if (nldebug)
printf("symbytes is at 0x%x\n", sym.svalue);
			fseek(f, (long)sym.svalue, 0);
			if (fread(&xx, sizeof(xx), 1, f) == 1)
				symbytes = xx;
if (nldebug)
printf("symbytes = %d\n", symbytes);
			fseek(f, addr, 0);
		}

if (nldebug)
printf("Try %s, type %d, value 0x%x ...", symbuf, sym.stype, sym.svalue);
		for(p = list; p->n_name[0]; p++)
		{
			for(i=0;i<8;i++)
			{
				if (p->n_name[i] != symbuf[i])
					goto cont;
				if (p->n_name[i] == 0) break;
			}
if (nldebug)
printf("found %d", p - list);
			p->n_value = sym.svalue;
			p->n_type = sym.stype;

			/*
			 * Only search until all symbols have been
			 * found.
			 */
			if (--nleft <= 0)
				goto done;
			break;
		cont:		;
		}
if (nldebug)
printf("\n");
	}
done:
	fclose(f);
	return(0);

bad:	fclose(f);
	return(-1);
}
