static char rcsid[] = "$Header: sym.c,v 800.0 85/07/30 13:57:24 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

#
/****************************************************************************

	DEBUGGER - symbol table management

****************************************************************************/
#include "defs.h"

#ifdef s32
#define NSYMS	2400		/* symbol table size enlarged 5/16/1985 (bog) */
#else s32
#define NSYMS	1200		/* symbol table size */
#endif s32

MSG		BADFIL;
L_INT		mainsval;
L_INT		symnum;
INT		hexf;
INT		pid;
struct symb	symtab[NSYMS];
SYMPTR		symbol;
SYMPTR		symtabb;
SYMPTR		symnxt;
SYMPTR		symend;
STRING		symnamb;

STRING		symfil;
STRING		errflg;
POS		findsym();

setupsym(ssize)
long	ssize;
{
	int 	j;
	long	symval;
	SYMPTR	symptr;
	char	*nameptr;
	extern	char	*malloc();
	FILE	*bout;
	struct sym ofsym;	/* format of symbol data in objfil */
				/* defined in a.out.h */

	symtabb = symtab;			/* space for symbol table */
	symnamb = malloc(ssize);		/* space for symbol names */

	if ((bout = fopen(symfil,"r")) == NULL)
		 printf("\n\tcannot fopen %s", symfil);
	fseek(bout, symbas, 0);			/* seek start of symbols  */
	symnum = 0;
	symptr = symtabb;
	nameptr = symnamb;
						/* build symbol table	  */
	while ((ssize > 0) && (symptr < &symtab[NSYMS]))
	{
		if (fread(&ofsym, sizeof( struct sym ), 1, bout ) != 1 )
			break;
		symptr->symf = ofsym.stype;
		symptr->vals = ofsym.svalue;
		symptr->smtp = SYMTYPE(symptr->symf);
		if ((ssize -= sizeof( struct sym ) ) == 0)
			break;
		symptr->symc = nameptr;
		do
		{
			if (fread(nameptr, 1, 1, bout) != 1)
				break;
			ssize--;
		}
		while (*nameptr++ != NULL);
		symnum++; symptr++;
	}
	symend = symptr;			/* end of symbols */
	symend->smtp = ESYM;
	if (ssize != 0) printf("\n\tsymbol table problem - proceeding anyway");
	if (symptr >= &symtab[NSYMS])
		printf("\n\tbeware: symbol table overflow");
	fclose(bout);
	if (symptr = lookupsym("main")) mainsval = symptr->vals;
}

longseek(f, adr)
FILE	*f;
long	adr;
{
	return(lseek(f, adr, 0) != -1);
}

valpr(v, idsp)
long	v;
int	idsp;
{
	unsigned w = findsym(v, idsp);
	if (w < maxoff)
	{
		printf("%s", symbol->symc);
		if (w && hexf) printf("+%x", w);
		else if (w) printf("+%d", w); 
	}
}

psymoff(v, type, s)
long	v;
int	type;
char	*s;
{
	unsigned w = findsym(v, type);
	if (w >= maxoff) printf("%X", v);
	else
	{
		printf("%s", symbol->symc);
		if (w && hexf) printf("+%x", w);
		else if (w) printf("+%d", w);
	}
	printf(s);
}

unsigned
findsym(svalue, type)
long	svalue;
int	type;
{
	long	diff = 0377777L, symval;
	SYMPTR	symptr;
	SYMPTR	symsav = NULL;

	if ((type != NSYM) && (symptr = symtabb))
	{
		while (diff && (symptr->smtp != ESYM))
		{
			symval = symptr->vals;
			if (((svalue - symval) < diff)
				&& (svalue >= symval))
			{
				diff = svalue - symval;
				symsav = symptr;
			}
			symptr++;
		}
		if (symsav) symbol = symsav;
	}
	return(shorten(diff));
}

nextsym()
{
	if (++symbol == symend)
	{
		symbol--;
		return(FALSE);
	}
	else return(TRUE);
}

symset()
{
	symnxt = symtabb;
}

SYMPTR
symget()
{
	SYMPTR	ptr;

	if (symnxt >= symend) return(NULL);
	ptr = symnxt; symnxt++;
	return(ptr);
}

