/* rcsid[]="$Header: busanal.h,v 820.1 86/12/04 19:52:46 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/* Valid Logic Systems bus-analyzer board */
struct bab {
	long lines[8192];  /* just for now, 8k by 4 */
	long babptr;
	long fill1[2047];
	char fill2;
	char babwreg;
	long fill3[2047];
	char babstatus;		/* this structure not yet tested */
}; 
#define	BABORG ((struct bab *)0x3e0000)	/*bab origin (switch selectable) */
#define BABaddr	(long)BABORG
#define	BABram 0		/*bab ram relative adr */
#define	BABptr *((long *) BABaddr + 0x8000) /*bab buffer pointer adr */
#define	BABwreg *((char *) BABaddr + 0xa001) /*bab window register  adr */
#define	BABstatus *((char *) BABaddr + 0xc001) /*bab status register  adr */
/* bits in status register: */
#define	BABREDLED	1<<7		/*red led */
#define	BABGREENLED	1<<6		/*green led */
#define	BABENINT 	1<<5		/*enable interrupts */
#define	BABUSEWINDOW	1<<4		/*use window */
#define	BABENMRDC	1<<3		/*enable mrdc recording */
#define	BABENMWTC	1<<2		/*enable mwtc recording */
#define	BABENIORC	1<<1		/*enable iorc recording */
#define	BABENIOWC	1<<0		/*enable iowc recording */

#define	BABSTOPMSK 0xf0		/*mask to stop recording	 */
#define	BABGOMSK 0xf		/*mask to start all recording */

/* bits in trace information in buffer: */
#define	BABMRDCBIT 1<<3		/*mrdc bit in byte 7 of buffer */
#define	BABMWTCBIT 1<<2		/*mwtc bit in byte 7 of buffer */
#define	BABIORCBIT 1<<1		/*iorc bit in byte 7 of buffer */
#define	BABIOWCBIT 1<<0		/*iowc bit in byte 7 of buffer */
	
