/* rcsid[]="$Header: ioctl.h,v 820.1 86/12/04 19:48:54 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	ioctl.h	6.1	83/07/29	*/
/*
 * Ioctl definitions
 */
#ifndef	_IOCTL_
#define	_IOCTL_

#ifdef KERNEL
#include "../h/tty.h"		/* jht -- fixes user.h order dependency */
#ifdef WHITE
#include "../white/mouse.h"
#endif WHITE

#else	KERNEL
#include <sys/tty.h>		/* jht -- fixes user.h order dependency */
#ifdef WHITE
#include <white/mouse.h>
#endif WHITE
#endif	KERNEL

#ifdef s32
/*
 * Structure for stty and gtty system calls.
 */

struct sgttyb {
	char	sg_ispeed;		/* input speed */
	char	sg_ospeed;		/* output speed */
	char	sg_erase;		/* erase character */
	char	sg_kill;		/* kill character */
	int	sg_flags;		/* mode flags */
};
#else s32
#include <sgtty.h>
#endif s32

#ifndef _IO
/*
 * Ioctl's have the command encoded in the lower word,
 * and the size of any in or out parameters in the upper
 * word.  The high 2 bits of the upper word are used
 * to encode the in/out status of the parameter; for now
#ifdef s32
 * we restrict parameters to at most 256 bytes.
#else s32
 * we restrict parameters to at most 128 bytes.
#endif s32
 */
#ifdef s32
#define	IOCPARM_MASK	0xff		/* parameters must be < 256 bytes */
#else s32
#define	IOCPARM_MASK	0x7f		/* parameters must be < 128 bytes */
#endif s32
#define	IOC_VOID	0x20000000	/* no parameters */
#define	IOC_OUT		0x40000000	/* copy out parameters */
#define	IOC_IN		0x80000000	/* copy in parameters */
#define	IOC_INOUT	(IOC_IN|IOC_OUT)
/* the 0x20000000 is so we can distinguish new ioctl's from old */
#define	_IO(x,y)	(IOC_VOID|(x<<8)|y)
#define	_IOR(x,y,t)	(IOC_OUT|((sizeof(t)&IOCPARM_MASK)<<16)|(x<<8)|y)
#define	_IOW(x,y,t)	(IOC_IN|((sizeof(t)&IOCPARM_MASK)<<16)|(x<<8)|y)
/* this should be _IORW, but stdio got there first */
#define	_IOWR(x,y,t)	(IOC_INOUT|((sizeof(t)&IOCPARM_MASK)<<16)|(x<<8)|y)
#endif	_IO

		/************************************************
		 *       Centralize which ioctl service		*
		 *   is assigned to which 'letter'/designator	*
		 ************************************************/
/*
 * Historical/generic IOCTL's
 */
#define	_IO_TTY		't'	/* Nominal tty ioctl-s			*/
#define	_IO_FIO		'f'	/* File i/o				*/
#define	_IO_SOC		's'	/* Socket control			*/
#define	_IO_ROUTE	'r'	/* Routing for sockets			*/

/*
 * Generic disk and magtape
 */
#define	_IO_MT		'm'	/* Rimfire magtape			*/
#define	_IO_RF		'R'	/* Rimfire winchester			*/
#define	_IO_FD		'F'	/* Floppy disk for SCALD-IV		*/
#define	_IO_DK		'd'	/* Generic disk ioctl; Valid's SMD	*/

#define	_IO_MAP		'M'	/* Device to physaddr map		*/

/*
 * Valid's "Black Holes"
 */
#define	_IO_VGB		'G'	/* Video Graphics board (8086)		*/
#define	_IO_VPB		'V'	/* Peripherial Interface board (8086)	*/
#define _IO_LASAR	'L'	/* LASAR Validation device		*/

/*
 * Indigenous to WHITE
 */
#define	_IO_CAL		'c'	/* SCALD-IV calendar device		*/
#define	_IO_MOM		'o'	/* Omninet network interface (old 4.1c)	*/
#define	_IO_MO		'q'	/* Omninet network interface (4.2)	*/

/*
 * Heterogeneous networking -- TCP/IP related.
 */
#define	_IO_IF		'i'	/* Interface controls			*/
#define	_IO_ARP		'A'	/* Address Resolution Protocol for IP	*/
#define	_IO_3COM	'3'	/* 3COM ethernet controller		*/

/*
 * TCI/DECnet
 */
#define	_IO_LL		'l'	/* EXOS/DECnet logical link driver	*/
#define	_IO_NETMAN	'n'	/* EXOS/DECnet network management driver */
#define	_IO_DAP		'D'	/* EXOS/DECnet DAP (file transfer driver) */
#define	_IO_XM		'X'	/* EXOS download driver			*/

/*
 * CONN, RPC, EFS, DFS + BULK and BCAST -- Valid's homogeneous network:
 */
#define _IO_VNET	'v'	/* Generic VALIDnet			*/
#define	_IO_BCAST	'E'	/* Broadcast service			*/
#define	_IO_BULK	'E'	/* Bulkdata transport for EFS and DFS	*/
#define	_IO_CONN	'E'	/* Connection management for RPC	*/
#define	_IO_RPC		'E'	/* Remote Procedure Call service	*/
#define	_IO_EFS		'E'	/* Extended File System			*/
#define	_IO_DFS		'E'	/* Disritibuted File System		*/

/*
 * tty ioctl commands
 */
#define	TIOCGETD	_IOR(_IO_TTY, 0, int)	/* get line discipline */
#define	TIOCSETD	_IOW(_IO_TTY, 1, int)	/* set line discipline */
#define	TIOCHPCL	_IO(_IO_TTY, 2)		/* hang up on last close */
#define	TIOCMODG	_IOR(_IO_TTY, 3, int)	/* get modem control state */
#define	TIOCMODS	_IOW(_IO_TTY, 4, int)	/* set modem control state */
#define		TIOCM_LE	0001		/* line enable */
#define		TIOCM_DTR	0002		/* data terminal ready */
#define		TIOCM_RTS	0004		/* request to send */
#define		TIOCM_ST	0010		/* secondary transmit */
#define		TIOCM_SR	0020		/* secondary receive */
#define		TIOCM_CTS	0040		/* clear to send */
#define		TIOCM_CAR	0100		/* carrier detect */
#define		TIOCM_CD	TIOCM_CAR
#define		TIOCM_RNG	0200		/* ring */
#define		TIOCM_RI	TIOCM_RNG
#define		TIOCM_DSR	0400		/* data set ready */
#define	TIOCGETP	_IOR(_IO_TTY, 8,struct sgttyb)/* get parameters -- gtty */
#define	TIOCSETP	_IOW(_IO_TTY, 9,struct sgttyb)/* set parameters -- stty */
#define	TIOCSETN	_IOW(_IO_TTY,10,struct sgttyb)/* as above, but no flushtty */
#define	TIOCEXCL	_IO(_IO_TTY, 13)	/* set exclusive use of tty */
#define	TIOCNXCL	_IO(_IO_TTY, 14)	/* reset exclusive use of tty */
#define	TIOCFLUSH	_IOW(_IO_TTY, 16, int)	/* flush buffers */
#define	TIOCSETC	_IOW(_IO_TTY,17,struct tchars)/* set special characters */
#define	TIOCGETC	_IOR(_IO_TTY,18,struct tchars)/* get special characters */
#ifdef s32
#define TIOCSET		_IOW(_IO_TTY, 19, long)	/* set tty flags */
#define TIOCBIS		_IOW(_IO_TTY, 20, long)	/* bis tty flags */
#define TIOCBIC		_IOW(_IO_TTY, 21, long)	/* bic tty flags */
#define TIOCGET		_IOR(_IO_TTY, 22, long)	/* get all tty flags */
#endif s32
#define		TANDEM		0x00000001	/* send stopc on out q full */
#define		CBREAK		0x00000002	/* half-cooked mode */
#define		LCASE		0x00000004	/* simulate lower case */
#define		ECHO		0x00000008	/* echo input */
#define		CRMOD		0x00000010	/* map \r to \r\n on output */
#define		RAW		0x00000020	/* no i/o processing */
#define		ODDP		0x00000040	/* get/send odd parity */
#define		EVENP		0x00000080	/* get/send even parity */
#define		ANYP		0x000000c0	/* get any parity/send none */
#define		NLDELAY		0x00000300	/* \n delay */
#define			NL0	0x00000000
#define			NL1	0x00000100	/* tty 37 */
#define			NL2	0x00000200	/* vt05 */
#define			NL3	0x00000300
#define		TBDELAY		0x00000c00	/* horizontal tab delay */
#define			TAB0	0x00000000
#define			TAB1	0x00000400	/* tty 37 */
#define			TAB2	0x00000800
#define		XTABS		0x00000c00	/* expand tabs on output */
#define		CRDELAY		0x00003000	/* \r delay */
#define			CR0	0x00000000
#define			CR1	0x00001000	/* tn 300 */
#define			CR2	0x00002000	/* tty 37 */
#define			CR3	0x00003000	/* concept 100 */
#define		VTDELAY		0x00004000	/* vertical tab delay */
#define			FF0	0x00000000
#define			FF1	0x00004000	/* tty 37 */
#define		BSDELAY		0x00008000	/* \b delay */
#define			BS0	0x00000000
#define			BS1	0x00008000
#define 	ALLDELAY	(NLDELAY|TBDELAY|CRDELAY|VTDELAY|BSDELAY)
#define		CRTBS		0x00010000	/* do backspacing for crt */
#define		PRTERA		0x00020000	/* \ ... / erase */
#define		CRTERA		0x00040000	/* " \b " to wipe out char */
#define		TILDE		0x00080000	/* hazeltine tilde kludge */
#define		MDMBUF		0x00100000	/* start/stop output on carrier intr */
#define		LITOUT		0x00200000	/* literal output */
#define		TOSTOP		0x00400000	/* SIGSTOP on background output */
#define		FLUSHO		0x00800000	/* flush output to terminal */
#define		NOHANG		0x01000000	/* no SIGHUP on carrier drop */
#define		L001000		0x02000000
#define		CRTKIL		0x04000000	/* kill line with " \b " */
#define		L004000		0x08000000
#define		CTLECH		0x10000000	/* echo control chars as ^X */
#define		PENDIN		0x20000000	/* tp->t_rawq needs reread */
#define		DECCTQ		0x40000000	/* only ^Q starts after ^S */
#define		NOFLSH		0x80000000	/* no output flush on signal */
#ifdef s32
#define TIOCCSET	_IOW(_IO_TTY,23,struct ttychars)/* set special characters */
#define TIOCCGET	_IOR(_IO_TTY,24,struct ttychars)/* get special characters */
#endif s32
/* locals, from 127 down */
#define	TIOCLBIS	_IOW(_IO_TTY, 127, int)	/* bis local mode bits */
#define	TIOCLBIC	_IOW(_IO_TTY, 126, int)	/* bic local mode bits */
#define	TIOCLSET	_IOW(_IO_TTY, 125, int)	/* set entire local mode word */
#define	TIOCLGET	_IOR(_IO_TTY, 124, int)	/* get local modes */
#define		LCRTBS		(CRTBS>>16)
#define		LPRTERA		(PRTERA>>16)
#define		LCRTERA		(CRTERA>>16)
#define		LTILDE		(TILDE>>16)
#define		LMDMBUF		(MDMBUF>>16)
#define		LLITOUT		(LITOUT>>16)
#define		LTOSTOP		(TOSTOP>>16)
#define		LFLUSHO		(FLUSHO>>16)
#define		LNOHANG		(NOHANG>>16)
#define		LCRTKIL		(CRTKIL>>16)
#define		LCTLECH		(CTLECH>>16)
#define		LPENDIN		(PENDIN>>16)
#define		LDECCTQ		(DECCTQ>>16)
#define		LNOFLSH		(NOFLSH>>16)
#define	TIOCSBRK	_IO(_IO_TTY, 123)	/* set break bit */
#define	TIOCCBRK	_IO(_IO_TTY, 122)	/* clear break bit */
#define	TIOCSDTR	_IO(_IO_TTY, 121)	/* set data terminal ready */
#define	TIOCCDTR	_IO(_IO_TTY, 120)	/* clear data terminal ready */
#define	TIOCGPGRP	_IOR(_IO_TTY, 119, int)	/* get pgrp of tty */
#define	TIOCSPGRP	_IOW(_IO_TTY, 118, int)	/* set pgrp of tty */
#define	TIOCSLTC	_IOW(_IO_TTY,117,struct ltchars)/* set local special chars */
#define	TIOCGLTC	_IOR(_IO_TTY,116,struct ltchars)/* get local special chars */
#define	TIOCOUTQ	_IOR(_IO_TTY, 115, int)	/* output queue size */
#define	TIOCSTI		_IOW(_IO_TTY, 114, char)/* simulate terminal input */
#define	TIOCNOTTY	_IO(_IO_TTY, 113)	/* void tty association */
#define	TIOCPKT		_IOW(_IO_TTY, 112, int)	/* pty: set/clear packet mode */
#define		TIOCPKT_DATA		0x00	/* data packet */
#define		TIOCPKT_FLUSHREAD	0x01	/* flush packet */
#define		TIOCPKT_FLUSHWRITE	0x02	/* flush packet */
#define		TIOCPKT_STOP		0x04	/* stop output */
#define		TIOCPKT_START		0x08	/* start output */
#define		TIOCPKT_NOSTOP		0x10	/* no more ^S, ^Q */
#define		TIOCPKT_DOSTOP		0x20	/* now do ^S ^Q */
#define	TIOCSTOP	_IO(_IO_TTY, 111)	/* stop output, like ^S */
#define	TIOCSTART	_IO(_IO_TTY, 110)	/* start output, like ^Q */
#define	TIOCMSET	_IOW(_IO_TTY, 109, int)	/* set all modem bits */
#define	TIOCMBIS	_IOW(_IO_TTY, 108, int)	/* bis modem bits */
#define	TIOCMBIC	_IOW(_IO_TTY, 107, int)	/* bic modem bits */
#define	TIOCMGET	_IOR(_IO_TTY, 106, int)	/* get all modem bits */
#define	TIOCREMOTE	_IO(_IO_TTY, 105)		/* remote input editing */
#ifdef s32
#define TIOCOLDOUTQ	_IOR(_IO_TTY, 104, int)	/* compatibility with 7.0 */
#define TIOSCONSOLE	_IO(_IO_TTY, 103)	/* set virtual console */
#define TIOGCONSOLE	_IOR(_IO_TTY, 102, dev_t)/* get virtual console */
#ifdef WHITE
#define TIOCMERGE	_IO(_IO_TTY, 101)
#define TIOCGCURSOR	_IOR(_IO_TTY, 100, sizeof(struct graphics_cursor))
#define TIOCSCURSOR	_IOW(_IO_TTY, 99, sizeof(struct graphics_cursor))
#endif WHITE
#endif s32

#define	OTTYDISC	0		/* old, v7 std tty driver */
#define	NETLDISC	1		/* line discip for berk net */
#define	NTTYDISC	2		/* new tty discipline */
#define	TABLDISC	3		/* hitachi tablet discipline */
#define	NTABLDISC	4		/* gtco tablet discipline */
#ifdef WHITE
#define MOUSELDISC	5		/* mouse line, see ../white/mouse.c */
#endif WHITE

#define	FIOCLEX		_IO(_IO_FIO, 1)		/* set exclusive use on fd */
#define	FIONCLEX	_IO(_IO_FIO, 2)		/* remove exclusive use */
/* another local */
#define	FIONREAD	_IOR(_IO_FIO, 127, int)	/* get # bytes to read */
#define	FIONBIO		_IOW(_IO_FIO, 126, int)	/* set/clear non-blocking i/o */
#define	FIOASYNC	_IOW(_IO_FIO, 125, int)	/* set/clear async i/o */
#define	FIOSETOWN	_IOW(_IO_FIO, 124, int)	/* set owner */
#define	FIOGETOWN	_IOR(_IO_FIO, 123, int)	/* get owner */

/* socket i/o controls */
#define	SIOCSHIWAT	_IOW(_IO_SOC,  0, int)		/* set high watermark */
#define	SIOCGHIWAT	_IOR(_IO_SOC,  1, int)		/* get high watermark */
#define	SIOCSLOWAT	_IOW(_IO_SOC,  2, int)		/* set low watermark */
#define	SIOCGLOWAT	_IOR(_IO_SOC,  3, int)		/* get low watermark */
#define	SIOCATMARK	_IOR(_IO_SOC,  7, int)		/* at oob mark? */
#define	SIOCSPGRP	_IOW(_IO_SOC,  8, int)		/* set process group */
#define	SIOCGPGRP	_IOR(_IO_SOC,  9, int)		/* get process group */

#define	SIOCADDRT	_IOW(_IO_ROUTE, 10, struct rtentry) /* add route */
#define	SIOCDELRT	_IOW(_IO_ROUTE, 11, struct rtentry) /* delete route */

#define	SIOCSIFADDR	_IOW(_IO_IF, 12, struct ifreq)	/* set ifnet address */
#define	SIOCGIFADDR	_IOWR(_IO_IF,13, struct ifreq)	/* get ifnet address */
#define	SIOCSIFDSTADDR	_IOW(_IO_IF, 14, struct ifreq)	/* set p-p address */
#define	SIOCGIFDSTADDR	_IOWR(_IO_IF,15, struct ifreq)	/* get p-p address */
#define	SIOCSIFFLAGS	_IOW(_IO_IF, 16, struct ifreq)	/* set ifnet flags */
#define	SIOCGIFFLAGS	_IOWR(_IO_IF,17, struct ifreq)	/* get ifnet flags */
#define	SIOCGIFCONF	_IOWR(_IO_IF,20, struct ifconf)	/* get ifnet list */

#ifdef s32
/*
 * Mapping h/w to addresses:
 */
struct mapphys
{
	char	*vaddr;		/* Virtual address */
	char	*paddr;		/* Physical address */
	int	size;		/* Size (bytes) */
};

struct	mapphys	reportPhys;

#define IOCMAPPHYS	_IOW(_IO_MAP, 0, struct mapphys)
#define IOCMAPBOARD	_IOW(_IO_MAP, 1, char *)
#define IOCMAPIOSPACE	_IOW(_IO_MAP, 2, char *)
#define IOCPROCPROF	_IO(_IO_MAP,  3)
#define IOCREPORTPADDR	_IOWR(_IO_MAP,4, struct mapphys)


#define	VGFLUSH		_IO(_IO_VGB,0)
#ifdef	WHITE
#define	VGWINDOW	_IO(_IO_VGB,1)
#else	WHITE
#define	VGWINDOW	_IO(_IO_VGB,31)
#endif	WHITE

/*
 * LASAR validation
 */
#define LIOCVALIDATE	_IOR(_IO_LASAR, 0, short)

#endif s32
#ifdef WHITE
/*
 * ioctls for floppy (../white/fd.c)
 */

#define FDIOCRESET	_IO(_IO_FD,  0)
#define	FDIOCSETTYPE	_IOWR(_IO_FD,1, struct fd_type)
#define FDIOCGETTYPE	_IOR(_IO_FD, 2, struct fd_type)
#define FDIOCSEEK	_IOW(_IO_FD, 3, struct fd_type)
#define FDIOCFORMAT	_IOW(_IO_FD, 4, struct fd_type)
#define FDIOCVERIFY	_IOW(_IO_FD, 5, struct fd_type)
#define FDIOCREADID	_IOW(_IO_FD, 6, struct fd_type)

/*
 * ioctl for cal (../white/cal.c)
 */

#define	CALIOCRESTART	_IO(_IO_CAL, 0)
#endif	WHITE
#endif	_IOCTL_
