/* rcsid[]="$Header: dmap.h,v 820.1 86/12/04 19:48:46 root Exp $" */
/* sccsid[]="%W% %Y% %Q% %G%" */

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*	dmap.h	6.1	83/07/29	*/

/*
 * Definitions for the mapping of vitual swap
 * space to the physical swap area - the disk map.
 */
#ifndef	SYS_DMAP_H
#define	SYS_DMAP_H

#ifdef s32
/*
 * Changed from 34 to 40 in order to handle boundry conditions for large
 * virtual memory systems.
 *
 * ELP - 5/7/86
 */
#define	NDMAP 		40	/* size of the swap area map */
#else s32

#define	NDMAP 		16	/* size of the swap area map */
#endif s32

struct	dmap
{
	swblk_t	dm_size;	/* current size used by process */
	swblk_t	dm_alloc;	/* amount of physical swap space allocated */
	swblk_t	dm_map[NDMAP];	/* first disk block number in each chunk */
};
#ifdef KERNEL
struct	dmap zdmap;
int	dmmin, dmmax, dmtext;
#endif

/*
 * The following structure is that ``returned''
 * from a call to vstodb().
 */
struct	dblock
{
	swblk_t	db_base;	/* base of physical contig drum block */
	swblk_t	db_size;	/* size of block */
};
#endif	SYS_DMAP_H
