static char rcsid[] = "$Header: print.c,v 800.1 85/09/24 15:51:07 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

#
/****************************************************************************

	DEBUGGER

****************************************************************************/
#include "defs.h"

MSG		LONGFIL;
MSG		NOTOPEN;
MSG		A68BAD;
MSG		A68LNK;
MSG		BADMOD;
MAP		txtmap;
MAP		datmap;
SYMPTR		symbol;
INT		lastframe;
INT		callpc;
FILE		*infile;
FILE		*outfile;
INT		fcor;
CHAR		*lp;
INT		maxpos;
INT		hexf = TRUE;		/* 0-decimal, TRUE-hex	   */
INT		hexa = FALSE;		/* 0-noadjust, TRUE-adjust */

/* breakpoints */
BKPTR		bkpthead;

REGLIST reglist[] =
{
		"d0",  0, 0,
		"d1",  1, 0,
		"d2",  2, 0,
		"d3",  3, 0,
		"d4",  4, 0,
		"d5",  5, 0,
		"d6",  6, 0,
		"d7",  7, 0,
		"a0",  8, 0,
		"a1",  9, 0,
		"a2", 10, 0,
		"a3", 11, 0,
		"a4", 12, 0,
		"a5", 13, 0,
		"a6", 14, 0,
		"sp", 15, 0,
		"pc", 16, 0,
		"ps", 17, 0,
};

char		lastc;
INT		fcor;
STRING		errflg;
L_INT		dot;
L_INT		var[];
STRING		symfil;
STRING		corfil;
INT		pid;
L_INT		adrval;
INT		adrflg;
L_INT		cntval;
INT		cntflg;
INT		signum;
STRING		signals[] = 
{ "","hangup","interrupt","quit","illegal instruction","trace trap","IOT",
  "EMT","floating exception","killed","bus error","segmentation violation",
  "bad syscall argument","broken pipe","alarm","terminated",
  "urgent condition", "stop", "tty stop", "continue", "child",
  "tty input", "tty output", "io possible", "cpu time limit",
  "file size limit", "virtual alarm", "profiling" };

printtrace(modif)
{
	INT		narg, i, stat, name, limit;
	POS		dynam;
	register BKPTR	bkptr;
	CHAR		hi, lo;
	INT		word;
	STRING		comptr;
	L_INT		argp, w1, w2;
	SYMPTR		symp;
	int		space;

	IF cntflg==0 THEN cntval = -1; FI

	switch (modif)
	{
	    case '<':
	    case '>':
 	    {
		CHAR	file[64];
		INT	index;
		CHAR	**incdir,*operation;
		FILE	**tempfile;

		index=0;
		IF modif=='<'
		THEN	iclose();
		ELSE	oclose();
		FI
		IF rdc()!=EOR
		THEN	REP file[index++]=lastc;
			    IF index>=63 THEN error(LONGFIL); FI
			PER readchar()!=EOR DONE
			file[index]=0;
			if (modif == '<')
			{
				operation = "r";
				tempfile = &infile;
			}
			else /* modif == '>' */
			{
				operation = "w";
				tempfile = &outfile;
			}
			*tempfile=fopen(file,operation);/* try first choice */
			if (*tempfile == NULL)		/* nobody home */
			{
				/* check stack of include directories. */
				for (incdir=Idirs;incdir<lastincl;incdir++)
				{
					*tempfile = fopen(concat(*incdir,file),operation);
					if (*tempfile != NULL)
						break;
				}
				if (*tempfile == NULL)
					error(NOTOPEN);
				else if (tempfile == &outfile)
					fseek(outfile,0L,2);
			}

		FI
		lp--;
		}
		break;

	    case 'x':
		hexf = TRUE; break;

	    case 'H':
		hexa = TRUE; break;	

	    case 'd':
		hexf = FALSE; break;

	    case 'q': case 'Q': case '%':
		done();

	    case 'w': case 'W':
		maxpos = (adrflg ? adrval : MAXPOS);
		break;

	    case 's': case 'S':
		maxoff = (adrflg ? adrval : MAXOFF);
		break;

	    case 'v': case 'V':
		prints("variables\n");
		FOR i=0;i<=35;i++
		DO IF var[i]
		   THEN printc((i<=9 ? '0' : 'a'-10) + i);
			printf(" = %X\n",var[i]);
		   FI
		OD
		break;

	    case 'm': case 'M':
		printmap("? map",&txtmap);
		printmap("/ map",&datmap);
		break;

	    case 0: case '?':
		if (pid) printf("sub-process id = %d\n", pid);
		prints(signals[signum]);

	    case 'r': case 'R':
		if (pid || (fcor != -1)) printregs();
		else prints("no process or core image\n");
		return;

	    case 'c': case 'C':
		if (pid) backtr(getreg(pid, reglist[a6].roffs), cntval);
		else if (fcor != -1) backtr(reglist[a6].rval, cntval);
		else prints("no process or core image\n");
		break;

	    /*print externals*/
	    case 'e': case 'E':
		symset();
		while (symp = symget())
		if( symp->symf & N_EXT )
		{
			switch( symp->symf & 07 )
			{
			case N_TEXT:	space = ISP; break;
			case N_BSS:	space = NSP; break;
			default:	space = DSP; break;
			}
			printf("%s:\t%X\t%X\n", symp->symc, symp->vals, get(leng(symp->vals), space) );
		}
		break;

	    /*print breakpoints*/
	    case 'b': case 'B':
		printf("breakpoints\ncount%8tbkpt%24tcommand\n");
		for (bkptr = bkpthead; bkptr; bkptr=bkptr->nxtbkpt)
		if (bkptr->flag)
		{
			printf("%-8.8d", bkptr->count);
			psymoff(leng(bkptr->loc), ISYM, "%24t");
			comptr = bkptr->comm;
			while (*comptr) printc(*comptr++);
		}
		break;

	    default:
		error(BADMOD);
	}
}

printmap(s, amap)
STRING	s;
MAP	*amap;
{
	int file = amap->ufd;
	printf("%s\t`%s'\n", s,
		(file < 0 ? "-" : (file == fcor ? corfil : symfil)));
	printf("b1 = %X\t", amap->b1);
	printf("e1 = %X\t", amap->e1);
	printf("f1 = %X\t", amap->f1);
	printf("\nb2 = %X\t", amap->b2);
	printf("e2 = %X\t", amap->e2);
	printf("f2 = %X", amap->f2);
	printc(EOR);
}

printregs()
{
	register int	i;
	register long	v;

	printf("ps\t");
	for (i=0; i < strlen("CVZNX"); i++)
		if (reglist[ps].rval & (1<<i)) printf("%c","CVZNX"[i]);
	printf("\n%s\t%X\t", "pc", reglist[pc].rval);
	printpc(); printf("\n");
/*	printf("%s\t%X\n\n", "sp", reglist[sp].rval);
*/	for (i = 0; i <= 7; i++)
	{
		printf("%s\t%X", reglist[i].rname, reglist[i].rval);
		while (charpos() % 32) printc(' ');
		printf("%s\t%X\n", reglist[i+8].rname, reglist[i+8].rval);
	}
}

getroffs(regnam)
{
	register REGPTR	p;
	register STRING	regptr;
	CHAR		regnxt;

	regnxt = readchar();
	for (p = reglist; p <= &reglist[ps]; p++)
	{
		regptr = p->rname;
		if ((regnam == *regptr++) && (regnxt == *regptr))
			return(p->roffs);
	}
	lp--;
	return(16);
}

printpc()
{
	dot = reglist[pc].rval;
	psymoff(dot, ISYM, ":");
	printins(0, ISP, chkget(dot, ISP));
	printc(EOR);
}

