static char rcsid[] = "$Header: efs_stat.c,v 820.1 86/12/04 19:47:49 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984, 1985			*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Handle a remote stat call.  Pass the
 * path name to the remote machine and
 * copy the return information into the
 * buffer in the user's address space.
 *
 * jam 840207-09-11-28
 * smj 850813	Remove (enable) refs to NET_SUPER_USER.
 */

#include "../h/param.h"
#include "../h/dir.h"
#include "../h/file.h"
#include "../h/user.h"
#include "../vnet/vnet.h"
#include "../h/inode.h"
#include "../h/nami.h"
#include "../h/stat.h"

#include "../conn/conn.h"
#include "../rpc/rpc.h"
#include "../efs/efs.h"

struct efs_statCall {
	int		uid;		/* UID of caller */
	int		gid;		/* GID of caller */
	int		followlinks;	/* Follow symbolic links (lstat()) */
	/* Null terminated name follows this structure */
};

struct efs_statReturn {
	int		error;		/* Error number or 0 on success */
	struct stat	stat;		/* Buffer containing status */
};

efs_stat(usb, followlinks)
   caddr_t usb;
{
	register connection_t *conn;
	register struct efs_statCall *params;
	register struct efs_statReturn *results;

	if ((conn = efs_uhostLookup()) == NULL) {
		u.u_error = EHOSTUNREACH;
		return;
	}
	params = efs_makePacket(stat,EFS_PATHSIZE);
	params->uid = u.u_uid;
	params->gid = u.u_gid;
	params->followlinks = followlinks;
	efs_getPathname(efs_data(params));
	efs_incClient(stats);
	results = (struct efs_statReturn *)efs_call(conn,EFS_STAT,params);
	if (results == NULL)
		return;
	u.u_error = results->error;
	if (u.u_error == 0) {
		u.u_error = copyout((caddr_t)&results->stat, usb,
				    sizeof(results->stat));
	}
	rpc_freeResults(results);
}

caddr_t
efs_remoteStat(clientConn, clientId, operation, params)
   connection_t *clientConn;
   u_long clientId;
   u_short operation;
   struct efs_statCall *params;
{
	register struct efs_statReturn *results;
	register struct inode *ip;
	extern mbufchar();

	efs_incServer(stats);
	u.u_uid = u.u_ruid = params->uid;
	u.u_gid = u.u_rgid = params->gid;
	efs_checkNetsu();
	u.u_error = 0;
	results = efs_makeReturnPacket(params,stat, 0);
	u.u_dirp = efs_data(params);
	ip = namei(mbufchar, LOOKUP, params->followlinks);
	if (ip == NULL)
		results->error = u.u_error;
	else {
		results->error = 0;
		ino_stat(ip, &results->stat);
		iput(ip);
	}
	rpc_freeParams(params);
	return((caddr_t)results);
}
