static char rcsid[] = "$Header: efs_path.c,v 820.1 86/12/04 19:47:45 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Copy a pathname from the user's address
 * space into the buffer supplied.
 *
 * jam 840207-10-0424
 * jht 850426	Give unnamed bit in p_rpcflags a name: RPCFLAG_EFS_VCD
 */

#include "../h/param.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/mbuf.h"
#include "../vnet/vnet.h"
#include "../conn/conn.h"
#include "../rpc/rpc.h"
#include "../efs/efs.h"
#ifdef EFS_VCD
#include "../h/proc.h"
#endif EFS_VCD

/*
 * Initialize the u.u_dirp field so that it
 * points to the name of the remote machine
 * or to NULL if none is present.  If the
 * path is "[/]net/remote_path" then u.u_dirp
 * will point to "remote_path" else u.u_dirp
 * will point to the null at the end of the
 * whole name.  Return 1 if there is a remote
 * path, else return 0.
 *
 * This function should not exist and would
 * not if brain-damaged namei() left u.u_dirp
 * pointing to the correct place.
 */
efs_initPath()
{
	u.u_dirp = (caddr_t)u.u_ap[0];
#ifdef EFS_VCD
	if ((u.u_procp->p_rpcflags & RPCFLAG_EFS_VCD) && fubyte(u.u_ap[0]) != '/') {
		register char *cwdp = (char *)u.u_stack;

		if (*cwdp++ == '/' && *cwdp++ == 'n' && *cwdp++ == 'e' &&
		    *cwdp++ == 't' && *cwdp++ == '/')
			return(1);
		return(0);
	}
#endif EFS_VCD
	while (uchar() == '/')
		;
	--u.u_dirp;
	if (uchar() == 'n' && uchar() == 'e' && uchar() == 't' &&
	    uchar() == '/')
		return(1);
	while (uchar())
		;
	--u.u_dirp;
	return(0);
}
/*
 * Copy the pathname into the buffer which
 * must be a pointer into the data of an
 * mbuf.  Follow the mbuf structure.
 */
efs_getPathname(buffer)
   register char *buffer;
{
	register struct mbuf *m = dtom(buffer);
	register int left = m->m_len - ((int)buffer - mtod(m, int));
	register int count = EFS_PATHSIZE;

#ifdef EFS_VCD
	if ((u.u_procp->p_rpcflags & RPCFLAG_EFS_VCD) && fubyte(u.u_ap[0]) != '/') {
		register char *cwdp = (char *)u.u_stack + 4;

		while (*++cwdp && *cwdp != '/')
			;
		do {
			if (left-- == 0) {
				m = m->m_next;
				left = m->m_len;
				buffer = mtod(m, char *);
			}
			if (--count == 0)
			{
				*buffer = '\0';
				return;
			}
		} while (*buffer++ = *cwdp++);
		buffer[-1] = '/';
	}
#endif EFS_VCD
	do {
		if (left-- == 0) {
			m = m->m_next;
			left = m->m_len;
			buffer = mtod(m, char *);
		}
		if (--count == 0)
		{
			*buffer = '\0';
			return;
		}
	} while (*buffer++ = uchar());
}
