static char rcsid[] = "$Header: dfs_ioctl.c,v 820.1 86/12/04 19:44:18 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * I/O control interface for the Distributed File System.
 *
 * bvs 840424 -- copied most of the source from efs_ioctl.c
 * jht 841115,16,26-29 -- complete conversion to use prpc.
 * jht 850401 -- fill out the gathering of statistics.
 * jht 850531-- Centralize the ioctl 'x' definitions; decentralize their use.
 */

#include "../h/param.h"
#include "../h/dir.h"
#include "../h/socket.h"
#include "../h/kernel.h"
#include "../net/if.h"
#include "../h/mbuf.h"
#include "../h/user.h"

#include "../vnet/vnet.h"
#include "../conn/conn.h"
#include "../rpc/rpc.h"
#include "../dfs/dfs.h"
#include "../dfs/dfs_ioctl.h"

extern int dfsClient_null();

dfs_ioctl(dev, com, data, flag)
	dev_t			dev;
	register caddr_t	data;
{
	register connection_t *	conn;
	extern	 connection_t *	dfs_uhostLookup();
	extern	 int		dfs_enabled;
	register int		error = 0;

	dfs_incClient(ioctl);
	switch (com)
	{

	case DFS_IOCNULLCALL:
		u.u_dirp = *(caddr_t *)data;
		if ((conn = dfs_uhostLookup()) == NULL)
			return(EHOSTDOWN);
		error = dfsClient_null(conn);
		break;

	case DFS_IOCSHUTDOWN:
		if (dfs_enabled)
			dfs_shutdown();
		else
			error = EBADIOCTL;
		break;
	
	case DFS_IOCENABLE:
		dfs_init();
		break;

	case DFS_IOCGETSTATS:
		if (dfs_enabled)
			bcopy((caddr_t)&dfs_stats, data, sizeof(dfs_stats));
		else
			error = EBADIOCTL;
		break;

	default:
		error = EBADIOCTL;
		break;
	}
	return(error);
}
