static char rcsid[] = "$Header: emptyexec.c,v 820.1 86/12/04 19:42:15 root Exp $";
static char sccsid[]="%W% %Y% %Q% %G%";

/************************************************************************
*									*
*				Copyright 1984				*
*			VALID LOGIC SYSTEMS INCORPORATED		*
*									*
*	This listing contains confidential proprietary information	*
*	which is not to be disclosed to unauthorized persons without	*
*	written consent of an officer of Valid Logic Systems 		*
*	Incorporated.							*
*									*
*	The copyright notice appearing above is included to provide	*
*	statutory protection in the event of unauthorized or 		*
*	unintentional public disclosure.				*
*									*
************************************************************************/

/*
 * Create an empty a.out format file.  Unless
 * forced by the -f option only modify those
 * files which are known to be in bad format.
 *
 * jam 831227
 */

#define EMPTYLEN	32		/* Length of an empty file */
#define BADLEN		32		/* Length of the known bad files */

int	forceflg;		/* Force each file to be emptied */
int	ignoreflg;		/* Ignore files which are not bad */

char emptyimage[BADLEN] = { 0, 0, 1, 7 };
char badimage[BADLEN] = { 0, 0, 1, 7, 0, 0, 0, 0x14 };

main(argc, argv)
   int argc;
   char **argv;
{
	if (argc > 1 && !strcmp(argv[1], "-f"))
		forceflg = 1, --argc, ++argv;
	if (argc > 1 && !strcmp(argv[1], "-i"))
		ignoreflg = 1, --argc, ++argv;
	if (argc == 1)
		printf("Usage:  emptyexec  [ -fi ]  file ...\n"),
		exit(1);
	while (--argc)
	{
		++argv;
		if (forceflg || checkbad(*argv))
			emptyfile(*argv);
	}
	exit(0);
}
/*
 * Check whether or not a file is bad.  Return
 * 1 if it is, 0 if not.
 */
int checkbad(file)
   char *file;
{
	register int i,fd;
	char buffer[BADLEN+1];

	if ((fd = open(file, 0)) == -1)
	{
		printf("cannot open %s\n", file);
		return(0);
	}
	i = read(fd, buffer, BADLEN+1);
	close(fd);
	if (i != BADLEN)
	{
		if (!ignoreflg)
			printf("not a bad file: %s\n", file);
		return(0);
	}
	for (i=0; i<BADLEN; ++i)
	{
		if (buffer[i] != badimage[i])
		{
			if (!ignoreflg)
				printf("not a bad file: %s\n", file);
			return(0);
		}
	}
	return(1);
}
/*
 * Create an empty a.out file.
 */
emptyfile(file)
   char *file;
{
	register int fd;

	if ((fd = open(file, 1)) == -1 &&
	    (fd = creat(file, 0666)) == -1)
	{
		printf("cannot create %s\n", file);
		return;
	}
	if (write(fd, emptyimage, EMPTYLEN) != EMPTYLEN)
		printf("write error on %s\n", file);
	printf("Emptied %s\n", file);
	close(fd);
}
