*** MENU4.PRG ::= stack_bar menu
*** I am using PgDn/PgUp to show next/previous customer records
*** You could do the same thing with the Up/Down arrow keys and
*** scroll multiple records on the screen
*** Home/End go to top/bottom of the file

*** One reason I like this better than Clipper's menu command is that
*** the 'menu' and 'prompt' rewrite the menu line since they are similar
*** to a 'read' and I can see it.

*==================================================================
*   Michael Palladino, 11/15/87, (415)751-2719
*   Mail to AVELINO on GEnie
*------------------------------------------------------------------
*  
*   1) Made stack_menu a procedure, passing in the arrays and the newopt memvar
*
*   2) Array a_cols[] (to determine placement of menu items) computes
*      automatically based on menucol (starting column for menu)
*      and menu_space (number of spaces between menu items).
*
*   3) Optkeys initializes automatically by taking the leftmost character
*      of each menu item in array a_opts[].
*
*   4) CASE for menu choices analyzes the actual menu word, instead of a
*      menu choice number (a la SAY WHAT screen generator).  This makes
*      it easy to reorder or add to menu choices without renumbering
*      the CASES
*
*   5) The ON_OFF() UDF will SET COLO TO &x and back to the default
*      setting in-line, without having to type the two SET COLO TO lines
*===================================================================  
*===================================================================
* YET TO COME.....
* A program generator that will pump out this program and the regular
* bar menu in a text form based on your menu options and 
* placement of the menu, probably by December 1987
*===================================================================

*===
* Memvars
*---
PUBLIC sc_dim, sc_bt, sc_rev, homekey, endkey, pgupkey, pgdnkey, esckey,;
upkey, downkey, rightkey, leftkey, car_ret, spacebar, menurow, menucol,;
msgrow, msgcol
sc_dim   = "W/N,N/W,N,,W+/N"
sc_bt    = "W+/N,N/W,N,,W+/N"
sc_rev   = "N/W,W+/N,N,,W+/N"
homekey  =  1
endkey   =  6
pgupkey  = 18
pgdnkey  =  3
esckey   = 27
upkey    =  5
downkey  = 24
rightkey =  4
leftkey  = 19
car_ret  = 13
spacebar = 32

*=== Number of menu choices, first letter of each
numopts = 6
DECLARE a_opts[numopts], a_cols[numopts], a_msg[numopts]

*=== Menu options
a_opts[1] = "Add    "
a_opts[2] = "Edit   "
a_opts[3] = "Delete "
a_opts[4] = "Search "
a_opts[5] = "Print  "
a_opts[6] = "Quit   "

*=== Messages
a_msg[1] = "Add a new customer         "
a_msg[2] = "Edit this record           "
a_msg[3] = "Delete this record         "
a_msg[4] = "Search by customer no./name"
a_msg[5] = "Print this record          "
a_msg[6] = "Exit to DOS                "

*=== Valid entries for option keys (leftmost letter of each element)
optkeys = ""
FOR i = 1 TO numopts
   optkeys = optkeys + LEFT(a_opts[i],1)
NEXT

*=== Column positions
menucol   =  3
menurow   =  10

newopt  = 1                                       && default menu choice
topline = 3                                      && for screen display
msgrow  = topline + 17
msgcol  = 15
SELECT 1
USE customer ALIAS cst
GO TOP

CALL CURSOR WITH "off"                           && from Rettig's library
CLEAR

DO custscn

*===
* Paint menu stack
*---
@ menurow - 1, menucol - 1 SAY ON_OFF("   MENU   ", sc_rev)
@ menurow, menucol - 1 TO menurow + LEN(a_opts) + 1,;
menucol + LEN(a_opts[1]) + 1 DOUBLE 

FOR i = 1 TO numopts
   @ menurow + i, menucol SAY a_opts[i]
NEXT

DO showcust

DO WHIL .T.

   *=== Validate keypress, act on cursor key options, pass newopt
   DO stack_menu WITH newopt, a_opts, a_msg, a_cols
 
  *===
   * perform selected option
   *
   * The CASE that is evaluated is the menu word taken directly from
   * the a_opts array, a la SAY WHAT menu/word passing.  This way
   * the CASE is a bit easier to read and if you add or change the
   * order of the menu, you don't have to renumber the CASE selections
   *===
   DO CASE
      CASE UPPE(TRIM(a_opts[newopt])) = "ADD"
         * add a new customer
         @ 0,0 SAY "ADD chosen"
 
      CASE UPPE(TRIM(a_opts[newopt])) = "EDIT"
         * edit current customer
         @ 0,0 SAY "EDIT chosen"
 
      CASE UPPE(TRIM(a_opts[newopt])) = "DELETE"
         * delete a customer
         @ 0,0 SAY "DELETE chosen"
 
      CASE UPPE(TRIM(a_opts[newopt])) = "SEARCH"
         * search for a specific customer by customer# or name
         @ 0,0 SAY "SEARCH chosen"
 
      CASE UPPE(TRIM(a_opts[newopt])) = "PRINT"
         * print info for current customer
         @ 0,0 SAY "PRINT chosen"
 
      CASE UPPE(TRIM(a_opts[newopt])) = "QUIT"
         * all done
         EXIT
   ENDC
 
ENDD
CLOS DATA
CALL CURSOR WITH "on"                            && From Retting library
CLEAR
QUIT


proc SHOWCUST
   set color to &sc_rev
   @ topline+2,21 SAY cst->CUST_NO pict "99999"
   set color to &sc_bt
   @ topline+5,30 SAY cst->COMPANY
   @ topline+6,30 SAY space(35)
   @ topline+6,30 SAY trim(cst->lname)+IF(empty(cst->lname),"",",")+trim(cst->fname)
   @ topline+8,30 SAY cst->ADDR1
   @ topline+9,30 SAY cst->ADDR2
   @ topline+10,30 SAY cst->CITY
   @ topline+11,30 SAY cst->STATE
   @ topline+11,40 SAY cst->ZIP pict "@R 99999-9999"
   @ topline+14,20 SAY cst->AREA pict "999"
   @ topline+14,25 SAY cst->phone pict "@R 999-9999"
   @ topline+14,35 SAY cst->TERMS
   @ topline+14,45 SAY cst->CREDIT pict "999999.99"
   @ topline+14,62 SAY cst->BILLED pict "999999.99"
   set color to &sc_dim
   *** doing this instead of turning the cursor off ***
RETURN


* display fixed text
proc CUSTSCN
   @ topline  ,06 SAY "ͻ"
   @ topline+1,06 SAY "                     "
   @ topline+2,06 SAY " Customer No.        "
   @ topline+3,06 SAY "        ͻ"
   @ topline+4,06 SAY "͹"+space(58)+""
   @ topline+5,15 SAY "   Company...."+space(44)+""
   @ topline+6,15 SAY "   Name(L,F).."+space(44)+""
   @ topline+7,15 SAY ""+space(58)+""
   @ topline+8,15 SAY "   Address...."+space(44)+""
   @ topline+9,15 SAY ""+space(58)+""
   @ topline+10,15 SAY "   City......."+space(44)+""
   @ topline+11,15 SAY "   State......    Zip..."+space(34)+""
   @ topline+12,15 SAY ""+space(58)+""
   @ topline+13,15 SAY "   Telephone       Terms  Credit Limit  Current Balance   "
   @ topline+14,15 SAY "   (   )              Da"+space(34)+""
   @ topline+15,15 SAY ""+space(58)+""
   @ topline+16,15 SAY "ͼ"
RETURN

*===
* stack_menu  ::= validate keypress, move light bar, pass newopt out to CASE
* a_opts, a_msg, a_cols ::= arrays for menu
* newopt    ::= number of next menu choice
*---
PROCEDURE stack_menu
   PARAMETERS newopt, a_opts, a_msg, a_cols
   keypress = 0

   *=== Initialize oldopt if first time thru
   IF TYPE("oldopt") = "U"
      oldopt = 0
   ENDI
      
   * menu loop: iterates ones for each key input, breaks on selection
   DO WHILE .T.
 
      * if selected option has changed, update the bounce-bar
      IF oldopt != newopt
   
         * If first time thru, skip this
         IF oldopt > 0
            * lowlight old option
            @ menurow + oldopt, menucol SAY a_opts[oldopt]
         ENDI
   
         * highlight new option
         @ menurow + newopt, menucol SAY ON_OFF(a_opts[newopt], sc_rev)
         @ msgrow, msgcol  SAY a_msg[newopt]
   
         oldopt = newopt

      ENDI
  
      * if return or an option trigger has been hit, perform the option
      IF keypress == car_ret .OR. UPPE(CHR(keypress)) $ optkeys
         * fall out to action loop
         EXIT
      ENDI
  
      * get key input
      keypress = INKE(0)
      *** erase the stub message at 0,0
      @ 0,0
  
      * update choice number based on key response
      DO CASE
  
         * down arrow/spacebar: increment choice or wrap
         CASE keypress == downkey .OR. keypress == spacebar
            newopt = IIF(oldopt == numopts, 1, oldopt + 1)
  
         * up arrow: decrement choice or wrap
         CASE keypress == upkey
            newopt = IIF(oldopt == 1, numopts, oldopt - 1)
  
         * PgDn: goto next customer record
         CASE keypress == pgdnkey
            SKIP 1
            IF eof()
               GO BOTT
            ENDI
            DO showcust
  
         * PgUp: goto previous customer record
         CASE keypress == pgupkey
            SKIP -1
            IF BOF()
               GO TOP
            ENDI
            DO showcust
  
         CASE keypress == homekey
            * first record
            GO TOP
            DO showcust
  
         CASE keypress == endkey
            * last record
            GO BOTT
            DO showcust
  
            * option trigger: set choice to option
         CASE UPPE(CHR(keypress)) $ optkeys
            newopt = AT(UPPE(CHR(keypress)), optkeys)
  
      ENDC
  
   ENDD
RETURN
*=== EOP stack_menu
*
*===
* on_off  ::= turn screen attributes on/off in_line
* Format  ::= ON_OFF("character str" or memvar, attribute memvar)
* Example ::= ON_OFF("Your message here", sc_bt)
FUNCTION on_off
   PARAMETERS c1, attr
   SET COLO TO &attr
   ?? c1
   SET COLO TO &sc_dim
RETURN("")

