* Installation Notes:  Because this program is one that's fun to play around
* with and, by its nature, is likely to use a database that gradually increases
* in size, I have tried to set things up so the most likely modifications are
* easy to make.  For purposes of identifying different versions of the
* database, the data file has been named ANA?????.DBF to signify it as an
* ANAGRAM file with numerals used in place of the question marks (such as
* ANA12759.DBF in the original version) to designate the number of records in
* the database.  The index file is similarly named KEY?????.NDX to easily
* associate it with the proper data file.  If you are diligent about
* changing the names as you add records, you won't get lost with different
* versions.  To simplify name changing in the program itself, you need to
* change the names only in program lines four and five where the data file 
* and index file names are stored to the memory variables DATAFILE and 
* INDEXFILE respectively.  I have also tried to build in error traps so the
* program itself will check to see if the proper datafile and index files
* exist before executing.  If desired, the program will build its own index
* file or you can do it yourself with the command "INDEX ON KEY TO KEY?????".
* Just be sure to substitute the correct numerals in the name (if you should
* happen to make a mistake, you can RENAME the index file as needed, there is
* no need to start over again).  Because index files generated by different 
* versions of dBase may not be compatible with each other, you should NOT use
* the REINDEX command.  The data file ANA12759.DBF was originally generated
* using dBase II.  If the program is run under dBase III or a varient, the 
* file should copied in Standard Data Format (SDF) to a temporary file and
* appended into a new database created by dBase III or other database system.
* If you would like to add words to the database, just USE ANA????? INDEX
* KEY????? and APPEND a record, filling in the word and the alphabetized key.
* If you are truly ambitious and want to add several words, the associated
* program SIGSORT.CMD will automatically generate the necessary key for
* each word, but be sure to use the index file while appending the new words
* or to generate a new index after adding a large number of words.
* Be sure to insert the correct data file name in SIGSORT.CMD so it will be
* working with the right file.  To speed up processing, you may want to delete
* these notes in your runtime program.  I hope you enjoy the program.
* John Krahmer, Lubbock, Texas.  806-742-3920. 

CLEAR
ERASE
SET TALK OFF
* Change the names as needed in the next two lines to reflect changes in
* the number of records (words) in the database.
STORE 'ANA12759.DBF' TO DATAFILE
STORE 'KEY12759.NDX' TO INDEXFILE

IF .NOT. FILE ('&DATAFILE')
? "I CAN'T FIND THE DATA FILE "+DATAFILE+".  IF YOU HAVE CHANGED THE NAME"
? "OF THE DATAFILE, PLEASE UPDATE THE PROGRAM."
CLEAR
SET TALK ON
RETURN
ENDIF

IF .NOT. FILE ('&INDEXFILE')
STORE F TO CREATE
? 'THE INDEX FILE IS MISSING.  DO YOU WANT ME TO CREATE IT?  I WILL NEED'
? 'APPROXIMATELY 250K AND SEVERAL MINUTES TO BUILD THE INDEX FILE.'
?
INPUT "CREATE FILE (Y/N)?" TO CREATE
IF CREATE
ERASE
SET TALK ON
? 'WORKING -- PLEASE WAIT'
USE &DATAFILE
INDEX ON KEY TO &INDEXFILE
CLEAR
DO ANAGRAM3
ELSE
CLEAR
ERASE
SET TALK ON
RETURN
ENDIF
ENDIF

SET EXACT ON
STORE '$(Q,1,1) <= $(Q,2,1) .AND. $(Q,2,1) <= $(Q,3,1) .AND. $(Q,3,1) <=;
 $(Q,4,1) .AND. $(Q,4,1) <= $(Q,5,1) .AND. $(Q,5,1) <= $(Q,6,1) .AND.;
 $(Q,6,1) <= $(Q,7,1) .AND. $(Q,7,1) <= $(Q,8,1) .AND. $(Q,8,1);
 <= $(Q,9,1)' TO TEST

*SET PRINT ON

USE &DATAFILE INDEX &INDEXFILE
STORE T TO ERROR

DO WHILE ERROR
? 'WORD SIGNATURE LOOK-UP PROGRAM'
? 
? 'ENTER FOUR TO EIGHT LETTERS'
?
ACCEPT "LETTERS?" TO LIST
STORE !(LIST) TO STRING
STORE !(LIST)+'aaaaaa' TO Q

IF LEN(STRING) < 4 .OR. LEN(STRING) > 8
ERASE
? 'STRING MUST BE AT LEAST 4 AND NO MORE THAN 8 LETTERS LONG.'
?
? 'PRESS RETURN TO CONTINUE'
SET CONSOLE OFF
WAIT
SET CONSOLE ON
ERASE
STORE T TO ERROR
ELSE
STORE F TO ERROR
ENDIF
ENDDO

IF &TEST
STORE T TO ALPHA
? 'THE SIGNATURE IS ALREADY ALPHABETIZED -- BEGINNING SEARCH'
ELSE
STORE F TO ALPHA
ENDIF

IF .NOT. ALPHA
? 'WORKING -- PLEASE WAIT'
STORE 65 TO WHATCHR
STORE STRING TO NEWWORD
STORE LEN(TRIM(STRING)) TO LENGTH
STORE ' ' TO MKEY
DO WHILE WHATCHR < 91
DO WHILE LENGTH > 0
DO CASE
CASE @(CHR(WHATCHR),NEWWORD)
STORE (@(CHR(WHATCHR),NEWWORD)+1) TO POINTER
STORE MKEY+CHR(WHATCHR) TO MKEY
	IF POINTER > LENGTH
	STORE 0 TO LENGTH
	ELSE
	STORE LENGTH - (POINTER-1) TO LENGTH
	STORE $(NEWWORD,POINTER) TO NEWWORD
	ENDIF
CASE @(CHR(WHATCHR),NEWWORD)=0
STORE 0 TO LENGTH
CASE LEN(TRIM(STRING))=LEN(MKEY-1)
STORE 0 TO LENGTH
STORE 91 TO WHATCHR
ENDCASE
ENDDO
STORE WHATCHR + 1 TO WHATCHR
STORE LEN(TRIM(STRING)) TO LENGTH
STORE TRIM(STRING) TO NEWWORD
ENDDO
STORE $(MKEY,2) TO STRING
? 'THE ALPHABETIZED SIGNATURE IS '+STRING+' -- BEGINNING SEARCH'
ENDIF

STORE STRING + '........' TO STRING
STORE $(STRING,1,1) TO A
STORE $(STRING,2,1) TO B
STORE $(STRING,3,1) TO C
STORE $(STRING,4,1) TO D
STORE $(STRING,5,1) TO E
STORE $(STRING,6,1) TO F
STORE $(STRING,7,1) TO G
STORE $(STRING,8,1) TO H

IF $(STRING,8,1)<>'.'
? ' *** LOOKING FOR 8 LETTER WORDS ***'
FIND &A&B&C&D&E&F&G&H
LIST OFF WORD WHILE KEY='&A&B&C&D&E&F&G&H'
ENDIF

IF $(STRING,7,1)<>'.'
? ' *** LOOKING FOR 7 LETTER WORDS ***'
FIND &A&B&C&D&E&F&G
LIST OFF WORD WHILE KEY='&A&B&C&D&E&F&G'
FIND &A&B&C&D&E&F&H
LIST OFF WORD WHILE KEY='&A&B&C&D&E&F&H'
FIND &A&B&C&D&E&G&H
LIST OFF WORD WHILE KEY='&A&B&C&D&E&G&H'
FIND &A&B&C&D&F&G&H
LIST OFF WORD WHILE KEY='&A&B&C&D&F&G&H'
FIND &A&B&C&E&F&G&H
LIST OFF WORD WHILE KEY='&A&B&C&E&F&G&H'
FIND &A&B&D&E&F&G&H
LIST OFF WORD WHILE KEY='&A&B&D&E&F&G&H'
FIND &A&C&D&E&F&G&H
LIST OFF WORD WHILE KEY='&A&C&D&E&F&G&H'
FIND &B&C&D&E&F&G&H
LIST OFF WORD WHILE KEY='&B&C&D&E&F&G&H'
ENDIF

IF $(STRING,6,1)<>'.'
? ' *** LOOKING FOR 6 LETTER WORDS ***'
FIND &A&B&C&D&E&F
LIST OFF WORD WHILE KEY='&A&B&C&D&E&F'
FIND &A&B&C&D&E&G
LIST OFF WORD WHILE KEY='&A&B&C&D&E&G'
FIND &A&B&C&D&E&H
LIST OFF WORD WHILE KEY='&A&B&C&D&E&H'
FIND &A&B&C&D&F&G
LIST OFF WORD WHILE KEY='&A&B&C&D&F&G'
FIND &A&B&C&D&F&H
LIST OFF WORD WHILE KEY='&A&B&C&D&F&H'
FIND &A&B&C&D&G&H
LIST OFF WORD WHILE KEY='&A&B&C&D&G&H'
FIND &A&B&C&E&F&G
LIST OFF WORD WHILE KEY='&A&B&C&E&F&G'
FIND &A&B&C&E&F&H
LIST OFF WORD WHILE KEY='&A&B&C&E&F&H'
FIND &A&B&C&E&G&H
LIST OFF WORD WHILE KEY='&A&B&C&E&G&H'
FIND &A&B&C&F&G&H
LIST OFF WORD WHILE KEY='&A&B&C&F&G&H'
FIND &A&B&D&E&F&G
LIST OFF WORD WHILE KEY='&A&B&D&E&F&G'
FIND &A&B&D&E&F&H
LIST OFF WORD WHILE KEY='&A&B&D&E&F&H'
FIND &A&B&D&E&G&H
LIST OFF WORD WHILE KEY='&A&B&D&E&G&H'
FIND &A&B&D&F&G&H
LIST OFF WORD WHILE KEY='&A&B&D&F&G&H'
FIND &A&B&E&F&G&H
LIST OFF WORD WHILE KEY='&A&B&E&F&G&H'
FIND &A&C&D&E&F&G
LIST OFF WORD WHILE KEY='&A&C&D&E&F&G'
FIND &A&C&D&E&F&H
LIST OFF WORD WHILE KEY='&A&C&D&E&F&H'
FIND &A&C&D&E&G&H
LIST OFF WORD WHILE KEY='&A&C&D&E&G&H'
FIND &A&C&D&F&G&H
LIST OFF WORD WHILE KEY='&A&C&D&F&G&H'
FIND &A&C&E&F&G&H
LIST OFF WORD WHILE KEY='&A&C&E&F&G&H'
FIND &A&D&E&F&G&H
LIST OFF WORD WHILE KEY='&A&D&E&F&G&H'
FIND &B&C&D&E&F&G
LIST OFF WORD WHILE KEY='&B&C&D&E&F&G'
FIND &B&C&D&E&F&H
LIST OFF WORD WHILE KEY='&B&C&D&E&F&H'
FIND &B&C&D&E&G&H
LIST OFF WORD WHILE KEY='&B&C&D&E&G&H'
FIND &B&C&D&F&G&H
LIST OFF WORD WHILE KEY='&B&C&D&F&G&H'
FIND &B&C&E&F&G&H
LIST OFF WORD WHILE KEY='&B&C&E&F&G&H'
FIND &B&D&E&F&G&H
LIST OFF WORD WHILE KEY='&B&D&E&F&G&H'
FIND &C&D&E&F&G&H
LIST OFF WORD WHILE KEY='&C&D&E&F&G&H'
ENDIF

IF $(STRING,5,1)<>'.'
? ' *** LOOKING FOR 5 LETTER WORDS ***'
FIND &A&B&C&D&E 
LIST OFF WORD WHILE KEY='&A&B&C&D&E'
FIND &A&B&C&D&F 
LIST OFF WORD WHILE KEY='&A&B&C&D&F'
FIND &A&B&C&D&G 
LIST OFF WORD WHILE KEY='&A&B&C&D&G'
FIND &A&B&C&D&H 
LIST OFF WORD WHILE KEY='&A&B&C&D&H'
FIND &A&B&C&E&F 
LIST OFF WORD WHILE KEY='&A&B&C&E&F'
FIND &A&B&C&E&G 
LIST OFF WORD WHILE KEY='&A&B&C&E&G'
FIND &A&B&C&E&H 
LIST OFF WORD WHILE KEY='&A&B&C&E&H'
FIND &A&B&C&F&G 
LIST OFF WORD WHILE KEY='&A&B&C&F&G'
FIND &A&B&C&F&H 
LIST OFF WORD WHILE KEY='&A&B&C&F&H'
FIND &A&B&C&G&H 
LIST OFF WORD WHILE KEY='&A&B&C&G&H'
FIND &A&B&D&E&F 
LIST OFF WORD WHILE KEY='&A&B&D&E&F'
FIND &A&B&D&E&G 
LIST OFF WORD WHILE KEY='&A&B&D&E&G'
FIND &A&B&D&E&H 
LIST OFF WORD WHILE KEY='&A&B&D&E&H'
FIND &A&B&D&F&G 
LIST OFF WORD WHILE KEY='&A&B&D&F&G'
FIND &A&B&D&F&H 
LIST OFF WORD WHILE KEY='&A&B&D&F&H'
FIND &A&B&D&G&H 
LIST OFF WORD WHILE KEY='&A&B&D&G&H'
FIND &A&B&E&F&G 
LIST OFF WORD WHILE KEY='&A&B&E&F&G'
FIND &A&B&E&F&H 
LIST OFF WORD WHILE KEY='&A&B&E&F&H'
FIND &A&B&E&G&H 
LIST OFF WORD WHILE KEY='&A&B&E&G&H'
FIND &A&B&F&G&H 
LIST OFF WORD WHILE KEY='&A&B&F&G&H'
FIND &A&C&D&E&F 
LIST OFF WORD WHILE KEY='&A&C&D&E&F'
FIND &A&C&D&E&G 
LIST OFF WORD WHILE KEY='&A&C&D&E&G'
FIND &A&C&D&E&H 
LIST OFF WORD WHILE KEY='&A&C&D&E&H'
FIND &A&C&D&F&G 
LIST OFF WORD WHILE KEY='&A&C&D&F&G'
FIND &A&C&D&F&H 
LIST OFF WORD WHILE KEY='&A&C&D&F&H'
FIND &A&C&D&G&H 
LIST OFF WORD WHILE KEY='&A&C&D&G&H'
FIND &A&C&E&F&G 
LIST OFF WORD WHILE KEY='&A&C&E&F&G'
FIND &A&C&E&F&H 
LIST OFF WORD WHILE KEY='&A&C&E&F&H'
FIND &A&C&E&G&H 
LIST OFF WORD WHILE KEY='&A&C&E&G&H'
FIND &A&C&F&G&H 
LIST OFF WORD WHILE KEY='&A&C&F&G&H'
FIND &A&D&E&F&G 
LIST OFF WORD WHILE KEY='&A&D&E&F&G'
FIND &A&D&E&F&H 
LIST OFF WORD WHILE KEY='&A&D&E&F&H'
FIND &A&D&E&G&H 
LIST OFF WORD WHILE KEY='&A&D&E&G&H'
FIND &A&D&F&G&H 
LIST OFF WORD WHILE KEY='&A&D&F&G&H'
FIND &A&E&F&G&H 
LIST OFF WORD WHILE KEY='&A&E&F&G&H'
FIND &B&C&D&E&F 
LIST OFF WORD WHILE KEY='&B&C&D&E&F'
FIND &B&C&D&E&G 
LIST OFF WORD WHILE KEY='&B&C&D&E&G'
FIND &B&C&D&E&H 
LIST OFF WORD WHILE KEY='&B&C&D&E&H'
FIND &B&C&D&F&G 
LIST OFF WORD WHILE KEY='&B&C&D&F&G'
FIND &B&C&D&F&H 
LIST OFF WORD WHILE KEY='&B&C&D&F&H'
FIND &B&C&D&G&H 
LIST OFF WORD WHILE KEY='&B&C&D&G&H'
FIND &B&C&E&F&G 
LIST OFF WORD WHILE KEY='&B&C&E&F&G'
FIND &B&C&E&F&H 
LIST OFF WORD WHILE KEY='&B&C&E&F&H'
FIND &B&C&E&G&H 
LIST OFF WORD WHILE KEY='&B&C&E&G&H'
FIND &B&C&F&G&H 
LIST OFF WORD WHILE KEY='&B&C&F&G&H'
FIND &B&D&E&F&G 
LIST OFF WORD WHILE KEY='&B&D&E&F&G'
FIND &B&D&E&F&H 
LIST OFF WORD WHILE KEY='&B&D&E&F&H'
FIND &B&D&E&G&H 
LIST OFF WORD WHILE KEY='&B&D&E&G&H'
FIND &B&D&F&G&H 
LIST OFF WORD WHILE KEY='&B&D&F&G&H'
FIND &B&E&F&G&H 
LIST OFF WORD WHILE KEY='&B&E&F&G&H'
FIND &C&D&E&F&G 
LIST OFF WORD WHILE KEY='&C&D&E&F&G'
FIND &C&D&E&F&H 
LIST OFF WORD WHILE KEY='&C&D&E&F&H'
FIND &C&D&E&G&H 
LIST OFF WORD WHILE KEY='&C&D&E&G&H'
FIND &C&D&F&G&H 
LIST OFF WORD WHILE KEY='&C&D&F&G&H'
FIND &C&E&F&G&H 
LIST OFF WORD WHILE KEY='&C&E&F&G&H'
FIND &D&E&F&G&H 
LIST OFF WORD WHILE KEY='&D&E&F&G&H'
ENDIF

IF $(STRING,4,1)<>'.'
? ' *** LOOKING FOR 4 LETTER WORDS ***'
FIND &A&B&C&D 
LIST OFF WORD WHILE KEY='&A&B&C&D'
FIND &A&B&C&E 
LIST OFF WORD WHILE KEY='&A&B&C&E'
FIND &A&B&C&F 
LIST OFF WORD WHILE KEY='&A&B&C&F'
FIND &A&B&C&G 
LIST OFF WORD WHILE KEY='&A&B&C&G'
FIND &A&B&C&H 
LIST OFF WORD WHILE KEY='&A&B&C&H'
FIND &A&B&D&E 
LIST OFF WORD WHILE KEY='&A&B&D&E'
FIND &A&B&D&F 
LIST OFF WORD WHILE KEY='&A&B&D&F'
FIND &A&B&D&G 
LIST OFF WORD WHILE KEY='&A&B&D&G'
FIND &A&B&D&H 
LIST OFF WORD WHILE KEY='&A&B&D&H'
FIND &A&B&E&F 
LIST OFF WORD WHILE KEY='&A&B&E&F'
FIND &A&B&E&G 
LIST OFF WORD WHILE KEY='&A&B&E&G'
FIND &A&B&E&H 
LIST OFF WORD WHILE KEY='&A&B&E&H'
FIND &A&B&F&G 
LIST OFF WORD WHILE KEY='&A&B&F&G'
FIND &A&B&F&H 
LIST OFF WORD WHILE KEY='&A&B&F&H'
FIND &A&B&G&H 
LIST OFF WORD WHILE KEY='&A&B&G&H'
FIND &A&C&D&E 
LIST OFF WORD WHILE KEY='&A&C&D&E'
FIND &A&C&D&F 
LIST OFF WORD WHILE KEY='&A&C&D&F'
FIND &A&C&D&G 
LIST OFF WORD WHILE KEY='&A&C&D&G'
FIND &A&C&D&H 
LIST OFF WORD WHILE KEY='&A&C&D&H'
FIND &A&C&E&F 
LIST OFF WORD WHILE KEY='&A&C&E&F'
FIND &A&C&E&G 
LIST OFF WORD WHILE KEY='&A&C&E&G'
FIND &A&C&E&H 
LIST OFF WORD WHILE KEY='&A&C&E&H'
FIND &A&C&F&G 
LIST OFF WORD WHILE KEY='&A&C&F&G'
FIND &A&C&F&H 
LIST OFF WORD WHILE KEY='&A&C&F&H'
FIND &A&D&E&F 
LIST OFF WORD WHILE KEY='&A&D&E&F'
FIND &A&D&E&G 
LIST OFF WORD WHILE KEY='&A&D&E&G'
FIND &A&D&E&H 
LIST OFF WORD WHILE KEY='&A&D&E&H'
FIND &A&D&F&G 
LIST OFF WORD WHILE KEY='&A&D&F&G'
FIND &A&D&F&H 
LIST OFF WORD WHILE KEY='&A&D&F&H'
FIND &A&E&F&G 
LIST OFF WORD WHILE KEY='&A&E&F&G'
FIND &A&E&F&H 
LIST OFF WORD WHILE KEY='&A&E&F&H'
FIND &A&E&G&H 
LIST OFF WORD WHILE KEY='&A&E&G&H'
FIND &A&F&G&H 
LIST OFF WORD WHILE KEY='&A&F&G&H'
FIND &B&C&D&E 
LIST OFF WORD WHILE KEY='&B&C&D&E'
FIND &B&C&D&F 
LIST OFF WORD WHILE KEY='&B&C&D&F'
FIND &B&C&D&G 
LIST OFF WORD WHILE KEY='&B&C&D&G'
FIND &B&C&D&H 
LIST OFF WORD WHILE KEY='&B&C&D&H'
FIND &B&C&E&F 
LIST OFF WORD WHILE KEY='&B&C&E&F'
FIND &B&C&E&G 
LIST OFF WORD WHILE KEY='&B&C&E&G'
FIND &B&C&E&H 
LIST OFF WORD WHILE KEY='&B&C&E&H'
FIND &B&C&F&G 
LIST OFF WORD WHILE KEY='&B&C&F&G'
FIND &B&C&F&H 
LIST OFF WORD WHILE KEY='&B&C&F&H'
FIND &B&C&G&H 
LIST OFF WORD WHILE KEY='&B&C&G&H'
FIND &B&D&E&F 
LIST OFF WORD WHILE KEY='&B&D&E&F'
FIND &B&D&E&G 
LIST OFF WORD WHILE KEY='&B&D&E&G'
FIND &B&D&F&G 
LIST OFF WORD WHILE KEY='&B&D&F&G'
FIND &B&D&F&H 
LIST OFF WORD WHILE KEY='&B&D&F&H'
FIND &B&D&G&H 
LIST OFF WORD WHILE KEY='&B&D&G&H'
FIND &B&E&F&G 
LIST OFF WORD WHILE KEY='&B&E&F&G'
FIND &B&E&F&H 
LIST OFF WORD WHILE KEY='&B&E&F&H'
FIND &B&E&G&H 
LIST OFF WORD WHILE KEY='&B&E&G&H'
FIND &B&F&G&H 
LIST OFF WORD WHILE KEY='&B&F&G&H'
FIND &C&D&E&F 
LIST OFF WORD WHILE KEY='&C&D&E&F'
FIND &C&D&E&G 
LIST OFF WORD WHILE KEY='&C&D&E&G'
FIND &C&D&E&H 
LIST OFF WORD WHILE KEY='&C&D&E&H'
FIND &C&D&F&G 
LIST OFF WORD WHILE KEY='&C&D&F&G'
FIND &C&D&F&H 
LIST OFF WORD WHILE KEY='&C&D&F&H'
FIND &C&D&G&H 
LIST OFF WORD WHILE KEY='&C&D&G&H'
FIND &C&E&F&G 
LIST OFF WORD WHILE KEY='&C&E&F&G'
FIND &C&E&F&H 
LIST OFF WORD WHILE KEY='&C&E&F&H'
FIND &C&E&G&H 
LIST OFF WORD WHILE KEY='&C&E&G&H'
FIND &C&F&G&H 
LIST OFF WORD WHILE KEY='&C&F&G&H'
FIND &D&E&F&G 
LIST OFF WORD WHILE KEY='&D&E&F&G'
FIND &D&E&F&H 
LIST OFF WORD WHILE KEY='&D&E&F&H'
FIND &D&E&G&H 
LIST OFF WORD WHILE KEY='&D&E&G&H'
FIND &D&F&G&H 
LIST OFF WORD WHILE KEY='&D&F&G&H'
FIND &E&D&F&G 
LIST OFF WORD WHILE KEY='&E&D&F&G'
FIND &E&D&F&H 
LIST OFF WORD WHILE KEY='&E&D&F&H'
FIND &E&D&G&H 
LIST OFF WORD WHILE KEY='&E&D&G&H'
FIND &E&F&G&H 
LIST OFF WORD WHILE KEY='&E&F&G&H'
ENDIF

CLEAR
INPUT "CONTINUE (Y/N)?" TO CONTINUE

IF CONTINUE
CLEAR
DO ANAGRAM3
ELSE
RELEASE ALL
CLEAR
ERASE
*SET PRINT OFF
SET TALK ON
SET EXACT OFF
ENDIF
