/*
 * John Buck -- V7 -- 3/82 
 *	Have any core files around but no binary?  This program makes
 * 	you a new binary from a core (as long as it was not compiled -i, -n)
 *	Note output is stripped of symbol table (since it is unavailable in
 *	core files)
 */
#include "param.h"
#include "user.h"
unsigned	ds, blks;

char	buf[512];
main(c,v)
char **v;
{

	struct user u;
	register int fdi, fdo, r;

	if(c != 3){
		printf("Usage: %s corefile outfile\n", v[0]);
		exit(1);
	}

	if((fdi = open(*++v, 0)) == -1){
		printf("Can not open %s\n", *v);
		exit(2);
	}

	if((fdo = creat(*++v, 0700)) == -1){
		printf("Can not open output %s\n", *v);
		exit(3);
	}

	if((r = read(fdi, &u, sizeof(u))) != sizeof(u)){
		printf("User struct read error\n");
		exit(4);
	}

	seek(fdi, 01400, 0);
	u.u_exdata.ux_ssize = 0;
	write(fdo, &u.u_exdata, 16);
	if(u.u_exdata.ux_tsize){
		printf("No text segment in %s\n", *--v);
		exit(5);
	}

	ds = u.u_exdata.ux_dsize;
	blks = (ds >> 9) & 0177;
	ds =% 512;
	while(blks--){
		if((r = read(fdi, buf, 512)) != 512){
bad:
			printf("EOF on input file\n");
			exit(6);
		}
		write(fdo, buf, 512);
	}
	if(read(fdi, buf, ds) != ds)goto bad;
	write(fdo, buf, ds);
	close(fdi);
	close(fdo);
}
