/*
 * ttystab - table used for terminal characterics in getty and init
 */

#include	"sys/termio.h"

#define	TCHARS	{ CINTR, CQUIT, CERASE, CKILL, CEOF, CNUL, CNUL, CNUL }
#define	RTCHARS	{ CINTR, CQUIT, CERASE, CKILL, 01, CNUL, CNUL, CNUL }


struct	ttab {
	int	tname;		/* this table name */
	int	nname;		/* successor table name */
	struct	termio imode;	/* Initial mode */
	struct	termio fmode;	/* final mode */
	char	*message;	/* login message */
} gtab[] = {

/* table '0' 600 */

	'0', '0',
	{ 0,
	  0,
	  B600|CS8|CREAD|CLOCAL,
	  0,
	  0,
	  RTCHARS
	},
	{ BRKINT|ISTRIP|IGNPAR|IXON|ICRNL,
	  OPOST|ONLCR|TAB3,
	  B600|CS7|CREAD|PARENB|CLOCAL,
	  ISIG|ICANON|ECHO|ECHOE|ECHOK,
	  0,
	  TCHARS
	},
	"\n\n\r\007\login: ",

/* table '-' -- Console TTY 1200 */
	'-', '-',
	{ 0,
	  OPOST|ONLCR,
	  B1200|CS8|CREAD|CLOCAL,
	  0,
	  0,
	  RTCHARS
	},
	{ BRKINT|ISTRIP|IGNPAR|IXON|ICRNL,
	  OPOST|ONLCR,
	  B1200|CS7|CREAD|PARENB|CLOCAL,
	  ISIG|ICANON|ECHO|ECHOK,
	  0,
	  TCHARS
	},
	"\n\n\rlogin: ",

/* table 'D' -- Westchester Decwriter III */
	'D' , 'D',
	{ 0,
	  OPOST|ONLCR,
	  B1200|CS8|CREAD|CLOCAL,
	  0,
	  0,
	  RTCHARS
	},
	{ BRKINT|ISTRIP|IGNPAR|IXON|ICRNL,
	  OPOST|ONLCR,
	  B1200|CS7|CREAD|PARENB|CLOCAL,
	  ISIG|ICANON|ECHO|ECHOK,
	  0,
	  TCHARS
	},
	"\n\n\rlogin: ",

/* table 'd' 2-3 --  dial ups */
	'd', 2,
	{ 0,
	  0,
	  B300|CS8|CREAD,
	  0,
	  0,
	  RTCHARS
	},
	{ BRKINT|ISTRIP|IGNPAR|IXON|ICRNL,
	  OPOST|ONLCR|TAB3,
	  B300|CS7|CREAD|PARENB,
	  ISIG|ICANON|ECHO|ECHOE|ECHOK,
	  0,
	  TCHARS
	},
	"\n\rlogin: ",

	2, 3,
	{ 0,
	  0,
	  B150|CS8|CREAD,
	  0,
	  0,
	  RTCHARS
	},
	{ BRKINT|ISTRIP|IGNPAR|IXON|ICRNL,
	  OPOST|ONLCR|TAB3,
	  B150|CS7|CREAD|PARENB,
	  ISIG|ICANON|ECHO|ECHOE|ECHOK,
	  0,
	  TCHARS
	},
	"\n\rlogin: ",

	3, 'd',
	{ 0,
	  0,
	  B110|CS8|CREAD|CSTOPB,
	  0,
	  0,
	  RTCHARS
	},
	{ BRKINT|ISTRIP|IGNPAR|IXON|ICRNL,
	  OPOST|ONLCR|TAB3,
	  B110|CS7|CREAD|PARENB|CSTOPB,
	  ISIG|ICANON|ECHO|ECHOE|ECHOK,
	  0,
	  TCHARS
	},
	"\n\rlogin: ",

/* table '1' -- 1200 */
	'1', '1',
	{ 0,
	  0,
	  B1200|CS8|CREAD|CLOCAL,
	  0,
	  0,
	  RTCHARS
	},
	{ BRKINT|ISTRIP|IGNPAR|IXON|ICRNL,
	  OPOST|ONLCR|TAB3,
	  B1200|CS7|CREAD|PARENB|CLOCAL,
	  ISIG|ICANON|ECHO|ECHOE|ECHOK,
	  0,
	  TCHARS
	},
	"\n\n\r\007login: ",

/* table '2'-4-5 -- 600, 1200, 2400   Aero dept */
	'2', 4,
	{ 0,
	  0,
	  B600|CS8|CREAD|CLOCAL,
	  0,
	  0,
	  RTCHARS
	},
	{ BRKINT|ISTRIP|IGNPAR|IXON|ICRNL,
	  OPOST|ONLCR|TAB3,
	  B600|CS7|CREAD|PARENB|CLOCAL,
	  ISIG|ICANON|ECHO|ECHOK,
	  0,
	  TCHARS
	},
	"\n\n\r\login: ",

	4, 5,
	{ 0,
	  0,
	  B1200|CS8|CREAD|CLOCAL,
	  0,
	  0,
	  RTCHARS
	},
	{ BRKINT|ISTRIP|IGNPAR|IXON|ICRNL,
	  OPOST|ONLCR|TAB3|NL1,
	  B1200|CS7|CREAD|PARENB|CLOCAL,
	  ISIG|ICANON|ECHO|ECHOK,
	  0,
	  TCHARS
	},
	"\n\rlogin: ",

	5, '2',
	{ 0,
	  0,
	  B2400|CS8|CREAD|CLOCAL,
	  0,
	  0,
	  RTCHARS
	},
	{ BRKINT|ISTRIP|IGNPAR|IXON|ICRNL,
	  OPOST|ONLCR|TAB3|NL1|CR1,
	  B2400|CS7|CREAD|PARENB|CLOCAL,
	  ISIG|ICANON|ECHO|ECHOK,
	  0,
	  TCHARS
	},
	"\n\rlogin: ",

/* table 'R' -- 300, 1200, 4800    Micro Lab */
	'R',6,
	{ 0,
	  0,
	  B300|CS8|CREAD|CLOCAL,
	  0,
	  0,
	  RTCHARS
	},
	{ BRKINT|ISTRIP|IGNPAR|IXON|ICRNL,
	  OPOST|ONLCR|TAB3,
	  B300|CS7|CREAD|PARENB|CLOCAL,
	  ISIG|ICANON|ECHO|ECHOE|ECHOK,
	  0,
	  TCHARS
	},
	"\n\rlogin: ",

	6, 7,
	{ 0,
	  0,
	  B1200|CS8|CREAD|CLOCAL,
	  0,
	  0,
	  RTCHARS
	},
	{ BRKINT|ISTRIP|IGNPAR|IXON|ICRNL,
	  OPOST|ONLCR|TAB3,
	  B1200|CS7|CREAD|PARENB|CLOCAL,
	  ISIG|ICANON|ECHO|ECHOE|ECHOK,
	  0,
	  TCHARS
	},
	"\n\rlogin: ",

	7, 'R',
	{ 0,
	  0,
	  B4800|CS8|CREAD|CLOCAL,
	  0,
	  0,
	  RTCHARS
	},
	{ BRKINT|ISTRIP|IGNPAR|IXON|ICRNL,
	  OPOST|ONLCR|TAB3,
	  B4800|CS7|CREAD|PARENB|CLOCAL,
	  ISIG|ICANON|ECHO|ECHOE|ECHOK,
	  0,
	  TCHARS
	},
	"\n\rlogin: ",

/* table '3' -- 4800 */
	'3', '3',
	{ 0,
	  0,
	  B4800|CS8|CREAD|CLOCAL,
	  0,
	  0,
	  RTCHARS
	},
	{ BRKINT|ISTRIP|IGNPAR|IXON|ICRNL,
	  OPOST|ONLCR|TAB3,
	  B4800|CS7|CREAD|PARENB|CLOCAL,
	  ISIG|ICANON|ECHO|ECHOE|ECHOK,
	  0,
	  TCHARS
	},
	"\n\n\rlogin: ",

/* table 'm' -- 300  ***  decwriter II */
	'm', 'm',
	{ 0,
	  0,
	  B300|CS8|CREAD|CLOCAL,
	  0,
	  0,
	  RTCHARS
	},
	{ BRKINT|ISTRIP|IGNPAR|IXON|ICRNL,
	  OPOST|ONLCR|TAB3|NL1,
	  B300|CS7|CREAD|PARENB|CLOCAL,
	  ISIG|ICANON|ECHO|ECHOK,
	  0,
	  TCHARS
	},
	"\n\rlogin: ",
};

#define	NGTAB	sizeof gtab/sizeof gtab[0]
