
/*
 * tron2:	General purpose load routine to get inodes
 */
#include	"tron.h"

makenm(dirn, ext)
char *dirn, *ext;
{
	static char fbuf[64];
	register char *t;

	t = fbuf;
	strcpy(t, TRONDIR);
	strcat(t, dirn);
	strcat(t, ext);
	return(fbuf);
}

getstats(f)
char *f;
{
	struct	stat statb;
	long	chksum;
	uint	r, fd;
	register uint *s, *l;

	if(stat(f, &statb) == -1){
		fprintf(stdout, "*TRON: No %s found.\n", f);
		return(0);
	}

	if(statb.st_time[0] != statb.st_size){
		fprintf(stdout, "*TRON: Data base %s tampered with -- access\n",
			f);
		savfil(f);
		return(0);
	}
	chksum = 0;
	if((fd = open(f, 0)) == -1){
		fprintf(stdout, "*TRON: No open after stat %s\n", f);
		savfil(f);
		return(0);
	}
	r = read(fd, stbuf, NENT*(sizeof (struct sstat)));
	close(fd);
	if(r % (sizeof (struct sstat))){
		fprintf(stdout, "*TRON: Record size error in %s\n", f);
		savfil(f);
		return(0);
	}
	nent = r / (sizeof (struct sstat));
	s = stbuf;
	for(l = (char *)s + r; s < l; chksum += *s++);
	if(chksum != statb.st_time[1]){
		fprintf(stdout, "**TRON: Checksum error in %s\n", f);
		nent = 0;
		savfil(f);
		return(0);
	}
	return(1);
}

getexc(f)
char *f;
{
	register short i,j;
	struct stat statb;
	long	chksum;
	register FILE *fp;

	if(stat(f, &statb) == -1)
		return(0);
	if(statb.st_time[1] != statb.st_size){
			fprintf(stdout, "*TRON: Access error on except %s\n",f);
			return(0);
	}
	if((fp = fopen(f, "r")) == NULL){
		fprintf(stdout, "*TRON: Can't open %s after stat\n", f);
		return(0);
	}
	i = 0;
	while(fgets(exc[i], DIRSIZ, fp) && i < NEX){
		if(exc[i][j = strlen(exc[i])-1] == '\n')
			exc[i][j] = 0;
		i++;
	}
	fclose(fp);
	return(i);
}

