

/*
 *	Polytechnic UNIX accounting Package - Program: 360mon.c
 *
 *	Author:	John Buck
 *	Polytechnic Institute NY, September 1981
 *
 *	Program Description:
 *		Will read a compressed accounting file in the oldfiles
 *		directory, and print out the total money for the given
 *		day or month file.
 *
 */





#include	"actrecs.h"

struct	aac	{
	char uuuid;
	char gggid;
	struct	acctrec ac;
};



char tab[MAXACGIDS][MAXACUIDS];
struct ibment ibm;

main(c,v)
char **v;
{

	char buf[512];
	register int r , u;
	register struct aac *pa;
	float dol, grand;
	int fd , g;
	grand = 0.0;


	u = getgid() & 0377;
	if(u != 2 && u != 5 && u){
		printf("Access denied.\n");
		exit(1);
	}
	getone();
	while(--c){
		v++;

		printf("%s: ",*v);
		dol = 0.0;
		if((fd = open(*v,0)) == -1){
			printf("No %s\n",v[1]);
			exit(1);
		}

		while(r = read(fd,buf,510))
			for(pa = buf; pa < &buf[r]; pa++){
				u = pa->gggid;
				g = u & 0377;
				u = pa->uuuid;
				u =& 0377;
				if(tab[g][u] == 0)continue;
				dol =+ (float)(pa->ac.a_diskblks)/2000.0;
				dol =+ (float)(pa->ac.a_connect)/3600.0;
				dol =+ (float)(pa->ac.a_syscpu)/10800.0;
				dol =+ (float)(pa->ac.a_busrcpu)/108000.0;
			}

		close(fd);
		printf("Total: $%9.2f\n",dol);
		grand =+ dol;
	}
	printf("\nGrand total: $%9.2f\n",grand);

}


getone(){
	int fd;
	register i , j , k;

	if((fd = open(IBMFILE,0)) == -1)return(-1);

	for(i = 0; i < MAXACGIDS; i++)
		for(j = 0; j < MAXACUIDS; j++)
			tab[i][j] = 0;

	while(read(fd,&ibm,IREAD) == IREAD){
		if(ibm.send == 'X')continue;
		i = num(ibm.uid);
		j = num(ibm.gid);
		if(i == -1){
			if(j == -1)continue;
			for(k = 0; k < MAXACUIDS; k++)
				tab[j][k] = 1;
		}	else	if(j == -1)
					for(k = 0; k < MAXACGIDS; k++)
							tab[k][i] = 1;
				else	tab[j][i] = 1;
	}
	close(fd);
	return(0);
}



num(s)
register char *s;
{
	register i;


	i = 0;
	if(*s < '0' || *s > '9')return(-1);
	while(*s >= '0' && *s <= '9')i=i*10 + *s++ - '0';
	return(i);
}
