/*
 *	vload
 *	Variable Information Retrieval
 *	State Hygiene Laboratory pseudo database system
 *	Load formats into concept 108 terminal
 *	by David E. Miran
 *	3/11/83
 */

#include	<stdio.h>
#include	"vmyio.h"
#include	"vir.h"
#include	"virfiles.h"

int hfid, fmtfid;
extern char mget();

struct	dexhead	hrec;		/* HFILE (header file) */
struct	fil_ent	filent[MAXFILE]; /* data file information - HFILE-3 */
struct	fmt_def fmtdef[MAXFMT];
struct	fmt_inf	fmtinf[MAXFMT];	/* format information (internal) */
struct	fdef	fld[MAXFLD];

int	ltype		0;	/* cur_type - 1 */
char	*progname;

/***********  vload windowing for concept terminals *************/
char	*wind[]	{	/* pointers to window selection commands */
		"\033v  8p\033V ",
		"\033v8 8p\033V8",
		"\033vP 8p\033VP",
		"\033vh 8p\033Vh",
		"\033v\001  8p\033V\001 ",
		"\033v\0018 8p\033V\0018",
		"\033v\001P 8p\033V\001P",
		"\033v\001h 8p\033V\001h",
		0 };
int	windlen[]	{ 9,9,9,9,11,11,11,11};

char	*prog	"\033U\033\010A@ \033 r\033S";
		/* programmer mode, define clear characteristics, replace char and attribute,page */
int	progl	12;

char	*init			/* init setup of a format */
		"\033i\014\033I";
			/* protect off, clr,protect */
int	init_l	5;

char	*strt			/* start of data field */
		" \033D \033i";
char	*cstrt	"\033i";	/* clear screen start of line */
char	*cendf	"\033I";	/* clear screen end of line */
int	strt_l	6;

char	*endf			/* end of data field */
		"\033I \033d ";
int	endf_l	6;

char	*fin			/* end of format loading */
		"\033s\033i\033d\033 R\033u\033?\033\003";
		/* scroll, prot off, rev video off, replace char only, user mode, home, clear unprot */
int	fin_l	15;

char	*cls		/* clear ALL - prot and unprot */
		"\014";
int	cls_l	1;

int	scrwid		80;	/* screen width */

struct fbuf ffin, fout;

main(argc, argv)
int argc;
char **argv;
{
	register int i, j;
	register char c;

	progname = *argv;
	vopen();
	write(1,prog,progl);
	write(1,wind[0],windlen[0]);
	write(1,cls,cls_l);
	mfinit(&fout, 1);
	for(i=0; i<hrec.numfmt; i++) {
		j = i+1;
		write(1,wind[j],windlen[j]);
		setform(j);
	}
	write(1,wind[7],windlen[7]);
	setclr();
	write(1,wind[0],windlen[0]);
	write(1,fin, fin_l);
	exit(0);
}

/*******************************  vopen  *************************************/

vopen()
{
register int i;
	vfopn(&hfid,hfile, 0);
	vfopn(&fmtfid,fmtfile, 0);

	read(hfid, &hrec, sizeof hrec);
	read(hfid, &fmtdef[0], MAXFMT * sizeof (struct fmt_def));
	read(hfid, &filent[0], hrec.numfile * sizeof (struct fil_ent));
	read(fmtfid, &fmtinf[0], hrec.numfmt * sizeof (struct fmt_inf));
	read(fmtfid, &fld[0], hrec.nfmtfld*sizeof (struct fdef));
	close(hfid);
	close(fmtfid);
}

/********************************  vfopn  ***********************************/
vfopn(fid, fn, md)
int *fid, md;
char *fn;
{
	if ((*fid = open(fn,md)) < 0)  {
		fprintf(stderr,"%s: cannot open file %s\n",progname,fn);
		exit(1);
	}
}
/*******************************  setform  **********************************/
/* load a format onto the screen */

setform(type)
int type;
{
int fid;
	ltype = type-1;
	fid = open(fmtdef[ltype].fmt_name, 0);
	mfinit(&ffin, fid);
	ldform(fid, fmtinf[ltype].st_fld);
	close(fid);
}

/* ldform */

ldform(fid, fldloc)
int fid, fldloc;
{
register char ch, nch;
register int i;
int lnum, fnum, curpos, lpos;
int flpos;

	flpos = fldloc;
	lpos = lnum = curpos = 0;
	fnum = -1;
	mputrec(init, init_l, &fout);
	mflush(&fout);
	ch=mget(&ffin);   nch = mget(&ffin);

put_lp:
	if ((ch == ' ') && (nch == '[')) {	/* start of data field */
		mputrec(strt, strt_l, &fout);
		lpos =+ 4;
		for (i=0; i<fld[flpos].f_size; i++) {
			mput(' ',&fout);
			lpos++;
		}
		mputrec(endf, endf_l, &fout);
		flpos++;
		while ((ch = mget(&ffin)) != ']');
		ch = mget(&ffin);
		if (ch == '\n') goto getnc;
		ch = mget(&ffin);
getnc:
		nch = mget(&ffin);
		goto put_lp;
	}
	if (ch == '\n') {
		lnum++;
		if (lnum == PAGELEN) goto endform;
		while (lpos<scrwid) {
			mput(' ', &fout);
			lpos++;
		}
		lpos = 0;
		ch = nch;
		nch = mget(&ffin);
		if ((ch == '\0') || (nch == '\0')) goto endform;
		if (lnum >= PAGELEN) goto endform;
		goto put_lp;
	}
	mput(ch, &fout);
	lpos++;
	ch=nch;
	nch=mget(&ffin);
	if (ch != '\0') goto put_lp;

endform:
	while (lpos < scrwid) {
		mput(' ',&fout);
		lpos++;
	}
	mflush(&fout);
}
setclr()
{
register int i, j;
	mputrec(init, init_l, &fout);
	mflush(&fout);
	for (i=0; i<24; i++) {
		mputrec(cstrt, 2, &fout);
		for (j=0; j<79;j++) mput(' ',&fout);
		mputrec(cendf, 2, &fout);
		mput(' ',&fout);
	}
	mflush(&fout);
}
