/*  vir.h
 * defines, structures, etc for the virology system vir
 * by David E. Miran,  Wisconsin State Lab of Hygiene
 * 3/4/82
 */

/* field encodings for formats */
#define		LCASE	01	/* preserve lower case for this field */
#define		NUMERIC	02	/* field must be numeric */
#define		ALPHA	04	/* field must be alphabetic */
#define		REQUIRED 010	/* field must be filled in */
#define		DATE	020	/* field contains a date */
#define		LABNUM	040	/* field contains a lab number */
#define		PNAME	0100	/* field contains a patient name */
#define		DNAME	0200	/* field contains a doctor's name */
#define		CITY	0400	/* field contains a city name */
#define		RANGE	01000	/* range checking required for this field */
#define		AUTO	02000	/* automatic field fill in on record creation */
#define		SOURCE	04000	/* source field for automatic field fill */
#define		SPECIMEN 010000 /* field has a specimen number */
#define		PNUM	020000	/* field is the patient number field */
#define		PNUMYR	040000  /* field has year portion of composite patient number */

/* field letter codes for setting up a format are as follows
	L	LCASE
	9	NUMERIC
	R	REQUIRED
	A	ALPHA
	D	DATE
	N	LABNUM
	P	PATIENT NAME (PNAME)
	H	DOCTOR'S NAME (DNAME)
	C	CITY
	X	RANGE CHECKING
	s#	SOURCE number
	a#	AUTO fillin number
	S	Specimen number field - SPECIMEN
	p	patient number field - PNUM
	c	year portion of composite patient number
 */

/*  *********  arbitrary sizes and constants  *********  */

#define	MAXFLD	700		/* max number of fields in all formats */
#define	MAXFMT	10		/* maximum number of formats */
#define	MAXRSIZE 1824		/* max input record size (24*76) */
#define	BUFSIZE	512		/* ordinary buffer size */
#define	VBSIZE	1024		/* conceptual block size of indexes */
#define	PAGELEN	24		/* lines per page (crt screen) */
#define	HIPRI	-100		/* very high priority */
#define	LOPRI	0
#define	RMODE	0340		/* raw mode, anyp */
#define	IMODE	0100340		/* block, raw, anyp */
#define	NMODE	0320		/* normal mode, anyp, no scroll */
#define	PMODE	0330		/* normal, echo, -nl, no scroll */
#define	ETX	03		/* end of transmission */
#define	IBSIZE	50		/* terminal input blocking factor */
#define	B4800	12		/* stty encoded terminal speed */

#define	CURREN	01
#define	NOTCUR	02
#define	HOLES	04
#define	MAXFILE	350	/* maximum number of file table entries */
#define	MAXSPEC 30	/* maximum number of specimens in working set */
#define	MAXREC	30	/* max number of records in working set */
#define	PNSIZE	14	/* patient name size */
#define	NCPAT	20	/* number of c2dex patient name entries */
#define	NCREC	10	/* number of c2dex record entries */
#define	NCSPEC	15	/* number of c2dex specimen entries */

/* pfile - patient name vs number */
struct pat_ent {
	char	p_name[PNSIZE];
	long	p_num;
	};

/* nfile - patient number vs record (file and offset) */
struct	num_ent {
	long	np_num;		/* patient number */
	long	f_loc;		/* offset into file */
	unsigned nf_num;	/* file number */
	};

/* sfile - specimen number vs patient number and file number */
struct	sp_ent {
	long	sp_num;		/* specimen number */
	long	xp_num;		/* patient number */
	long	sf_loc;		/* offset into file */
	unsigned sf_num;	/* file number */
	};
#define	BSZP	1080	/* 60 * 18 chars per pat_ent */
#define	BSZN	1000	/* 100 * 10 chars per num_ent */
#define	BSZS	980	/* 70 * 14 chars per sp_ent */

/* hfile - system header file - HFILE part 1 */
struct	dexhead {
	long	lastup;	/* time indexes last rebuilt */
	long	lastmod; /* time any files last modified */
	unsigned maxfile; /* highest file number assigned */
	int	numfile;	/* actual number of files in the table */
	int	numfmt;		/* number of defined formats */
	long	pmaxseq;	/* patient name file end of sorted entries */
	long	nmaxseq;	/* patient number file end of sorted entries */
	long	smaxseq;	/* specimen file end of sorted entries */
	long	fmtime;		/* last time formats re-analyzed */
	long	maxpnum;	/* highest patient number used */
	long	pnumbas;	/* highest pnum in highest year */
	long	pnumyr;		/* highest year in composite patient number */
	int	nfmtfld;	/* number of fields used in formats */
	int	autopn;		/* 1 for auto patient number generation */
	int	modata;		/* 1 if modified data form */
	int	compnum;	/* 1 if composite patient numbers turned on */
	char	recsep;		/* record separator char (always \n if modata set) */
	char	fldsep;		/* field separator character */
	int	intnum;		/* set if internal only patient numbers */
	int	nonspec;	/* set if no specimen number fields on any formats */
	char	hfill[16];	/* room to grow without rebuilding index */
	};

/* format definition entries - HFILE part 2 */
struct	fmt_def {
	int	fmt_num;
	char	fmt_name[20];
	unsigned fil_num;
	char	fmt_app[24];  /* current file to append data to */
	};

/* file definition table - HFILE part 3 */
struct	fil_ent {
	unsigned f_num;		/* file number */
	int	fmt_cd;	/* number of format associated with this file */
	int	f_mode;		/* file mode */
	char	f_name[24];	/* file name */
	};

/* format internal information - FMTFILE part 1 */
struct	fmt_inf {
	int	st_fld;
	int	end_fld;	/* first and last field number in field array */
	int	num_fld;	/* number of fields */
	int	num_chr;	/* number of chars in all fields */
	int	fld_pn;		/* number of field with patient number */
	int	fld_pny;	/* number of field with year of composite patient number */
	int	fld_nam;	/* number of field with patient name */
				/* both relative to first field of a format is field 0 */
	int	fmt_mod;	/* format mode bits */
	};

/* format field descriptors - FMTFILE part 2 */
struct fdef	{	/* format data field descriptor */
		char	f_size;		/* field size */
		char	f_anum;		/* auto copy number */
		int	f_flags;	/* field modifier flags */
		int	f_pos;		/* starting char pos of this field */
		};

/* The following items represent features that have been disabled to
 * save space. Each one can be turned on with a define statement
 * for the appropriate item.
 * the items are:
 * DUMBKEY - support for function keys which generate 2 char codes
 *	as on ET2/D, B150, etc.
 * BLKTERM - Support for terminals with separate forms and block mode.
 *	There are none of these at the State Lab
 * B150 - support for the Beehive B150 terminal.
 * 	There is only one of these at the State Lab.
 */
