/*
 *	vcreate [-a] [-c] [-m] [-rx] [-ix] fmt file [fmt file] ...
 *	State Hygiene Laboratory Virology database system
 *	Data entry and Enquiry program files initial setup
 *	by David E. Miran
 *	3/4/82

 *	options
 *	-a   automatic generation of patient numbers
 *	-c   composite patient numbers
 *	-m   modified data format
 *	-rx  record separator is x (not allowed with -m option)
 *	-ix  item (field) separator is x
 *	     must follow -m option if both are used.
 *      fmt file
		format and initial associated file
		repeat for as many formats as necessary

 */
#include	<myio.h>
#include	<stdio.h>
#include	"vir.h"
#include	"virfiles.h"
#define	NUMFILE	10
char	*fnames[NUMFILE]	{
 "PFILE", "P1", "P2", "NFILE", "N1", "N2", "SFILE", "S1", "S2", "FMTFILE" };

struct	dexhead	hrec;
struct	fmt_def	fmtdef[MAXFMT];
struct	fil_ent	filent[MAXFILE];

main(argc, argv)
int argc;
char **argv;
{
register int i, j;
register char c;
int h;
	hrec.numfile = hrec.maxfile = hrec.numfmt = 0;
	hrec.fldsep = '\'';
	hrec.recsep = '!';
	hrec.compnum = 0;
	hrec.pnumbas = hrec.pnumyr = 0L;
	hrec.intnum = hrec.nonspec = 0;
	hrec.autopn = hrec.modata = 0;
	for (i=0; i<NUMFILE; i++)
		close(creat(fnames[i], 0664));
	h = creat(hfile, 0664);
	time(&hrec.lastup);
	hrec.lastmod = hrec.lastup;
	hrec.pmaxseq = hrec.nmaxseq = hrec.smaxseq = 0;
	hrec.maxpnum = 0;
	hrec.fmtime = 0;
	hrec.nfmtfld = 0;
	argc--;
	i = 0;
	while (argc--) {
		argv++;
		if (**argv != '-') goto fmts;
		if (strcmp(*argv,"-a") == 0) {
			hrec.autopn = 1;
			continue;
		}
		if (strcmp(*argv,"-c") == 0) {
			hrec.compnum = 1;
			continue;
		}
		if (strcmp(*argv, "-m") == 0) {
			if (hrec.recsep != '!') {
rm_err:
				printf("vcreate:  error - cannot use both -r and -m options\n");
				exit(1);
			}
			hrec.modata = 1;
			hrec.fldsep = ':';
			hrec.recsep = '\n';
			continue;
		}
		if (strncmp(*argv, "-r", 2) == 0) {
			if (hrec.modata) goto rm_err;
			hrec.recsep = (*argv)[2];
			continue;
		}
		if (strncmp(*argv, "-int", 4) == 0) {
			hrec.intnum = 1;
			continue;
		}
		if (strncmp(*argv, "-i", 2) == 0) {
			hrec.fldsep = (*argv)[2];
			continue;
		}
		printf("vcreate:  illegal option %s\n",*argv);
		exit(1);
fmts:
/* read format/file pairs and process */
		strcpy(fmtdef[i].fmt_name, *argv);
		argc--;  argv++;
		strcpy(filent[i].f_name,*argv);
		if (!saccess(*argv,2)) {
			printf("vcreate:  access to file %s forbidden\n",*argv);
			exit(1);
		}
		strcpy(fmtdef[i].fmt_app,*argv);
		fmtdef[i].fmt_num = i;
		fmtdef[i].fil_num = i+1;
		filent[i].f_mode = NOTCUR;
		filent[i].f_num = i+1;
		filent[i].fmt_cd = i;
		i++;
	}
	hrec.maxfile = hrec.numfile = hrec.numfmt = i;
	write(h,&hrec,sizeof (struct dexhead));
	write(h, &fmtdef[0],MAXFMT * sizeof(struct fmt_def));
	write(h, &filent[0], hrec.numfmt * sizeof (struct fil_ent));
	close(h);
	printf("vcreate done - files initialized\n");
}
