#
/* rqlist [-]
 * print a list of those who have used rq * or only the most recent user if any argument is given
 *
 * by David E. Miran
 * 12/6/82
 */

#include	<stdio.h>
#include	<myio.h>

char	*rqfile	"/etc/rqrec";	/* trace file */
int	rfid;
struct	{
	long	rtime;
	int	ruid;
	}  rqrec;

/* next 4 items are part of setpw */
#define	MAXU	256
#define	USIZE	8
char	uname[MAXU][USIZE];
char	*pwfile	"/etc/passwd";

main(argc,argv)
int argc;
{
register int i;
char *tptr;
int nrd;
	if ((rfid = open(rqfile,0)) <0) {
		printf("no %s\n",rqfile);
		exit(1);
	}
	if (argc>1)
		seek(rfid, -(sizeof rqrec), 2);
	setpw();
	while ((nrd = read(rfid, &rqrec, sizeof rqrec))>0) {
		tptr=ctime(&rqrec.rtime);
		printf("%-24.24s  %-8.8s\n",tptr,uname[rqrec.ruid&0377]);
	}
}
/* setpw - loads all user names from /etc/passwd into uname array */
/* position in uname corresponds to user id */
/* by David E. Miran - 12/6/82 */


setpw()
{
register int i, j;
register char c;
int fid;
char rec[150];
struct fbuf pb;
	fid = open(pwfile,0);
	mfinit(&pb,fid);
	while(mgetlin(rec,&pb)) {
		i=0;
		while(rec[i++] != ':');
		while(rec[i++] != ':');
		j = 0;
lp:
		c = rec[i++];
		if (c == ':') goto gn;
		j = j * 10 + ((c-'0') & 0177);
		goto lp;
gn:
		i=0;
		while ((c = rec[i]) != ':') {
			uname[j][i] = c;
			if (i >= 7) break;
			i++;
		}
		if ( i < 7) uname[j][i] = '\0';
	}
	close(fid);
}
