/* rq
 * request ownership of the line printer or a terminal
 * (i.e. take it away from the spooler
 * and make a record of it if trace file exists (for lp only)
 *
 * by David E. Miran
 * 12/15/82
 */

#include	<stdio.h>
#define	NDEV	3
char	*lpr[]	{
		"/dev/lp",
		"/dev/rlp",
		"/dev/plt"
		};
int	uid;
int	gid;
int	setid;
#define	daemon	1	/* daemon user id */
struct	{
	char	fill1[4];
	int	fmodes;
	char	nlink;
	char	fuid;		/* files owner */
	char	fill2[28];
	}	fbuf;
#define	ROOT	0
char	term	'%';
char	*tdev	"/dev/tty?";
char	*lockf	"/sptmp/ctrl/?lock";
char	*rqfile	"/etc/rqrec";	/* trace file */
int	rfid;
struct	{
	long	rtime;
	int	ruid;
	}  rqrec;

main(argc,argv)
int argc;
char **argv;
{
int i;
	uid = getuid()&0377;
	gid = getgid()&0377;
	setid = uid | (gid<<8);
	if (argc > 1) goto doterm;	/* terminal spec */
	if (stat(lpr[0], &fbuf) < 0) {
		printf("Sorry: lp not available\n");
		exit(1);
	}
	if (fbuf.fuid == uid&0377) exit(0);   /* user already owns it */
	if (fbuf.fuid == daemon) {	/* take it away from spooler */
		for (i=0; i<NDEV; i++) {
			chown(lpr[i], setid);
			chmod(lpr[i], 0660);
		}
		if ((rfid = open(rqfile,1)) >= 0) {
			seek(rfid,0,2);
			time(&rqrec.rtime);
			rqrec.ruid = uid&0377;
			write(rfid, &rqrec, sizeof rqrec);
			close(rfid);
		}
		printf("ok\n");
		exit(0);
	}
	printf("Sorry: lp is in use by someone else\n");
	exit(1);
doterm:
	term = argv[1][0];
	tdev[8] = term;
	lockf[12] = term;
	i = stat(lockf,&fbuf);
	if (i < 0) {	/* make the lock */
		close(creat(lockf,0));
		i = 0;
		chown(lockf,setid);
		goto lockmade;
	}
	/* lock already exists - inspect it */
	i = 0;
	if (fbuf.fmodes&0377 == 0) { /* already locked */
		if (fbuf.fuid == uid&0377)	goto lockmade;  /* already own it */
sorry:
		printf("rq: Sorry - %s is in use by someone else\n",tdev);
		exit(1);
	}
	/* in use by spooler */
	i = 1;
	chmod(lockf,0);
	chown(lockf,setid);
lockmade:
	stat(tdev,&fbuf);
	if (fbuf.fuid == uid&0377) goto ok;
	if (fbuf.fuid == ROOT) goto ok;
	printf("Rq:  WARNING - Someone is signed in on %s\n",tdev);
ok:
	if (i) printf("Rq:  Warning - spooler is running on %s.  Wait for printing to finish\n",tdev);
	printf("ok\n");
}
