/* rl [?]
 * relinquish ownership of the line printer or terminal ?
 * (i.e. give it back to the spooler
 *
 * by David E. Miran
 * 12/15/82
 */

#include	<stdio.h>
#define	NDEV	3
char	*lpr[]	{
		"/dev/lp",
		"/dev/rlp",
		"/dev/plt"
		};
char	tpd[]	"/etc/tpd";
int	uid;
#define	daemon	1	/* daemon user id */
#define	ROOT	0
struct	{
	char	fill1[4];
	int	fmodes;
	char	nlink;
	char	fuid;		/* files owner */
	char	fill2[28];
	}	fbuf;
char	lbuf[200];
char	term	'%';
char	*termx	"%";
char	*tdev	"/dev/tty?";
char	*lockf	"/sptmp/ctrl/?lock";

main(argc,argv)
int argc;
char **argv;
{
int i;
int xuid;
	uid = getuid()&0377;
	if (argc > 1 ) goto doterm;
	if (stat(lpr[0], &fbuf) < 0) {
		printf("Sorry: lp not available\n");
		exit(1);
	}
	xuid = fbuf.fuid & 0377;
	if (xuid == daemon) goto ok;
	if ((xuid == uid) || (uid == 0)) goto rest;
	printf("LINE PRINTER IS NOT YOURS!\nMake sure that the paper is properly aligned\n");
	printf("Should it be released anyway?\nAnswer y for yes or anything else for no\n");
	read(0, lbuf, 200);
	if (lbuf[0] != 'y') goto fail;
rest:
	for (i=0; i<NDEV; i++) {
		chown(lpr[i], daemon);
		chmod(lpr[i], 0660);
	}
ok:
	execl(tpd, tpd, 0);
	exit(0);
fail:
	printf("Sorry: lp is not yours\n");
	exit(1);
doterm:
	term = argv[1][0];
	tdev[8] = term;
	lockf[12] = term;
	termx[0] = term;
	i = stat(lockf,&fbuf);
	if (i < 0) goto ckown;
	if (fbuf.fuid == uid&0377) {
		unlink(lockf);
		goto ckown;
	}
	if (fbuf.fmodes&0777 == 0400) {
		printf("Rl: Spooler already running on %s\n",tdev);
		exit(1);
	}
	printf("%s IS NOT YOURS!\nMake sure that the paper is properly aligned\n",tdev);
	printf("Should it be released anyway?\nAnswer y for yes or anything else for no\n");
	read(0, lbuf, 200);
	if (lbuf[0] != 'y') goto tfail;
	unlink(lockf);
ckown:
	stat(tdev,&fbuf);
	if (fbuf.fuid != ROOT) {
		printf("Rl: Someone is signed in on %s. Cannot start spooler\n",tdev);
		exit(1);
	}
	execl(tpd,tpd,termx,0);
	exit(0);
tfail:
	printf("Rl: Sorry - %s is not yours\n",tdev);
	exit(1);
}
