/* subrun
 * run batch programs at low priority from a queue of jobs
 * jobs are entered into /usr/lib/subtab in the form
 * uid:gid:dir:file
 * where dir is the current working directory when the job is submitted
 * and file is a file of commands to be submitted to sh for processing
 *
 * by David E. Miran
 * 12/1/81
 */

#include	<myio.h>
#ifdef DEBUG
#include	<stdio.h>
#endif

char	*ifile	"/usr/lib/subtab";	/* input list */
char	*ofile	"/usr/lib/subout";	/* list of work completed */
char	lbuf[200],	/* input line buffer */
	ubuf[10], gbuf[10],	/* uid, gid character strings */
	dbuf[100], fibuf[100],	/* director and file names */
	obuf[100];		/* output formation buffer */

int	uid, gid, ifid, ofid;
struct	fbuf	bufin;
long	ltime;
extern char *ctime();
char *tpt;
int	lpos;

main()
{
	register int i, j;
	register char c;
	nice(20);	/* low priority */
	ifid = open(ifile,0);
	ofid = creat(ofile,0644);
	mfinit(&bufin, ifid);
	dstamp();
loop:
	i = mgetlin(lbuf, &bufin);
	if (i < 1) goto done;
	write(ofid, lbuf, i);
	write(ofid, "\n", 1);
	lpos = 0;
	sget(ubuf,':');
	sget(gbuf,':');
	sget(dbuf,':');
	sget(fibuf,'\0');
	uid = atoi(ubuf);
	gid = atoi(gbuf);
	uid = uid | (uid<<8);
	gid = gid | (gid<<8);
/* set up done - fork off, find and check file, and execl shell */

	i = fork();
	if (i == 0) goto child;
	j = wait();
	dstamp();
	goto loop;
/* child process - convert uid/gid and execl shell */

child:
#ifdef DEBUG
	fprintf(stderr,"subrun: uid=%o gid=%o dir=%s file=%s\n",uid,gid,dbuf,fibuf);
#endif
	chdir(dbuf);
	setgid(gid);
	setuid(uid);
	if (!saccess(fibuf,4)) exit(1);
	execl("/bin/sh", "sh", fibuf);
	exit(1);	/* should never get here */
done:
	close(ifid);
	close(ofid);
	close(creat(ifile, 0644));	/* truncate job file */
}

dstamp()
{
	time(&ltime);
	tpt = ctime(&ltime);
	write(ofid, tpt, 25);
}

sget(str,ch)
char *str, ch;
{
register char c;
	while ((c = lbuf[lpos++]) != ch)
		*str++ = c;
	*str = '\0';
}
