/*
 * prwtmp [-w wtmp] [+offset] [-offset]
 *
 * print the wtmp file neatly
 * the -w option is followed by the name of a file to read, otherwise
 * /usr/adm/wtmp is used
 * +offset means to skip offset records into the file before starting
 * -offset means to start offset records from the end of the file
 *
 * by David Miran  10/24/80
 */

struct jb  {
	char	name[8];
	char	jtty;
	char	jfill1;
	long	stime;
	int	jfill2;
	char	proj[4];
};
struct jb jbuf;

#define	BUFSIZ	2048
char	ibuf[BUFSIZ];
struct	{		/* stat call buffer */
	char	sfill1[9];
	char	size0;
	unsigned	size1;
	char	sfill2[24];
	}	sbuf;

long actoff, fsize, fents;
long floc;
int offset;
int	entnum, fid, iptr, nrd;
int	bufeof;
#define	ENTSIZE	20

char	*wtmp;
char *cp;

main(argc, argv) 
char **argv;
{
extern char *ctime();
extern long lseek();
extern fout;
register i;

	fout = dup(1);
	offset = 0;
	wtmp = "/usr/adm/wtmp";
	if (argc == 1) goto doit;
	for (i=1; i<argc; i++)
		switch (argv[i][0])	{
			case '+':
				offset = atoi(&argv[i][1]);
				break;
			case '-':
				if (argv[i][1] == 'w') {
					i++;
					wtmp = argv[i];
					break;
				}
				offset = -atoi(&argv[i][1]);
				break;
			default:
				printf("invalid option %s\n",argv[i]);
				goto done;
		}
doit:
	if ((fid = open(wtmp, 0)) < 0) {
		printf("no %s\cannot open %s\n",wtmp);
		goto done;
	}
	stat(wtmp,&sbuf);
	fsize = sbuf.size0*65536L + sbuf.size1;
	fents = fsize/ENTSIZE;
	printf("file %s has %D entries\n",wtmp,fents);
	if (offset == 0) goto rdst;
	if (offset > 0) {
		actoff = offset;
		actoff =* ENTSIZE;
		if (actoff >= fsize) {
			printf("offset goes past end of file\n");
			goto done;
		}
		floc = lseek(fid, actoff,0);
		entnum = offset;
		goto rdst;
	}
	actoff = offset;
	actoff =* ENTSIZE;
	actoff =+ fsize;
	if (actoff < 0) {
			printf("offset backs up past start of file\n");
		goto done;
	}
	floc = lseek(fid, actoff, 0);
	entnum = actoff/ENTSIZE;
rdst:
	printf(" entry  name     proj tty time\n");
	bufeof = iptr = nrd = 0;
rdlp:
	if (getrec() == 0) goto done;
	cp = ctime(&jbuf.stime);
	entnum++;
	printf("%6d  %-8.8s %4.4s  %c  %s",
		entnum, jbuf.name, jbuf.proj, jbuf.jtty, cp);
	goto rdlp;
done:
	close(fid);
	flush();
	exit(0);
}
getrec()
{
register int i;
register char c, *jp;
	jp= &jbuf;
	for (i=0;i<20;i++) {
		c = *jp = get();
		if (bufeof == 1) return(0);
		jp++;
	}
	return(1);
}

char get()
{
	if (iptr == nrd) {
		nrd = read(fid, ibuf, BUFSIZ);
		if (nrd < 1) {
			bufeof = 1;
			return(0);
		}
		iptr = 0;
	}
	return(ibuf[iptr++]);
}
