/*
	npregular [-n]
		make std input n column regular (default 132)
		treat newline as end of record.
		Insert 5 spaces at beginning of lines after break.
	David E. Miran  3/8/83
	Wisconsin State Hygiene Lab
*/

#include	<stdio.h>

int	wid	132;
int	ifid, ofid;
int iptr, optr, nrd;
char ibuf[1024], obuf[1024];

extern char xget();

main(argc, argv)
int argc;
char **argv;
{
register int ccnt, i;
register char ch;

	if (argc > 1) {
		if (argv[1][0] == '-')
			wid = atoi(&argv[1][1]);
		else {
			fprintf(stderr,"Usage: npregular [-n]\n");
			exit(1);
		}
	}
	ifid = 0;
	ofid = 1;
	iptr = nrd = 0;
	optr = 0;
ccnt=0;
	while((ch = xget()) > 0) {
		if (ch == '\177') continue;
		if (ch == '\n') {
			xput('\n');
			ccnt = 0;
			continue;
			}
/* regular char */
		ccnt++;
		if (ccnt > wid) {
			xput('\n');
			for (i=0; i<5; i++) xput(' ');
			ccnt=6;
		}
		xput(ch);
	}
	exit(0);
}

char xget()
{
	if (iptr == nrd) {
		nrd = read(ifid, ibuf, 1024);
		if (nrd < 1) {
			if (optr>0) write(ofid, obuf, optr);
			return(0);
		}
		iptr = 0;
	}
	return(ibuf[iptr++]);
}

xput(c)
char c;
{
	obuf[optr++] = c;
	if (optr == 1024) {
		write(ofid, obuf, 1024);
		optr = 0;
	}
}
