/*
 * structures for rje message packets to/from U1100
 *
 * by 7-17-80
 */

struct icmesg {   /* control message input to U1100 */
	char	c_syncs[4];
	char	c_soh;
	char	c_msgnum;
	char	c_acknum;
	char	c_msgtyp;
	char	c_device;
	char	c_detail;
	char	c_etx;
	char	c_lrc;
	};

struct idmesg {   /* data message input to U1100 */
	char	d_syncs[4];
	char	d_soh;
	char	d_msgnum;
	char	d_acknum;
	char	d_msgtyp;
	char	d_device;
	char	d_detail;
	char	d_stx;
	char	d_data[SNDSIZE];
	char	d_etx;
	char	d_lrc;
	};

struct omesg {   /* data message output from U1100 */
	char	o_soh;
	char	o_msgnum;
	char	o_acknum;
	char	o_msgtyp;
	char	o_device;
	char	o_detail;
	char	o_stx;
	char	o_data[RECSIZE];
	char	o_etx;
	char	o_lrc;
	};

/* local message format - internal to rje package */

struct locmesg {
	int	m_size;
	char	m_type;
	char	m_dev;
	char	m_detail;
	char	m_text[507];
	};

/* directory entry structure */

struct dirent	{
	int	inum;
	char	fname[14];
	};

/* inode structure (partial) */

struct inode	{
	char	fill3[4];
	int	iflags;
	char	fill1;
	char	fuid;	/* owner id */
	char	fgid;	/* group id */
	char	fill2[23];
	long	fmod;	/* time last modified */
	};
