#
/* rjestat [trnum]
 * report on the status of the rje system
 * or on the status of a job with transmittal number trnum
 *
 * by David E. Miran
 * 4/23/81
 */

#include	<stdio.h>
#include	"../ntr/rjedef.h"
#include	"../ntr/rjefiles.h"

int	uid, gid, setid, rjeown;
char	upjob[7];
struct	{		/* returned from a stat system call */
	char	fill1[4];
	int	flags;
	char	fill2;
	char	fuid;
	char	fgid;
	char	size0;
	unsigned	sizew;
	char	fill3[20];
	long int modtime;
	}	sbuf;
int	fid;
long int fsize;
int	curstat;
char	ibuf[100];


main(argc, argv)
int argc;
char **argv;
{
register int i, j;
register char c;

	setbuf(stdout,NULL);
	if (argc < 2) {
		/* general site status check */
		fid=open(statfile,0);
		read(fid, &curstat, 2);
		close(fid);
		switch (curstat) {
			case NOTOP:
				printf("Rje system is not operational\n");
				break;
			case WTLOG:
				printf("Rje waiting on login\n");
				break;
			case TERMK:
				printf("Rje system is logged out (terminated)\n");
				break;
			case TIMDOUT:
				printf("Univac 1100 has timed out and is not responding\n");
				break;
			case ACTIVE:
				printf("Rje is logged in and is active\n");
				break;
			default:
				printf("Rje current status unknown\n");
		}
		fid=open(lsentfil, 0);
		read(fid, ibuf, 7);
		close(fid);
		ibuf[7] = '\0';
		fputs("last job transmitted to the Univac 1100 was ",stdout);
		fputs(ibuf,stdout);
		fid=open(msgfil,0);
		read(fid, ibuf, 24);
		close(fid);
		fputs("Last job received - ",stdout);
		ibuf[24] = '\0';
		fputs(ibuf,stdout);
		exit(0);
	}
	for (i=0; i<6; i++) {
		c = argv[1][i];
		if (c == 0) goto null;
		if ((c>= 'a') && (c<='z')) c =& 0337;  /* fold to upper case */
		upjob[i] = jobctrl[i+10] = jobout[i+9] = c;
	}
	if (argv[1][6] != '\0') goto null;
	goto gotf;
null:
	printf("rjestat: invalid transmittal number %s\n", argv[1]);
	exit(1);
gotf:
	if (stat(jobctrl, &sbuf) < 0)  goto chk_out;
	i = (sbuf.flags & 070) >> 3;
	switch (i) {
		case 4:
			printf("Job %s is queued for transmission\n",upjob);
			break;
		case 5:
			printf("job %s has been transmitted to the Univac 1100\n", upjob);
			break;
		case 7:
			printf("At least 1 file of output for job %s is complete\n", upjob);
			break;
		default:
			printf("Status of job %s is uncertain\n",upjob);
	}
chk_out:
	if (stat(jobout, &sbuf) < 0) {
		printf("No output file exists for job %s\n",upjob);
		exit(1);
	}
	fsize = (sbuf.size0 * 65536L) + sbuf.sizew;
	printf("job %s has %D characters of output ready\n", upjob, fsize);
	exit(0);
}
