#
/*
 * prti
 *
 *
 * Call:
 *	% prti list filesystem
 *
 *		where list is a list of inodes.
 *
 *
 * Description:
 *	Device must be a normal file or block-type special file. This is 
 * checked.
 *
 *
 * This program constitutes a merger of Bob Beck's stats, and setc programs.
 */

#include "/usr/sys/ino.h"			/* get disk inode structure */

struct inode	i_node;

struct {
	char	minor;				/* minor device of file	*/
	char	major;				/* major device of file	*/
	int	inumber;
	int	flags;
	char	nlinks;
	char	uid;
	char	gid;
	char	size0;
	int	size1;
	int	addr[8];
	int	actime[2];
	int	modtime[2];
}	statnode;				/* to get file status */

char access[50], modify[50];

#define BLOCK	060000				/* BLOCK-type flags */

main(argc,argv)
int	argc;
char	*argv[];
{
  register int	file, inum;
  int	isize, flag;

	if (argc < 3) {
		printf("Usage:  %s list filesystem\n",argv[0]);
		exit(0);
	}

	/*
	 * see if device is block special file or normal file.
	 */

	stat(argv[argc-1],&statnode);	/* get device (file) status */
	if ((flag = (statnode.flags&BLOCK)) && flag != BLOCK) {
		printf("Device must be normal or block-type special file.\n");
		exit(0);
	}

	if ((file=open(argv[argc-1],0)) < 0) {
		printf("can't open %s.\n",argv[argc-1]);
		exit(0);
	}

	/*
	 * see if inode number is legal.
	 */

	seek(file,1,3);		/* point at block 1 */
	read(file,&isize,2);	/* read isize from superblock */

	/*
	 * list each inode in list
	 */

	--argc;		/* bump off count for device	*/
	while (--argc) {
		printf("Inode %s:\n",*++argv);
		inum = getdec(*argv);

		/*
		 * check if inode number is legal.
		 */

		if (inum <= 0 || inum > 16 * isize) {
			printf("Bad inumber: %d\n",inum);
			continue;
		}

		/*
		 * point at inode and print.
		 */

		seek(file,(inum+31)/16,3);	/* point at block of inode */
		seek(file,32*((inum+31)%16),1);	/* point at inode in block */
		read(file,&i_node,sizeof i_node);	/* read inode */

		ilist(&i_node);
	}
}

/*
 * get a decumal number. argument is a string. on error, message is printed
 * and exit.
 */

getdec(string)
char	*string;
{
  register char	*p, c;
  register int	num;

	p = string;
	num = 0;
	while(c = *p++)
		if (c >= '0' && c <= '9') {
			num =* 10;
			num =+ c - '0';
		} else {
			printf("Bad number %s\n",string);
			exit(0);
		}
	return(num);
}

/*
 * list an inode
 */
ilist(node)
struct	inode	*node;
{
		printf("\tflags:\t%o\n",i_node.i_mode);
		printf("\tlinks:\t%d\n",i_node.i_nlink);
		printf("\towner:\t%d\n",i_node.i_uid&0377);
		printf("\tgroup:\t%d\n",i_node.i_gid&0377);
		printf("\tsize:\t%l,%l\n",i_node.i_size0,i_node.i_size1);
		printf("\taddrs:\t%o,%o,%o,%o,%o,%o,%o,%o\n",
			i_node.i_addr[0],i_node.i_addr[1],i_node.i_addr[2],
			i_node.i_addr[3],i_node.i_addr[4],i_node.i_addr[5],
			i_node.i_addr[6],i_node.i_addr[7]);
		strcopy(ctime(i_node.i_atime),access);
		strcopy(ctime(i_node.i_mtime),modify);
		printf("\taccess:\t%s",access);
		printf("\tmod:\t%s\n",modify);
}

/*
 * copies one string to another.
 */
strcopy(a,b)
char	*a, *b;
{
  register char *s, *d;

	s = a; d = b;
	while(*d++ = *s++) ;
}
