/*
 * fieldnum file ...
 * number fields in a format
 * by W. J. Kurth
 * modified by David E. Miran
 * Version of 9/13/82
 */
#include <stdio.h>

main(argc, argv)	
int argc;
char *argv[];
{
	FILE *fp, *fopen();

	if (argc == 1) /* no args; copy standard input */
		filecopy(stdin);
	else
		while (--argc > 0)
			if ((fp = fopen(*++argv, "r")) == NULL) {
				fprintf(stderr,
					"fieldnum: can't open %s\n", *argv);
				exit(1);
	} else {
		filecopy(fp);
		fclose(fp);
	}
	exit(0);
}
filecopy(fp) /* copy file to standred output with format field numbering*/
{
int c, n, s;
	n = 0;
	s = 0;
	while (( c = getc(fp)) != EOF) {
		if (c == '\n')
		s = 0;
		if ((c == ' ') && (s > 0)) {
		--s;
		continue;
		}
		putc(c, stdout);
		if (c == '[') {
			printf("%d", n);
			printf(") ");
			s += 3;
			if (n > 9) s++;
			if (n >99) s++;
			++n;
		}
	}
}
