/*
	structures used for the indexed enquiry system
	by David E. Miran  3/3/81
 */


#define	CURREN	01
#define	NOTCUR	02
#define	HOLES	04
#define	MAXFILE	400	/* maximum number of file table entries */
#define	CMPREC	1200	/* compressed record */
#define	MAXBUF	2048	/* uncompressed record */
#define	PNSIZE	10	/* patient name size */

/* base level index entry (the real index entry) */
struct	basent	{
	char	name[PNSIZE];	/* patient name */
	long	floc;	/* offset into the file (lseek) */
	int	fnum;	/* the file number (shorthand name) */
	};

/* concentrate index entry */
struct	concent	{
	char	cname[16];
	};

/* file table entry - name vs number */
struct	filent	{
	char	fname[28];
	int	fflag;
	int	ifnum;
	};

struct	dexhead	{	/* table header */
	long	lastup;		/* last time index was updated */
	int	maxfile;	/* highest file number assigned */
	int	numfile;	/* actual number of files in table */
	int	recmode;	/* record mode (0=' fldsep, 1=: fldsep */
	char	fmtname[30];	/* format name */
	long	maxseq;		/* highest sorted index entry - more may follow */
	char	hfill[26];	/* room to grow without rebuilding index */
	};
