/*
 *clr
 * clear the screen of a terminal - issue a type dependant message
 * use the terminal types in /etc/termftype
 * by David E. Miran, Wisconsin State Hygiene Lab
 * 12/1/82
 */

#include	"myio.h"

char	*cls[]	{
		"\014\0\0",	/* printing and unknown terminals use control L */
		"\033E\0\0\0",	/* Superbee terminals use Escape E */
		"\014\0\0\0",	/* Teleray terminals use Control L */
		"\033\020\0\0\0",	/* Economy terminal (ET2/D) uses Escape Control P */
		"\014\0\0",		/* Concept 108 uses Control L */
		0};
int	cl_l[]		{3, 5, 4, 5, 3, 0};
int	termtype	0;	/* set to terminal type 1=sb2, 2=telry, 3= et2 , 4=concept108 */

char	*termfile	"/etc/termftype";

main()
{
char c;
char termrec[4];
struct fbuf fpr;
int fid;

	c = ttyn(0);
	if (c == 'x') goto setit;
	if ((fid = open(termfile, 0)) < 0)
		goto setit;
	mfinit(&fpr, fid);
	while (mgetrec(termrec, 4, &fpr)) {
		if (c != termrec[0]) continue;
		c = termrec[2];
		goto setit;
	}
	c = ' ';
setit:
	switch (c) {
		case 't':
			termtype = 2;  break;
		case 'e':
			termtype = 3; break;
		case 's':
			termtype = 1; break;
		case 'c':	/* concept 108 */
			termtype = 4;  break;
		default:
			termtype = 0;
	}
	write(1, cls[termtype],cl_l[termtype]);
	sleep(1);
}
