.TH DATE 3L
.SH NAME
date, atodate, bartime, stdtime, timenow, ymdtime, printt, fprintt
manipulate and convert standard times and people times
.SH SYNOPSIS
.nf
#include "stdtime.h"

/* DATE curtime; */

TIME date (tim)
TIME tim;

TIME atodate (string)
char *string;

TIME bartime (bar_rot, bar_day)
int bar_rot, bar_day;

TIME stdtime (year, doy, hour, minute, second)
int year, doy, hour, minute, second;

TIME timenow()

TIME ymdtime (year, month,day, hour, minute, second)
int year, month, day, hour, minute, second;

char *printt (tim)
TIME tim;

#include <stdio.h>
char *fprintt (fp,tim)
FILE *fp; TIME tim;

char * _Months[13]

.fi
.SH DESCRIPTION
Standard time procedures. These procedures provide tools
for converting "times" from internal to external (i.e. people) 
form and vice versa. Standard times are measured in
seconds since 0H UT 1 Jan 1601.  Times are stored in doubles
although the typedef TIME is provided in stdtime.h and is
preferred.  A time of 0.0 is defined as a missing time where
appropriate.  most of the stdtime procedures return a time.
In all cases the static external DATE curtime is updated to
contain the last time computed.  If any of the other forms
of time in curtime are wanted they must be copied to a safe
place before the next invocation of any of the time pro-
cedures.

date - is used to convert a TIME to people form. the con-
verted forms are to be taken from curtime.  Fills the date
structure.

_Months is an array containing a string for each month. For
example _Months[4] = "April" and _Months[0]="BAD"

atodate - converts ascii string to a time.  Several forms
are allowed.  If the first element of the string is an
integer a "ymdtime" is assumed.  The forms allowed for ymd
type times are somewhat flexible. In the description below,
yyyy represents at most 4 digits of year. Similiarly, mm,
dd, hh, MM, ss represent digits for month, day, hour,
minute, and second.  The symbol "mon" represents the month
as a string.  "mon" may be abbreviated.  Case of letters is
ignored.  The ymd forms (and restrictions) follow:
.nf
  ":" or white-space may be used where ":" is shown.
  if only a 2-digit year is given, year must be > 31.
  yyyy:mm:dd:hh:MM:ss
  yyyy:mm:dd hhH:MMm:ssS  (e.g. 1976:5:15 20h:15m:20s)
  yyyy:mm:dd:hh:MM
  yyyy:mm:dd:hh
  yyyy:mm:dd
  yyyy:mm
  yyyy
  The form of time within a day shown above also is used
  in the forms below.
  yyyy mon dd
  mm/dd/yyyy
  dd mon yyyy
  ddmonyyyy
  mon yyyy
  mon dd yyyy
.fi

If the first element is a string but not a month the time
will be one on the following forms: - - none at present - -

bartime - converts Bartels rotation and day within rotation
to a TIME and DATE.  Day must be in the range 1 to 27.  The
reverse conversion is always done and placed in the DATE.

stdtime - converts year, day-of-year, hour, minute, second
to a TIME and DATE.  Day-of-year starts with 1 and goes to
365 (366 in leap years).

timenow - returns the clock time of right now.  Note that
timenow returns PST or PDT rather that UT since it is usu-
ally to be used to label plots, etc rather than to tag data.

ymdtime - converts year, month, day, hour, minute, second to
a TIME and DATE.  Day is checked for proper range depending
on month and year.  As with stdtime, hour must be 0:23;
minute and second must be 0:59.  Also as with stdtime, years
in the range 0 to 99 are converted to 1900 to 1999 so that
either form is allowed.

The include file stdtime.h is:

.nf
.ta 1.5 +8.0 +8.0 +8.0 +8.0
.so stdtime.h
.fi

printt and fprintt print the time given in a standard form
and return a null string.

.SH FILES
.nf
/usr/src/local/date/times.c
/usr/local/lib/libdate.a
/usr/src/local/date/makefile is a make file.
see also timecnv(1l) time(2) and ctime(3).
.SH BUGS
.fi
Do not make an external variable "time" if you use "timenow".

