char id[] = "%W% %H%";
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
#include <sys/timeb.h>
#include "../includes/error.h"
#include "stdio.h"
#define TRACE 1         /* defined if tracing user input */
#ifdef TRACE
FILE *fptrace;		/* stream output for FTRACE */
FILE *fpscript;		/* stream input from FSCRIPT */
struct timeb before, after;	/* used to get system times */
#endif
#include <pwd.h>	/* used to get etc/passwd data */

typedef char  **EVLIST;		/* environment list pointer */
typedef char  *PCHAR;		/* type for pointer to character */
#define ISIZE sizeof(int)	/* this is 4 on Perkin-Elmer */
#define MENU_CHAR 0226		/* ostensibly illegal char for menu prgm */
#define CATSYM '+'		/* indicates args must be concatenated */
#define NARG  29		/* maximum number of allowable
				   arguments in program in menu file */
#define PROMPT '@'	/* menu file code to prompt for input on the fly */
#define PROTECT '#'	/* menu item protect code--ask for confirmation */


	/* Note gettr is similar to getc. */
	/* gettr uses the PHFILE structure rather than FILE */


#define PHINSIZE 512	/* the size of the raw input buffer */

typedef struct  {		/* phony iobuf structure */
	char  *ph_ptr;		/* points to next char to read */
	int   ph_cnt;		/* number of characters in the buffer */
	char  *ph_inptr;	/* the next ph_inbuf char to scan */
	int   ph_incnt;		/* unscanned characters in ph_input */
	int   ph_real;		/* the real file being read */
	char  ph_eof;		/* set to 1 if end of file has been detected */
	char  ph_input[PHINSIZE];   /* where to read the raw input */
}  PHFILE;

PHFILE  file_m;                 /* the structure for main file reading */
PHFILE  file_h;			/* the structure for help file reading */
PHFILE  file_tty;		/* the file for reading stdin */
#define prim_fd (&file_m)	/* points to primary file structre */
#define stdtr   (&file_tty)	/* points to standard input file struct */
#define help_fd (&file_h)	/* points to help file struct */
#define gettr(p)	(--(p)->ph_cnt>=0? *(p)->ph_ptr++&0377:tr_filbuf(p))
#define gettrans()	gettr(stdtr)
#define getstrs(x)	getstr(stdtr,x)

char	*shprgm;	/* points to the SHELL program's name */
EVLIST	menuslot;		/* points to MENU in new environment */
char	*pgprgm;	/* the paging program ($PG) */
char	*home_dir;	/* points to the home directory string */
extern EVLIST environ;	/* this is set by C start-up to point to environment */
			/* ecreate routine changes it */
typedef unsigned int TYPVAR;	/* l_various type below */
typedef unsigned short TYPFLAG;		/* l_flag type below */
typedef struct	 {	/* points to data for one menu selection */
	char *l_menu;	/* the menu line to be written out */
			/* includes number at start, newline at end */
	char *l_dir;	/* the directory to change to or NULL */
	char *l_prgm;	/* the program to be run */
	TYPVAR l_various;		/* various codes -- see below */
	TYPFLAG l_flag[NARG+1];	/* argument type--see defines below */
	char *l_arg[NARG+1];	/* the arguments */
				/* if NULL no more args */
} LINE_STRUC, N_L_STR [9], *L_PTR;
	/* note that 9 above is number of menu lines.  the code
	   expects one digit menu codes; thus 9 is an absolute max */

	/* masks for l_flag */

#define L_DONE   0x8000		/* set if previous was last argument */
#define L_DEFAULT 0x200         /* set if ok to default prompt response */
#define L_LFTCAT 0x100		/* concatenate with argument to the left */
#define L_RHTCAT 0x80		/* concatenate with argument to the right */
#define L_PROMPT 0x40		/* l_arg is a string for prompting user */
#define L_REDIR  0x20		/* answer to prompt must be prepended by ">" */
#define L_PRGM   0x10		/* this argument is the program name */
#define L_PNO    0xf		/* the numbered prompting argument */
				/* if l_flag is zero, use literal l_arg */

/* Valid combinations for l_flag arguments:

	0 = argument is to be used literally as contained in l_arg
	L_DONE = previous argument was the last one
	L_PRGM = this is not an argument but rather the program name
	L_PROMPT | (L_PNO & k) = on the fly prompt should be printed
		to get argument @k.  The l_arg is the prompting string.
	L_PROMPT | L_REDIR | (L_PNO & k) = same as above but answer
		should have '>' pre-pended.
	L_PNO & k = substitute on-the-fly answer k at this position
	(L_PNO & k) | L_LFTCAT = concatenate response k with previous argument
	(L_PNO & k) | L_RHTCAT = same except concat with next argument
	(L_PNO & k) | L_LFTCAT | L_RHTCAT = concat on both sides
*/
	/* masks for l_various */

#define L_PROTECT 04		/* set if item requires confirmation */
#define L_NEEDSH  02		/* set if program needs the shell */
#define L_NEEDPR  01		/* set if item has some on-the-fly prompts */

struct stat stat;		/* used to get status of file */
extern char *malloc();		/* see UPM malloc, section 3 */
extern char *index();		/* see UPM string, section 3 */
char    *file;			/* the name of the file */
char	work_dir[80];		/* working directory name stored here */
#define print_dir() printf("\nCurrent directory is %s", work_dir);
#define MINI "\n\t(3h or h)elp,(q)uit,(s)hell,(c)urr menu,(d)ir change,\n\t(w)orking dir"
#define MINI2 ",(m)ain menu,(p)rev menu"
#define BAD_ANS "* invalid response - try again *\n"
#define NOPWD "Cannot execute command pwd\n"
#define BAD_FILE "* menu file has invalid format *\n"
#define RE_MSG "\nDo you wish to save the results of this option? (y or n) "
char line[100];			/* buffer for reading user response */
#ifdef TRACE
char ex_line[100];	/* holds expected answer when using scripts */
char *expected = "";		/* points to expected answer */
			/* == NULL if no script of end of file */
			/* points to NULL if end of current script item */
#define SEP_LINE "**********************************************************\n"
#endif
char *answer = "";	/* points to menu select string being scanned */
int pid;		/* process id for child process */
/*

Name:
	main

Function:
	Do a bit of start-up work and then invoke the menu routine.

Parameters, etc:
	Refer to the main program comments.
*/



main(argc, argv, envp)

int	argc;		/* the number of arguments */
char	*argv[];	/* the arguments */
EVLIST	envp;		/* the environment */

{
	char	*subenv();	/* routine to find an environment
				 	replacement string */
	int	sigquit();	/* dump i-nodes and core upon SIGQUIT */
#ifdef TRACE
#define ARGMAX 4
	register EVLIST ep;
	register struct passwd *pw;
	register char *cp;
#else
#define ARGMAX 2
#endif

	signal(SIGQUIT, sigquit);	/* dump i-nodes, core */
	signal(SIGINT, SIG_IGN);	/* will catch this later */
	if (argc > ARGMAX) {
		printf ("Too many arguments\n");
		exit (E2BIG);
	}
	if (argc < 2) {
		printf ("Too few arguments\n");
		exit (ENOARG);
	}
#ifdef TRACE
	if (argc > 2) {
		if ((fptrace = fopen(argv[2], "a")) == NULL) {
			printf("Could not open trace output file %s\n", argv[2]);
			argc = 2;	/* ignore the others */
		}
	}
	if (argc == 2)
		fptrace = fopen("/dev/null", "w");
	if (argc > 3)
		if ((fpscript = fopen(argv[3], "r")) == NULL) {
			printf("Could not open script file %s\n", argv[3]);
			argc = 3;
		}
	if (argc <= 3)
		expected = NULL;	/* no script input */
#endif
	ecreate();	/* load the environment */
	shprgm = subenv("SHELL", environ, NULL);
	pgprgm = subenv("PG", environ, NULL);		/* the paging program */
	home_dir = subenv("HOME", environ, NULL);	/* $HOME */
	run_pwd();		/* get the current directory */
	trdup(0, stdtr);	/* make a tr stream for stdin */
	file = argv[1];		/* menu uses this global variable */
	umask(0);		/* this is needed for executive support */
#ifdef TRACE
	fprintf(fptrace, "13572\n");	/* magic number */
	fprintf(fptrace, "%s\n", file);	/* the main menu file name */
	pw = getpwuid(getuid());
	if (pw)
		cp = pw->pw_name;
	else
		cp = "????";
	endpwent();		/* close /etc/passwd */
	fprintf(fptrace, "%s\n", cp);
	ep = environ;
	while (cp = *ep++) {
		while (*cp) {
			if (*cp == '\n')
				fprintf(fptrace, "\\n");
			else
				putc(*cp, fptrace);
			cp++;
		}
	putc('\n', fptrace);
	}
	time(&before);		/* defense against early SIGINT */
#endif
	menu(0, '0');	/* invoke main menu with dummy choice number */
}
/*

Name:
	subenv

Function:
	The first argument is a string which might be an environment variable.
	The second argument is the pointer to the environment.
	The third argument is *EVLIST, it points to where the pointer
	should be stored indicating where the item should be in the list.
	If the item is found, the third argument is the same as
	the returned value.
	If it is not found, it points to where the string would
	fall alphabetically.
	If the third argument is NULL, it is not used.

Algorithm:
	The string is looked up, and if it is found, a pointer to the null-
	terminated string to substitute is returned.  Otherwise, zero is
	returned.

Parameters:
	bp = pointer to environment variable
	envp = pointer to environment list (third arg to main from exece)
	where = pointer to EVLIST variable to store pointer to where
		the item should go in the list.
		(Ignored if == NULL.)

Returns:
	A pointer to the string to substitute, or 0 for not found.

Files and Programs:
	None.
*/

char *subenv(bp, envp, where)

char *bp;	/* pointer to variable to look up */
EVLIST envp;	/* pointer to the environment */
EVLIST *where;	/* returned value for ideal slot to put name */
		/* where is an optional argument */

{
	register char *name, *cur;
	register EVLIST elist;

	name = bp;		/* set to start of name */
	cur = *(elist = envp);  /* environment list */
	while (cur)  {		/* seek thru envp list */
		if (*cur == '=')	/* end of env name */
		    if (*name == NULL) {      /* exact hit */
			if (where)
				*where = elist;	/* the ptr to name */
			return(++cur);
		    }
		    else  {   /* env name short; try next one */
			cur = *++elist;
			name = bp;
			continue;
		    }
		if (*name++ != *cur++)  {	/* try next one */
			cur = *++elist;
			name = bp;
		}
	}
	if (where)
		*where = elist;		/* not on the list */
	return (0);
}
/*

Name:
	menu

Function:
	Single level menu driver.  Display the menu and prompt user
	for action.

Parameters:
	level = level of this menu (0 == main, > 0 sub-menu levels)
	choice = ascii char 1-9 for menu choice to this level,
		(zero if main menu)

Algorithm:
	Open the file and read it in.  Then repeatedly dump
	the menu to the screen and ask for the answer.

Returns:
	1 = stay at current level and do not re-display menu
		(only occurs upon error)
	0 = returning via p or m command--display menu only
		at end of command string.

*/

menu(level, choice)

int	level;		/* menu level with 0 as main */
char	choice;		/* menu choice from last level to get here */

{
	char  *block;			/* large block of data */
	L_PTR   this;		/* menu line structure pointer */
	char  *top;			/* top of currently allocated space */
	char  *helpfile;			/* the help file name */
	register int c;
	int m_count;		/* will hold the number of menu items */
	char  *select;			/* the prompt for the menu selection */
	char  *intro;			/* header data in the menu */
	char  counter = '0';		/* ascii count of menu items */
	TYPVAR	*lvarious;	/* points to current LINE_STRUC.l_various */
	char	**larg;		/* points to current LINE_STRUC.l_arg */
	TYPFLAG	*lflag;		/* points to current LINE_STRUC.l_flag */
	char	**lprgm;	/* points to current LINE_SRUCT.l_prgm */
	int siz;
	char dis_menu;		/* set to 1 to display menu */
	char *copy();		/* routine to copy strings */
#ifdef TRACE
	static char ex_prompt[80];      /* the script prompt */
	static int  sc_count = 0;       /* count of script commands */
#endif
	int sigcatch();		/* routine to handle SIGINT */

	if ((c = open(file, 0)) < 0) {		/* open the file */
		printf("Can't find Menu file %s\n", file);
		if (level == 0)
			exit (ENOENT);
		answer = "";
		return (1);	/* stay at old menu level */
	}
	trdup(c, prim_fd);		/* make tr type stream for it */
	fstat(prim_fd->ph_real, &stat);	/* get status data */
	if ((block = malloc( sizeof(N_L_STR) + stat.st_size + 2048)) == 0) {
			/* get needed space for data storage */
		printf("Unable to allocate needed space\n");
		exit (ENOMEM);
	}
	helpfile = block + sizeof(N_L_STR);
			/* space for line pointers */
	top = copy(file, helpfile);	/* make up help file name */
	top = copy(".h", top);	/* add .h to get the name */
	*top++ = NULL;
	intro = top;	/* the header data in the menu */

	/* load the whole header into core */

	while (((siz = getstr(prim_fd, top)) > 0) && *top != ':')
		top += siz;
	*top++ = NULL;		/* end of the introduction */

	/* load the menu selection lines */

	this = (L_PTR) block - 1;	/* point to [-1] structure */
	while ((c = gettr(prim_fd)) != ':' && c != EOF
			&& ++counter <= '9') {
		(++this)->l_menu = top;	/* the line itself */
		top = copy("\t(", top);
		*top++ = counter;	/* ascii counter */
		top = copy(")  ", top);
		if (c == PROTECT)
			this->l_various = L_PROTECT;	/* confirm when asked */
		else {
			this->l_various = 0;
			*top++ = c;
		}
		while ((*top++ = gettr(prim_fd)) != ':');
		*(top-1) = '\n';
		*top++ = NULL;
		if ((*top = gettr(prim_fd)) != ':') {
			this->l_dir = top++;
			while ((*top++ = gettr(prim_fd)) != ':');
			*(top-1) = NULL;
		}
		else	this->l_dir = NULL;
		larg = &this->l_arg;
		lflag = &this->l_flag;
		lprgm = &this->l_prgm;
		lvarious = &this->l_various;
		*lprgm = NULL;		/* must be filled later */
		while (fill_arg(&top, larg++, lflag++, lvarious, lprgm));
		*lflag |= L_DONE;	/* first unused slot */
		*larg = NULL;		/* first unused slot */
		if (*lprgm == NULL) {
			printf("Menu file %s has bad format\n", file);
			exit (EFORM);
		}
	}
	if (counter >'9') {
		printf("Menu file %s has more than 9 items\n", file);
		exit (EFORM);
	}
	if (c != EOF) {
		select = top;
		while ((c = gettr(prim_fd)) != EOF)
			if (c != '\n')
				*top++ = c;
		*top++ = NULL;		/* mark string end */
	}
	else select = "Selection? ";
	m_count = counter & 017;	/* the integer number of items */
	close (prim_fd->ph_real);		/* close the file */
	realloc(block, top - block);	/* discard unneeded space */

	/* now loop--display prompt (and menu), get request, act
	   on it.  Note that SIGINT causes loop to be re-initiated.
	*/

	dis_menu = *answer == NULL;	/* don't display menu if
						doing multi-levels */
	for (;;) {
		setexit();	/* causes SIGINT to return here */
		signal(SIGINT, sigcatch);
		if (dis_menu) {
			this = block;
			printf(intro);
			for (c = 1; c <= m_count; c++)  {
				printf ( this++->l_menu );
				putchar('\n');
			}
			dis_menu = 0;		/* assume no display */
		}
		if (*answer == NULL) {
			printf(MINI);	/* the mini-menu */
			if (level != 0)
				printf(MINI2);	/* the non-main choices */
			putchar('\n');
#ifdef TRACE
			if (expected) {
				if (*expected == NULL) {
					sc_count++;     /* bump the script counter */
					expected = fgets(ex_prompt,
						sizeof(ex_prompt), fpscript);
						  /* message to user for what to do */
					if (expected != NULL)
						expected = "";
				}
				printf(SEP_LINE);
				printf("(%d) %s",sc_count,ex_prompt);
				if (expected && *expected == NULL) {
					fprintf(fptrace, ":\n%s", ex_line);
					expected = fgets(&ex_line[40],
						sizeof(ex_line) - 40, fpscript);
					if (expected) {
						fprintf(fptrace, ex_prompt);
						*(index(expected,'\n')) = NULL;
						if (*expected == 'm') {
							expected++;
							for (c = 1; c <= level;
									c++)
								*--expected
									= 'p';
						}
					}
				}
				if (expected == NULL)
					printf("End of menu test file\n");
				printf(SEP_LINE);
			}
#endif
			printf(select);		/* print the prompt */
			if ((answer = valid_resp(level)) == NULL)
				answer = "X";	/* bad answer */
		}
		switch (c = *answer++) {
			case 'q':
#ifdef TRACE
				if (fptrace)
					fclose (fptrace);
#endif
				exit(ENOERR);
				break;

			case 's':
			case '!':
				signal(SIGINT, SIG_IGN);
				shell(answer, NULL);
				while (pid != wait (0));
				printf("!\n");
				answer = "";	/* get new response */
				break;

			case 'd':
				print_dir();
				new_dir();
				answer = "";	/* new_dir uses line */
				break;

			case 'w':
				print_dir();
				break;

	/* note case 'm' handled by valid_resp routine */

			case 'p':
				if (level == 0) {
					printf(BAD_ANS);
					answer = "";
					break;
				}
#ifdef TRACE
				if (expected)
					if (*expected == 'p')
						expected++;  /* good */
					else
						*--expected = choice;
#endif
				signal(SIGINT, SIG_IGN);
				free(block);
				return(0);  /* previous */

			case 'h':
				c = *answer;
				if (c != NULL && (c < '1' || c > counter))
					printf(BAD_ANS);
				else {
					signal(SIGINT, SIG_IGN);
					help(helpfile, c & 017);
				}
				answer = "";	/* help uses "line" */
				break;

			case 'c':
				dis_menu = 1;
				break;

			default:
				if (c < '0' || c > counter) {
					printf(BAD_ANS);
					answer = "";
					break;
				}
				this = (L_PTR) block + ((c & 017) - 1);
#ifdef TRACE
				if (expected)
					if (*expected == c)
						expected++;  /* good */
					else if (*(this->l_prgm) == MENU_CHAR)
						*--expected = 'p';
#endif
				c = do_item(c, level,  this);  /* do it */
				dis_menu =  !c && *answer == NULL;
		}
	}

}
/*

Name:
	fill_arg

Function:
	Read in the arguments from the menu file and set up the
	LINE_STRUC structure as needed.

Parameters:
	**base: *base points to where to put the data
	**arg: set *arg to point to argument read or to "<"
		if a redirect prompt or to "" if a straight prompt.
	**flag: set *flag to contain l_flag value
	*various:  set as l_various indicating shell need and prompt use
	**prgm:  set to point to argument if it is the program

Returns:
	1 if an argument was read
	0 if end of line (newline or EOF read)

Errors:
	exit with EFORM status if bad file format detected.

Algorithm:
	The file has colon separated arguments terminated by a newline.
	One argument is read and the pointers are set up.
	(Note that prompting arguments have form :@p1:Prompt:,
	and that prompted for arguments have form @1.)
*/

fill_arg(base, arg, flag, various, prgm)

char	**base;		/* *base points to the data area */
char	**arg;		/* set *arg to point to argument */
TYPFLAG	*flag;		/* set to value of l_flag needed */
TYPVAR	*various;	/* set to indicate shell need and prompts */
char    **prgm;		/* set to point to the program string */

{
	register char *top;	/* points to top of data area */
	register int  c, k;	/* used as temporary storage */

	top = *base;		/* new value will be copied back
					upon exit */
	*flag = 0;		/* assume normal literal argument */
	switch(c = gettr(prim_fd)) {

		case EOF:
		case '\n':
			*flag = L_DONE;		/* end of args */
			return(0);

		case PROMPT:
			*various |= L_NEEDPR;	/* must do prompts */
			c = gettr(prim_fd);	/* o or p or digit */
			if (c == CATSYM) {	/* concat to left */
				*flag = L_LFTCAT;
				*various |= L_NEEDSH;
				c = gettr(prim_fd);
			}
			if (c == 'o')
				*flag = L_PROMPT | L_REDIR;
			else if (c == 'd')
				*flag = L_PROMPT | L_DEFAULT;
			else if (c == 'p')
				*flag = L_PROMPT;
			else if (c < '0' || c > '9')
				break;
			else {
				*flag |= L_PNO & c;	/* which one */
				c = gettr(prim_fd);
				if (c == CATSYM) {
					*flag |= L_RHTCAT;
					*various |= L_NEEDSH;
					c = gettr(prim_fd);
				}
				if ((k = (c == ':')) || c == '\n' || c == EOF)
					return (k);
				break;
			}
			c = gettr(prim_fd);
			if (c < '0' || c > '9')
				break;
			*flag |= c & L_PNO;
			if (gettr(prim_fd) != ':')
				break;
			c = gettr(prim_fd);
			if (c == PROMPT)
				break;	/* must be a string */

	/* next item must be literal prompting string */

		default:
			if (*prgm == NULL && *flag == 0) {
				*prgm = top;	/* this is the program */
				*flag = L_PRGM;
			}
			*arg = top;
			do *top++ = c;
				while ((c = gettr(prim_fd)) != ':' && c != '\n'
					&& c != EOF);
			*top++ = NULL;
			*base = top;
			if (!(*various & L_NEEDSH)) {  /* look for odd chars */
				top = *arg;	/* first char in string */
				while (*top) switch (*top++) {
					case ';':
					case '<':
					case '>':
					case '&':
					case '`':
					case '|':
					case '"':  *various |= L_NEEDSH;
						   break;
					default:  ;
				}
			}
			return (c == ':');
	}
	printf ("Menu file %s has bad format\n", file);
	exit(EFORM);
}
/*

Name:
	valid_resp

Function:
	Get a response for a menu item selection from the standard
	input and check it for validity.  If valid, return a pointer
	to it.  If not, return NULL.
	Translate 'm' (main) into appropriate number of p's.  If at main
	level then ignore the m unless it is the only character, in which
	case return 'c' to get menu re-displayed.

Parameters:
	level -- menu level as in menu function

Valid response:
	q		exit program immendiately
	(s + !)		run an interactive shell
	(s + !)command	run "command" as a shell command string
	w		print working directory
	d		change working directory
	c		print current menu in full
	h		print current help file in full
	h#		print help item #
	#h		same as above--returned as h#
	[p* + m]k*n	p's back up one level each.  m goes to main
			level.  k's select item k from the menu.  The
			menu software will proceed with k's until one
			is found which is not refering to a menu.
			At that time the process stops and the rest of
			the string is discarded.  If all k's are exhausted,
			item n is chosen which need not be a sub-menu.
			Example:  ppp32 back up 3 levels, selects menu item
			3 and then from its menu selects item 2.
Returns:
	pointer to valid string or NULL for bad string entered.
*/


valid_resp(level)

int	level;		/* the menu level */
{
	register int k;		/* number of characters read */
				/* also mode for p, m, digit scan */
	register char c;
	register char *cp;
	register char *head;	/* will point to the head of the answer */
#ifdef TRACE

	time(&before);		/* get the time */
#endif
	k = getstrs(head = cp = &line[20]);	/* get the answer */
#ifdef TRACE
	time(&after);		/* get the time again */
	fprintf(fptrace, "%d\n",
		  after.time - before.time);
	fprintf( fptrace, head);	/* write response */
#endif
	if (k < 2)		/* note newline is counted */
		return(NULL);
	*(head + k - 1) = NULL;		/* NULL out newline */
	switch (c = *cp++) {
		case 'p':
			k = 1;		/* p read */
			break;

		case 'm':
			k = 2;		/* m read */
			if (level > 0) {
				head = cp - level;
				while (cp > head)
					*--cp = 'p';
				cp += level;	/* restore cp */
			}
			else if (*cp == NULL)
				return ("c");  /* just display */
			else head++;	/* superfluous m */
			break;		/* must be checked below */

		case 's':
		case '!':
			return(head);		/* any response is ok */

		case 'q':	/* single char answers */
		case 'w':
		case 'd':
		case 'c':
			return (k == 2 ? head : NULL);

		case 'h':
			c = *cp;
			if (k == 2 || (k == 3 && c > '0' && c <= '9'))
				return(head);
			return (NULL);

		default:
			if ( c < '1' || c > '9')
				return(NULL);	/* not a digit */
			if ( k == 3 && *cp == 'h') {
				*head = 'h';
				*(head + 1) = c;
				return (head);
			}
			k = 3;		/* digit read */
	}
	while (c = *cp++) switch(c) {

		case 'p':
			if (k > 1)
				return (NULL);
			k = 1;
			break;

		default:
			if (c < '1' || c > '9')
				return (NULL);
			k = 3;
	}
	return(head);
}
/*

Name:
	do_item

Function:
	Run the program selected from the menu list.  First items
	which are on-the-fly prompts must be requested.

Parameters:
	item:	character digit which is the item selected from menu
	level:  menu level in menu function
	p:	pointer to structure containing data for menu item
		selected.

Algorithm:
	Scan through argument list looking for on-the-fly prompts.
	For each found, request it and put results in pbuffer,
	set up pointers pb.  Finally, run the program.  If the
	shell is needed (NEEDSH in the structure set) then
	copy the arguments into a string and call shell.  Otherwise
	simply fork a process and run the program.  Note that
	redirection prompts cause shell to be needed.

Returns:
	1 = stay at same level menu.
	0 = return to previous level menu.
*/

do_item(item, level, p)

char item;
int level;
L_PTR p;

{
	static char pbuffer[1000];	/* used to hold prompt replies */
	register char *pb;
	register int i, j, k;
	static char *on_fly[10];	/* pointers to prompt replies */
	char **pbptr, **arg_list;	/* point to arg list for execv */
	char *sstr;		/* points to shell command line */
	char *from;		/* used to copy out of l_arg and on_fly */
	int  wstatus;		/* hold wait system call status return */
	char recursiv;		/* set if menu to be called */

	pb = pbuffer;
	putchar('\n');
	recursiv = *(p->l_prgm) == MENU_CHAR;	/* recursive call */
	if ( !recursiv && *answer) {
		printf("Too many numbers entered--ignoring \"%s\"\n",
				answer - 1);
		answer = "";
		return (1);
	}
	printf(p->l_menu + 6);		/* display the choice */
	if (p->l_various & L_NEEDPR) {	   /* do we do prompts? */
		pb = pbuffer;	/* allocate from start */
		for (i = 0; i < 10; i++)
			on_fly[i] = NULL;	/* assume null responses */
		for (i = 0;; i++) {
			j = p->l_flag[i];
			if (j & L_DONE)
				break;		/* only way to break loop */
			if (!(j & L_PROMPT))
				continue;
			if (j & L_REDIR) {	/* type o prompt */
				do printf(RE_MSG);
				   while (getstrs(pb) != 2
					|| (*pb != 'y' && *pb != 'n'));
				if (*pb == 'n')
				   continue;	/* don't redir */
				p->l_various |= L_NEEDSH;  /* need shell */
			}
			on_fly[j & L_PNO] = pb;  /* point to answer */
			if (j & L_REDIR)
				*pb++ = '>';
			do printf("\n%s", p->l_arg[i]);  /* ask */
				while ((k = getstrs(pb)) <= 1 && !(j & L_DEFAULT));
			pb += k;
			*(pb - 1) = NULL;	/* answer end */
			if (k == 1)
				on_fly[j & L_PNO] = NULL;
		}
	}
	/* note that old version of this program accepted -s and -m
	   arguments.  The code below simply ignores these
	*/
	if (recursiv)
		for (i = 0;; i++) {
			j = p->l_flag[i];
			if (j & L_DONE) {
				printf(BAD_FILE);
				exit(EFORM);	/* no file to read */
			}
			if (j & (L_PRGM | L_PROMPT))
				continue;	/* not a real argument */
			if (k = j & L_PNO)
				file = on_fly[k];
			else
				file = p->l_arg[i];
			if (*file != '-')
				return( menu(level + 1, item));
		}

	if (  p->l_various & L_PROTECT ) {
		answer = "";	/* don't screw up next menu prompt */
		do printf("Are you sure? (y or n) ");
			while (getstrs(line) != 2
				|| (*line != 'y' && *line != 'n'));
		if (*line == 'n')
			return (1);	/* same menu level */
	}
	j = p->l_various;
	if (j & L_NEEDSH) {
		sstr = pb;	/* the command string goes here */
		for (i = 0;; i++) {
			j = p->l_flag[i];
			if (j & L_DONE)
				break;
			if ( j & L_PROMPT)	/* dummy arg */
				continue;
			from = (k = j & L_PNO) ? on_fly[k] : p->l_arg[i];
			if (from == NULL)
				continue;
			while (*pb++ = *from++);
			pb--;
			if ( !((j & L_RHTCAT) || (p->l_flag[i+1] & L_LFTCAT)) )
				*pb++ = ' ';
		}
		*(pb-1) = NULL;	/* end of command string */
		shell(sstr, p->l_dir);		/* run via shell */
		while (pid != wait(&wstatus));		/* wait for child to complete */
		if ((i = wstatus & 017)     /* aborted child ? */
			&& i != SIGINT)	/* allow break */
			printf("Program aborted with status %d\n", i);
		return (1);	/* stay at same menu level */
	}
	if (j & L_NEEDPR) {	/* must assemble args gotten from tty */
		pbptr = arg_list = (( (int) pb + ISIZE-1) / ISIZE) * ISIZE;
		for(i = 0;; i++) {
			j = p->l_flag[i];
			if (j & L_DONE)
				break;
			if (j & L_PROMPT)
				continue;	/* dummy arg */
			from = (k = j & L_PNO) ? on_fly[k] : p->l_arg[i];
			if (from)          /* don't use null arguments */
				*pbptr++ = from;
		}
		*pbptr = NULL;          /* terminate arg list */
	}
	else arg_list = p->l_arg;   /* simple case--already ordered */
	if ((pid = fork()) == 0) {
		signal(SIGINT, SIG_DFL);	/* accept break */
		if (p->l_dir && chdir(p->l_dir)) {
			printf("Could no change to directory %s\n", p->l_dir);
			exit (ENOENT);
		}
		execv(p->l_prgm, arg_list);	/* run the program */
		printf("Could not execute %s\n", p->l_prgm);
		exit(ENOENT);
	}
	while (pid != wait(&wstatus));		/* wait for child */
	if ((i = wstatus & 017) && i != SIGINT)
		printf("Program aborted with status %d\n", i);
	return (1);		/* stay at same menu level */
}
/*

Name:
	help

Function:
	Display one or more items from the help file.

Parameters:
	helpfile:	the file name to read
	anum:		the item number (0 == all)

Algorithm:
	Open help file.  Position at correct item (if single item requested),
	or fork off paging program (if all items requested).  Then read item(s)
	and write them to user, numbering them as you go.  Close file at end
	of file.

Returns:
	None.

Files and Programs:
	helpfile	name of help file
*/

help(helpfile, anum)
char *helpfile;
int anum;
{
	register int num;
	register int ii;
	register char *linep;
	int pip[2];
	int hsave;
	char sig_dect;		/* >0 if signal has been called */
	int sigcatch();		/* called if SIGPIPE occurs */

	num = anum;
	if ((ii = open(helpfile, 0)) < 0) {
		printf("No help information is available for this menu\n");
		return;
	}
	trdup(ii, help_fd);	/* make a tr stream for help info */
	linep = line;
	if(num) {
		for(ii=1; ii<num; ) {	/* position in menu file */
			if(getstr(help_fd,linep) == 0) {
				printf("Not enough entries in the help file\n");
				close (help_fd->ph_real);
				return;
			}
			if(*linep == ':')
				ii++;
		}
	}
	pipe(pip);
	if((pid = fork()) == 0) {
		close(0);       /* close standard input */
		dup(pip[0]);    /* standard input from pipe */
		close(pip[0]);  /* don't need this now */
		close(pip[1]);  /* parent does writing */
		signal(SIGINT, SIG_DFL);        /* accept break */
		execl(pgprgm, "more", 0);
		printf("Cannot find pg\n");
		exit(ENOEXEC);
	}
	/* parent */
	close(pip[0]);  /* child uses this */
	hsave = dup(1); /* save old standard output */
	close(1);               /* close old stdout */
	dup(pip[1]);            /* stdout to pipe */
	close(pip[1]);          /* not needed now */
	sig_dect = 0;           /* normal flow--not signal */
	setexit();              /* will save all registers */
	signal(SIGINT, SIG_IGN);        /* let broken pipe handle */
	signal(SIGPIPE, sigcatch);      /* return here on SIGPIPE */
	if (sig_dect++) {       /* signal or normal flow-thru */
		close(1);
		dup(hsave);     /* old stdout */
		close(hsave);
		close (help_fd->ph_real);
		signal(SIGPIPE, SIG_DFL);
		while (pid != wait(0));
		return;
	}
	for(ii=1; ii < 10; ii++) {
		printf("\n(%d)", num ? num : ii);
		for(;;) {
			if(getstr(help_fd,linep) == 0) {
				close (help_fd->ph_real);
				fflush(stdout);
				close(1);   /* pipe out */
				dup(hsave);     /* old stdout */
				close(hsave);
				signal(SIGPIPE, SIG_DFL);
				while (pid != wait(0));
				return;
			}
			if(*linep == ':') {
				if(num) {
					close (help_fd->ph_real);
					fflush(stdout);
					close(1);   /* pipe out */
					dup(hsave);     /* old stdout */
					close(hsave);
					signal(SIGPIPE, SIG_DFL);
					while (pid != wait(0));
					return;
				}
				else
					break;
			}
			printf("\t%s",linep);
		}
	}
}
/*

Name:
	new_dir

Function:
	Change working directory

Algorithm:
	Ask user for the name, then change to it.  If null response
	then change to $HOME and display message saying so.
	Execute run_pwd to get the new directory name.  Note that this
	is NOT the same as the user response if the user has included
	.. or . in his response.

*/

new_dir()

{
	register int num;
	int sig_detc;	/* >0 if signal has been called */
	int sigcatch();		/* routine to handle SIGINT */

	sig_detc = 0;
	setexit();	/* save registers */
	if (sig_detc++)
		return;		/* break received */
	for(;;) {
		printf("Directory name? ");
		num = getstrs(line);
		signal(SIGINT, SIG_IGN);
		line[num-1] = NULL;	/* don't use newline */
		if ( !chdir ( (num = num <= 1) ? home_dir : line) ) {
			if (num)
				printf("* Changing to home directory %s *\n",
					home_dir);
			break;
		}
		printf("* Invalid Directory Name *\n");
		signal(SIGINT, sigcatch);	/* restore registers on break */
	}
	run_pwd();		/* get the new directory's name */
}
/*

Name:
	shell

Function:
	Fork a shell to do something.  This routine does NOT call wait;
	the caller of this routine must provide for the waiting.

Arguments:
	cmnd:   A pointer to a char string.  If the string is null, fork an
	interactive shell.  Otherwise, fork a shell with -c argument
	to evaluate the string.
	dir:  the directory to change to or NULL for don't change.
*/

shell(cmnd, dir)

char   *cmnd;		/* command string; may be null */
char   *dir;		/* directory to change to or NULL for none */

{
	if ((pid = fork()) == 0) {
		if (dir && chdir(dir)) {
			printf("Could not find directory %s\n", dir);
			exit (ENOENT);
		}
		signal(SIGINT, SIG_DFL);	/* accept break */
		if (*cmnd)
			execl(shprgm, "shell(menu)", "-c", cmnd, 0);
		else
			execl(shprgm, "shell(menu)", 0);
		printf("Could not execute %s\n", shprgm);
		exit(ENOENT);
	}
}
/*

Name:
	run_pwd

Function:
	Get the current working directory and put its name in work_dir.

Algorithm:
	Fork a pwd process and pipe its standard output back to this
	process.


*/
run_pwd()
{
	int pp[2];	/* the pipe descriptors */
	register int num;
	int wstatus;		/* holds child status data */

	if (pipe(pp)) {
		printf("Could not create pipe\n");
		exit (EPIPE);
	}
	if ((pid = fork()) == 0) {
		close (pp[0]);		/* parent will read */
		dup2(pp[1], 1);		/* make stdout to pipe */
		close (pp[1]);		/* only one writer to pipe */
		execl("/bin/pwd", "menu(pwd)", 0);
		write(2, NOPWD, sizeof(NOPWD));
		exit (ENOENT);
	}
	close (pp[1]);		/* child will write */
	while (pid != wait(&wstatus));
	if (wstatus) {
		printf("pwd termination status = %d\n", wstatus & 017);
		printf("    exit code = %d\n", wstatus >> 8);
		printf("aborting menu program due to software problems\n");
		exit (EOTHER);
	}
	num = read (pp[0], work_dir, sizeof (work_dir) - 1);
	work_dir[num] = NULL;		/* end of string */
	close(pp[0]);		/* close the pipe */
}
/*

Name:
	trdup

Function:
	Call dup to duplicate an open file descriptor, then
	associates a tr type stream with that descriptor.
	This routine works with the macro gettr and the routine ph_filbuf
	to provide the gettr caller with characters which
	have had environment parameters translated.
	Its intent is silimar to freopen.  (See UPM fopen sec. 3.)

Parameters:
	The file descriptor to use.
	The pointer to the i/o structre (PHFILE) to use.


Algorithm:
	Allocates a phony file structre of format ph_file.  The ph_real
	element points to the real file descriptor.  The ph_cnt
	shows the number of items in the forward buffer.  The ph_ptr
	points to the first unscanned character in the ph_input.
	ph_incnt is the unscanned character count.
*/


trdup(desc, phony)

int	desc;
PHFILE  *phony;

{

	phony->ph_real = desc;
	phony->ph_cnt = 0;	/* no data gotten */
	phony->ph_incnt = 0;
	phony->ph_eof = 0;
}
/*

Name:
	tr_filbuf

Function:
	Provided needed data to the gettr macro.  This routine is
	somewhat similar to _filbuf in the standard i/o package.

Parameters:
	a PHFILE pointer to indicate which file is to be read.

Returns:
	EOF for end of file.
	A character otherwise.

Algorithm:
	Assumed only called if the ph_cnt is <= zero.  One of two
	things can have happened.  Either the pb_buf is exhausted
	but there are characters in the ph_input, or there
	are no characters in core at all.
	In the latter case, a read must be issued.  In the former,
	pointers must be changed and possibly data must be
	translated according to the environment.
	Note that there is special translation for the character string
	$MENU.  This is translated as MENU_CHAR, which serves to tell
	the do_item program to invoke menu recursively rather than
	causing a fork and execl to occur.

	Note that all input of the form $name is translated
	according to the environment.
*/
tr_filbuf( fp )

PHFILE *fp;

{
	register char *p, *pfirst, *plast;
	char  *name;
	register char c;
	register int size;
	EVLIST where;		/* points to environ slot */
	static char str_menu[] = {MENU_CHAR, NULL};

	if ((size = fp->ph_incnt) <= 0)
		if ( fp->ph_eof || (size = read(fp->ph_real,
				fp->ph_input, PHINSIZE)) <= 0) {
			if (fp != stdtr)
				fp->ph_eof = 1;  /* from now on get EOF */
			return(EOF);
		}
		else p = pfirst = fp->ph_input;
	else p = pfirst = fp->ph_inptr;	/* where to start scan */
	plast = pfirst + size;
	--p;		/* note ++ in next statement */
	while (p < plast && *++p != '$');
	if (p > pfirst) {	/* some non-dollar data */
		fp->ph_cnt = p - pfirst - 1;	/* chars up to dollar */
		fp->ph_ptr = pfirst + 1;
		fp->ph_incnt = plast - p;	/* remaining chars */
		fp->ph_inptr = p;	/* points to $ */
		return (*pfirst);	/* return one char */
	}

	/* first character to be scanned is a dollar sign.
	   if too few characters, move down to beginning of
	   buffer and read some more.  (There must be a separator
	   after the $ to delimit the name.
	*/

	do if (++p >= plast) {
		p = pfirst;
		pfirst = fp->ph_input;
		while (p < plast)
			*pfirst++ = *p++;
		p = pfirst;
		pfirst = fp->ph_input;
		size = read(fp->ph_real, p,
			PHINSIZE - (p - pfirst) );
		plast = p + size;	/* end of data */
		if (size <= 0) {  /* end of file */
			fp->ph_eof = 1;
			break;
		}
	}  while (((c = *p) >= 'A' &&
			c <= 'Z' )
		|| (	c >= '0' &&
			c <= '9' )
		|| (	c >= 'a' &&
			c <= 'z' )
		||	c == '_'	);
	c = *p;		/* save this one */
	*p = NULL;	/* subenv needs this */
	name = subenv(++pfirst, environ, &where);	/* translate it */
	if (name == 0) {	/* not in environment */
		fp->ph_cnt = 0;
		fp->ph_incnt = plast - p - 1;
		fp->ph_inptr = p + 1;
		return (c);
	}
	if (where == menuslot)		/* recursive menu call */
		name = str_menu;	/* menu character string */
	*p = c;		/* restore delimiter */
	fp->ph_inptr = p;
	fp->ph_incnt = plast - p;
	fp->ph_ptr = name + 1;		/* start at 2nd char */
	fp->ph_cnt = strlen(name) - 1;	/* the rest of the string */
	return (*name);		/* voila--the first char is returned */
}
/*

Name:
	getstr

Function:
	get a string of characters by repeatedly calling gettr.
	returns when newline or end of file is reached.  The newline
	IS returned.

Arguments:
	fp:	PHFILE pointer to read from
	where:	char pointer for where to put the characters

Returns:
	number of characters returned or zero if end of file.
*/

getstr(fp, where)

PHFILE  *fp;
char    *where;

{
	register char *p;
	register int c;

	p = where;
	while ((*p++ = c = gettr(fp)) != '\n' && c != EOF);
	if (c == EOF)
		p -= 1;		/* don't count EOF */
	*p = NULL;
	return ( (int) (p - where) );
}
/*

Name:
	copy

Function:
	copy one string to another, with no overflow checking.

Returns:
	Pointer to the NULL terminator at the copy.


*/
char *copy(a,b)
char *a, *b;
{
	register char *c, *d;

	c = a;
	d = b;
	while(*d++ = *c++);
	return (d-1);
}
/*

Name:
	sigquit

Function:
	called when SIGQUIT received.  list all open files' i-nodes,
	and call abort, which will dump core.
*/

sigquit()
{
	register int i,k;

	printf("\nProgram being aborted by SIGQUIT\n\n");
	printf("i-nodes for open file descriptors:\n\n");
	for (i = 0; i < _NFILE; i++) {
		if ( !(k = fstat(i, &stat)) ) {
			if (i < 10)
				putchar(' ');
			printf("%d) %d\n", i, stat.st_ino);
		}
	}
#ifdef TRACE
	fclose (fptrace);
#endif
	signal(SIGQUIT, SIG_DFL);
	abort();
}
/*

Name:
	ecreate

Function:
	create the new environment for running this routine and its children

Algorithm:
	Take list in array new and merge with
	environment pointed to by the global variable environ.
	Then set environ to point to the new environment.
	If a variable is defined in the old environment, keep its
	old value, otherwise add its new one.

Comments:
	Note that the list of pointers in new must consist of all names
	to be added, followed by zero.
	The routine calloc is explained in the UPM section 3 under malloc.
	Note that the spot normally held by the equal sign must be
	a NULL.  The program replaces the NULL.

*/
ecreate()
{
	static char v1[] = "APPTIMES\0/u/jan/utmost/stand.appt";
	static char v2[] = "CAL3MONTH\0/u/jan/utmost/cal.3.month";
	static char v3[] = "EXECDIR\0/u/jan/utmost/es.code/exec.dir";
	static char vmenu[] = "MENU\0";
	static char v5[] = "MENUDIR\0/u/jan/utmost/menus";
	static char v6[] = "NL\0\n";
	static char v7[] = "PG\0/usr/bin/more";
	static char v8[] = "SHELL\0/bin/sh";
	static char v9[] = "UTDOC\0/u/jan/utmost/menu.1.n";

	static PCHAR new[] = {v1, v2, v3, vmenu, v5, v6, v7, v8, v9, 0};
		/* Note that PCHAR == char *  */
	register EVLIST olde, newe, merge, origne;
	extern EVLIST menuslot;
	extern EVLIST environ;		/* environment pointer */
	register char *cp;

	olde = environ;		/* pointer to old environment */
	while (*olde++);
	merge = calloc( (int) (olde - environ) + sizeof (new) / sizeof(PCHAR),
		sizeof(EVLIST));
	origne = olde = environ;
	environ = merge;	/* new environment for children */
	newe = new;
	while (*merge++ = *olde++);	/* copy old environment */
	merge--;
	while (*newe) {
		if (!subenv(*newe, origne, NULL) ) {
			*(index(*newe, NULL)) = '=';
			*merge++ = *newe;
		}
		newe++;
	}
	*merge = NULL;		/* environment list termination */
	subenv("MENU", environ, &menuslot);
}
/*

Name:
	sigcatch


Function:
	Called in some case when SIGINT occurs.  (At other times
	it is ignored.)  Also called for SIGPIPE during help.  (Other
	SIGPIPE's will get SIG_DFL treatment.)  If tracing, a trace
	record is written.  Next,
	reset is called, which reloads setexit's saved
	registers.  Thus there is no return from reset.
	Before calling signal to catch a signal and route it here
	setexit must have been called.

*/
sigcatch(signo)

int signo;		/* the signal number */

{


	signal(SIGINT, SIG_IGN);
#ifdef TRACE
	time(&after);         /* get the time */
	fprintf( fptrace, "%d\n%s",
		after.time - before.time,
		(signo == SIGPIPE) ? "SIGPIPE\n" : "SIGINT\n" );
#endif
	answer = "";	/* discard any typed ahead menu responses */
	reset();	/* no return to here */
		/* return from reset acts like a return from setexit */
}
