/*

Name:
	valid_date

Function:
	Determine if a date is valid and fill in the user supplied buffer with
	a standardized date in the format ddmmm

Algorithm:
	Use the library subroutine getdate to determine if the date is valid.
	If it is then determine if the day is within the range of dates in the
	month. If it is not return a false. If it is then fill in the user
	supplied array with the standardized date in the format ddmmm and 
	return the number of the month.

Parameters:
	date		the date to be checked
	outdate		the user supplied array to store the standardized date
	julian_flag	indicates whether to add the year on the end of the date
			or not

Returns:
	The number of the month or a zero (if the date was invalid)

Files and Programs:
	None


*/
#include <stdio.h>
#define ALPHA   01
#define NUMER   02
#define DELIM   04
#define COLON  010
#define INVAL   00
#define ON      1
#define OFF     0

    extern int typeof();

char *valid_date (date, outdate, julian_flag)
char   *date,						/* Pointer to the date  */
       *outdate;					/* Pointer to storage for the standardized date */
int     julian_flag;					/* Indicates if the year should be added or not */
{
    static char id[] = "%W% %H%";
    static char month[3];				/* Holds the 2 digit month number */
    char   *yymmdd,					/* Pointer to date in format yymmdd */
           *end_ptr,					/* Pointer into checkdate and also outdate */
            daynumb[3],					/* Holds the 2 digit day number */
            checkdate[15];				/* The date to be checked */
    extern char *copy();
    extern char *getdate();
    extern char *get_year();
    extern char *month_name();

    int num1indx,
	num2indx,
	num3indx,
	alp1indx,
	count,
	newfield,
	no_dlm,
	i,
	firstchar_type;
    char t[10];
    end_ptr = copy (date, checkdate);
    i = 0;
    no_dlm = 0;
    count = newfield = 0;
    num1indx = num2indx = num3indx = alp1indx = 0;
    firstchar_type = typeof (*(date + i));
    while (*(date + i)) {
	  switch (typeof (*(date + i))) {
	       case NUMER:
		    if (alp1indx > 1 && newfield == ON && num2indx < 1 && firstchar_type != ALPHA) {
			    newfield = OFF;
			    count++;
			    i++;
			    break;


		    }
		   if (count == 0) {
			    num1indx++;
			    i++;
			    newfield = ON;
			    break;
		    }
		    if (count == 1) {
			    num2indx++;
			    i++;
			    newfield = ON;
			    break;
		    }
		    if (count == 2) {
			    num3indx++;
			    i++;
			    newfield = ON;
			    break;
		    }
	    case ALPHA:
		    alp1indx++;
		    i++;
		    newfield = ON;
		    break;
	    case DELIM:
		    if (newfield == ON) {
			    no_dlm++;
			    newfield = OFF;
			    count++;
			    i++;
			    break;
		    }
		    else {
			    i++;
			    break;
		    }
	    case INVAL:
	    case COLON:
		    return (NULL);
	   }
     }
    if (no_dlm == 1 && newfield == ON){
	for (i=0; *(date + i) != '\0'; i++){
	    if (*(date + i) == '/') {
		*end_ptr++ = '/';
		break;
	    }
	    else
	       if (*(date + i) == '-') {
		   *end_ptr++ = '-';
		   break;
	       }
	       else
		  if (*(date + i) == ',') {
		      *end_ptr++ = ',';
		      break;
		  }
		  else
		     if (*(date + i) == ' ') {
			 *end_ptr++ = ' ';
			 break;
		     }
       }
    }

    if (no_dlm == 2 && newfield == ON)
       julian_flag = 1;


    if (no_dlm == 0 && num2indx == 1)
       julian_flag = 1;



    if (julian_flag != 1)
	end_ptr = copy (get_year (), end_ptr);                    /* Add the year to the end of the date received from the calling program */
    yymmdd = getdate (checkdate);
    if (!yymmdd)
	return (0);					/* Invalid date format */
    else
    {
/* Separate the date in the format yyddmm into individual components */
	yymmdd + = 2;
	month[0] = *yymmdd++;
	month[1] = *yymmdd++;
	month[2] = '\0';
	daynumb[0] = *yymmdd++;
	daynumb[1] = *yymmdd;
	daynumb[2] = '\0';
	if (ddmm_valid (atoi (daynumb), atoi (month)))
	{						/* Date is valid */
	    end_ptr = copy (daynumb, outdate);		/* Standardize date format */
	    end_ptr = copy (month_name (atoi (month)), end_ptr);
	}
	else
	    return (0);                                 /* Invalid date format */
    }
    return (month);
}
